#ifndef PL_TXRATEMATCHER_H
#define PL_TXRATEMATCHER_H

#include "hw_def.h"
#include "math.h"
#ifndef IS_DATAFLOW
#ifndef IS_BARE


#define MAX_RATE 3
#define MAX_DataLength 2368
#define MAX_LastBlockLen 6143
//#define MAX_NumBlock (MAX_DataLength/6144)+1
#define MAX_NumBlock 2
#define MAX_Layer  2
#define MAX_MDFT 75
#define MAX_SYM 14
#define MAX_QAMLen MAX_MDFT*(MAX_SYM-2)
#define MAX_MQAM 16
#define MAX_LOG_MQAM 4
#define MAX_BitsPerSymb MAX_LOG_MQAM
#define MAX_NInfoBits MAX_QAMLen*MAX_BitsPerSymb
//#define MAX_EncDataLen (MAX_NumBlock)*(6144*MAX_RATE+12)
#define MAX_EncDataLen 36888
#define MAX_EncLen 3*MAX_DataLength+12


#define MAX_C_sb 32
//#define MAX_R_sb (6148/MAX_C_sb)+1
#define MAX_R_sb 193
#define MAX_K_pi MAX_C_sb*MAX_R_sb

struct myComplex
{
    float re;
    float im;
};

void hardware_TxRateMatching(
        int hardware_NumBlock,
        int hardware_Rate,
        int hardware_NumExtraBits,
        int hardware_pcMatrix[MAX_RATE][MAX_NumBlock*6148],
        int hardware_pLengthSet[MAX_NumBlock],
        int hardware_pEncS[MAX_EncLen],
        int hardware_pcSeq[MAX_Layer*MAX_NInfoBits],
        int SbInterleaver_C_sb,
        int SbInterleaver_Rate,
        int SbInterleaver_InterColumnPattern [32]);

void Hardware_SubblockInterleaving(
        int SeqLen,
        int C_sb,
        int Rate,
        int pInpMtr [MAX_RATE][6144+4],
        int pOutMtr [MAX_RATE][6144+4],
        int InterColumnPattern [32]);

#endif
#endif

#endif // PL_TXRATEMATCHER_H
