#include "Pl_TxRateMatcher.h"
#ifndef IS_DATAFLOW
#ifndef IS_BARE


void Hardware_SubblockInterleaving(int SeqLen,
                                   int C_sb,
                                   int Rate,
                                   int pInpMtr [MAX_RATE][6144+4],
                                   int pOutMtr [MAX_RATE][6144+4],
                                   int InterColumnPattern [32])
{
    int D=SeqLen;
    int R_sb=(int)(ceil((((double)D)/((double)C_sb))));
    int K_pi=R_sb*C_sb;
    int NumDummy=K_pi-D;
    int OutIdx;
    //////////////////// Interleaving for i=0,1 ///////////////////////
    int pInterMatrix[MAX_R_sb][MAX_C_sb];

    int *VpInpSeq;
    int *VpOutSeq;
    int DummyValue = 1000000;

    for(int StrIdx=0;StrIdx<(Rate-1);StrIdx++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
    #endif
        VpInpSeq=pInpMtr[StrIdx];
        VpOutSeq=pOutMtr[StrIdx];
        //////////////// write into matrix //////////////////
        for(int r=0;r<R_sb;r++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_R_sb)
        #endif
            for(int c=0;c<C_sb;c++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_C_sb)
            #endif
                int k=r*C_sb+c;
                if(k<NumDummy)
                {
                    pInterMatrix[r][c]=DummyValue;
                }
                else
                {
                    pInterMatrix[r][c]=VpInpSeq[k-NumDummy];
                }
            }
        }
        ////////////// Read out matrix ///////////////////////
        OutIdx=0;
        for(int c=0;c<C_sb;c++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_C_sb)
        #endif
            int col = InterColumnPattern[c];
            for(int r=0;r<R_sb;r++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_R_sb)
            #endif
                int v = pInterMatrix[r][col];
                if(v!=DummyValue)
                {
                    VpOutSeq[OutIdx]=v;
                    OutIdx++;
                }
            }
        }
    }
//////////////////// Interleaving for i=2 ///////////////////////
    int Pi[MAX_K_pi];
    int pInterSeq[MAX_K_pi];
    VpInpSeq=pInpMtr[Rate-1];
    VpOutSeq=pOutMtr[Rate-1];
    for(int k=0;k<K_pi;k++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
    #endif
        pInterSeq[k]=(k<NumDummy)?DummyValue:VpInpSeq[k-NumDummy];
    }
    //////////////// Pi //////////////////
    for(int k=0;k<K_pi;k++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
    #endif
        int idxP=(int)(floor((((double)(k))/((double)(R_sb)))));
        int idx = ((InterColumnPattern[idxP])+(C_sb*(k%R_sb))+1)%K_pi;
        Pi[k]=idx;
    }
/////////////// Interleaving ////////////////////
OutIdx=0;
for(int k=0;k<K_pi;k++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
    #endif
    int v = pInterSeq[Pi[k]];
    if(v!=DummyValue)
        {
        VpOutSeq[OutIdx]=v;
        OutIdx++;
        }
    }
}


void hardware_TxRateMatching(
        int hardware_NumBlock,
        int hardware_Rate,
        int hardware_NumExtraBits,
        int hardware_pcMatrix[MAX_RATE][MAX_NumBlock*6148],
        int hardware_pLengthSet[MAX_NumBlock],
        int hardware_pEncS[MAX_EncLen],
        int hardware_pcSeq[MAX_Layer*MAX_NInfoBits],
        int SbInterleaver_C_sb,
        int SbInterleaver_Rate,
        int SbInterleaver_InterColumnPattern [32])
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=hardware_NumBlock
#pragma HLS INTERFACE s_axilite port=hardware_Rate
#pragma HLS INTERFACE s_axilite port=hardware_NumExtraBits
#pragma HLS INTERFACE s_axilite port=SbInterleaver_C_sb
#pragma HLS INTERFACE s_axilite port=SbInterleaver_Rate
#pragma HLS RESOURCE variable=hardware_pcMatrix core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pLengthSet core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pEncS core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pcSeq core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=SbInterleaver_InterColumnPattern core=RAM_1P_BRAM
#endif
    ////////////// Start Rate Matching ///////////
    int EncSK=hardware_pLengthSet[0]+4;
    for(int i=0;i<EncSK;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_EncLen)
    #endif
        for(int r=0;r<hardware_Rate;r++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
        #endif
            hardware_pEncS[i*hardware_Rate+r]=hardware_pcMatrix[r][i];
        }
    }

    for(int nBlock=0;nBlock<hardware_NumBlock;nBlock++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_NumBlock)
    #endif
        int iSeqLength=*(hardware_pLengthSet+nBlock);
        int InpBlockShift = nBlock*(6144+4);
        int OutBlockShift = nBlock*(6144*hardware_Rate+12);

        /////////////////// TxRateMatch this block /////////////////////
        int pInMatrix[MAX_RATE][6148];
        int pOutMatrix[MAX_RATE][6148];
        for(int r=0;r<hardware_Rate;r++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
        #endif
            for(int i=0;i<iSeqLength+4;i++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=6148)
            #endif
                pInMatrix[r][i]=hardware_pcMatrix[r][InpBlockShift+i];
            }
        }


        ////////////////////// Subblock Interleaver //////////////////////////
        Hardware_SubblockInterleaving(iSeqLength+4,
                                       SbInterleaver_C_sb,
                                       SbInterleaver_Rate,
                                       pInMatrix,
                                       pOutMatrix,
                                       SbInterleaver_InterColumnPattern);



        for(int r=0;r<hardware_Rate;r++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
        #endif
        for(int i=0;i<iSeqLength+4;i++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=6148)
            #endif
                hardware_pcMatrix[r][InpBlockShift+i]=pOutMatrix[r][i];
            }
        }


        for(int i=0;i<iSeqLength+4;i++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=6148)
        #endif
        hardware_pcSeq[OutBlockShift+3*i+0]=hardware_pcMatrix[0][InpBlockShift+i];
        hardware_pcSeq[OutBlockShift+3*i+1]=hardware_pcMatrix[1][InpBlockShift+i];
        hardware_pcSeq[OutBlockShift+3*i+2]=hardware_pcMatrix[2][InpBlockShift+i];
        }
    }
    for(int i=0;i<hardware_NumExtraBits;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_Layer*MAX_NInfoBits)
    #endif
        hardware_pcSeq[((hardware_NumBlock-1)*(6144*hardware_Rate+12)+1*((*(hardware_pLengthSet+hardware_NumBlock-1))*hardware_Rate+12))+i]=0;
    }
    return;
}

#endif
#endif
