#include "Df_TxRateMatcher.h"
#ifndef IS_PIPELINE
#ifndef IS_BARE



void Hardware_SubblockInterleaving_f1(
        int InterColumnPattern [32],
        int InterColumnPattern_Out [32],
        int pInpMtr [MAX_RATE][6144+4],
        int pInterMatrix[MAX_RATE-1][MAX_R_sb][MAX_C_sb],
        int Pi[MAX_K_pi],
        int pInterSeq[MAX_K_pi],
        int C_sb,
        int* C_sb_Out,
        int Rate,
        int* Rate_Out,
        int nBlock_In,
        int* nBlock_Out,
        int hardware_Rate_In,
        int* hardware_Rate_Out,
        int SeqLen,
        int* SeqLen_Out
    )
{

    *C_sb_Out = C_sb;
    *Rate_Out = Rate;
    *nBlock_Out = nBlock_In;
    *hardware_Rate_Out = hardware_Rate_In;
    *SeqLen_Out = SeqLen;
    for(int i=0; i<32; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    #endif
        InterColumnPattern_Out[i] = InterColumnPattern[i];
    }

    int D=SeqLen+4;
    int R_sb=(int)(ceil((((double)D)/((double)C_sb))));
    int K_pi=R_sb*C_sb;
    int NumDummy=K_pi-D;
    int *VpInpSeq;
    int DummyValue = 1000000;
    // Interleaving for i=0,1
    for(int StrIdx=0;StrIdx<(Rate-1);StrIdx++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
    #endif
        VpInpSeq=pInpMtr[StrIdx];
        //////////////// write into matrix //////////////////
        for(int r=0;r<R_sb;r++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_R_sb)
        #endif
            for(int c=0;c<C_sb;c++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_C_sb)
            #endif
                int k=r*C_sb+c;
                if(k<NumDummy)
                {
                    pInterMatrix[StrIdx][r][c]=DummyValue;
                }
                else
                {
                    pInterMatrix[StrIdx][r][c]=VpInpSeq[k-NumDummy];
                }
            }
        }
    }

    // Interleaving for i=2
    VpInpSeq=pInpMtr[Rate-1];
    for(int k=0;k<K_pi;k++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
    #endif
        pInterSeq[k]=(k<NumDummy)?DummyValue:VpInpSeq[k-NumDummy];
    }
    //////////////// Pi //////////////////
    for(int k=0;k<K_pi;k++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
    #endif
        int idxP=(int)(floor((((double)(k))/((double)(R_sb)))));
        int idx = ((InterColumnPattern[idxP])+(C_sb*(k%R_sb))+1)%K_pi;
        Pi[k]=idx;
    }
}




void Hardware_SubblockInterleaving_f2(
        int InterColumnPattern [32],
        int pInterMatrix[MAX_RATE-1][MAX_R_sb][MAX_C_sb],
        int Pi[MAX_K_pi],
        int pInterSeq[MAX_K_pi],
        int pOutMtr [MAX_RATE][6144+4],
        int C_sb,
        int Rate,
        int nBlock_in,
        int* nBlock_out,
        int hardware_Rate_in,
        int* hardware_Rate_out,
        int SeqLen,
        int* SeqLen_out)
{


    *SeqLen_out = SeqLen;
    *hardware_Rate_out = hardware_Rate_in;
    *nBlock_out = nBlock_in;

    int D=SeqLen+4;
    int R_sb=(int)(ceil((((double)D)/((double)C_sb))));
    int K_pi=R_sb*C_sb;
    int OutIdx;
    //////////////////// Interleaving for i=0,1 ///////////////////////
    int *VpOutSeq;
    int DummyValue = 1000000;

    for(int StrIdx=0;StrIdx<(Rate-1);StrIdx++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
    #endif
        VpOutSeq=pOutMtr[StrIdx];
        OutIdx=0;
        for(int c=0;c<C_sb;c++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_C_sb)
        #endif
            int col = InterColumnPattern[c];
            for(int r=0;r<R_sb;r++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_R_sb)
            #endif
                int v = pInterMatrix[StrIdx][r][col];
                if(v!=DummyValue)
                {
                    VpOutSeq[OutIdx]=v;
                    OutIdx++;
                }
            }
        }
    }
    //////////////////// Interleaving for i=2 ///////////////////////
    VpOutSeq=pOutMtr[Rate-1];
    OutIdx=0;
    for(int k=0;k<K_pi;k++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
        #endif
        int v = pInterSeq[Pi[k]];
        if(v!=DummyValue)
            {
            VpOutSeq[OutIdx]=v;
            OutIdx++;
            }
        }
}


void Hardware_SubblockInterleaving(int SeqLen,
                                   int C_sb,
                                   int Rate,
                                   int pInpMtr [MAX_RATE][6144+4],
                                   int pOutMtr [MAX_RATE][6144+4],
                                   int InterColumnPattern [32])
{
    int D=SeqLen;
    int R_sb=(int)(ceil((((double)D)/((double)C_sb))));
    int K_pi=R_sb*C_sb;
    int NumDummy=K_pi-D;
    int OutIdx;
    //////////////////// Interleaving for i=0,1 ///////////////////////
    int pInterMatrix[MAX_R_sb][MAX_C_sb];

    int *VpInpSeq;
    int *VpOutSeq;
    int DummyValue = 1000000;

    for(int StrIdx=0;StrIdx<(Rate-1);StrIdx++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
    #endif
        VpInpSeq=pInpMtr[StrIdx];
        VpOutSeq=pOutMtr[StrIdx];
        //////////////// write into matrix //////////////////
        for(int r=0;r<R_sb;r++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_R_sb)
        #endif
            for(int c=0;c<C_sb;c++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_C_sb)
            #endif
                int k=r*C_sb+c;
                if(k<NumDummy)
                {
                    pInterMatrix[r][c]=DummyValue;
                }
                else
                {
                    pInterMatrix[r][c]=VpInpSeq[k-NumDummy];
                }
            }
        }
        ////////////// Read out matrix ///////////////////////
        OutIdx=0;
        for(int c=0;c<C_sb;c++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_C_sb)
        #endif
            int col = InterColumnPattern[c];
            for(int r=0;r<R_sb;r++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_R_sb)
            #endif
                int v = pInterMatrix[r][col];
                if(v!=DummyValue)
                {
                    VpOutSeq[OutIdx]=v;
                    OutIdx++;
                }
            }
        }
    }
//////////////////// Interleaving for i=2 ///////////////////////
    int Pi[MAX_K_pi];
    int pInterSeq[MAX_K_pi];
    VpInpSeq=pInpMtr[Rate-1];
    VpOutSeq=pOutMtr[Rate-1];
    for(int k=0;k<K_pi;k++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
    #endif
        pInterSeq[k]=(k<NumDummy)?DummyValue:VpInpSeq[k-NumDummy];
    }
    //////////////// Pi //////////////////
    for(int k=0;k<K_pi;k++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
    #endif
        int idxP=(int)(floor((((double)(k))/((double)(R_sb)))));
        int idx = ((InterColumnPattern[idxP])+(C_sb*(k%R_sb))+1)%K_pi;
        Pi[k]=idx;
    }
/////////////// Interleaving ////////////////////
OutIdx=0;
for(int k=0;k<K_pi;k++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
    #endif
    int v = pInterSeq[Pi[k]];
    if(v!=DummyValue)
        {
        VpOutSeq[OutIdx]=v;
        OutIdx++;
        }
    }
}


void hardware_MakePEncS(
        int hardware_pcMatrix[MAX_RATE][MAX_NumBlock*6148],
        int hardware_pLengthSet[MAX_NumBlock],
        int hardware_pEncS[MAX_EncLen],
        int hardware_Rate)
{
    int EncSK=hardware_pLengthSet[0]+4;
    for(int i=0;i<EncSK;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_EncLen)
    #endif
        for(int r=0;r<hardware_Rate;r++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
        #endif
            hardware_pEncS[i*hardware_Rate+r]=hardware_pcMatrix[r][i];
        }
    }
}



void hardware_ReadPcMatrix(
        int InterColumnPattern_In [32],
        int InterColumnPattern_Out [32],
        int hardware_pcMatrix[MAX_RATE][MAX_NumBlock*6148],
        int hardware_pLengthSet[MAX_NumBlock],
        int pInMatrix[MAX_RATE][6148],
        int SbInterleaver_C_sb_In,
        int* SbInterleaver_C_sb_Out,
        int SbInterleaver_Rate_In,
        int* SbInterleaver_Rate_Out,
        int nBlock,
        int* nBlock_Out,
        int hardware_Rate,
        int* hardware_Rate_Out,
        int* iSeqLength
        )
{
    for(int i=0; i<32; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    #endif
        InterColumnPattern_Out[i] = InterColumnPattern_In[i];
    }
    *nBlock_Out = nBlock;
    *hardware_Rate_Out = hardware_Rate;
    *SbInterleaver_C_sb_Out = SbInterleaver_C_sb_In;
    *SbInterleaver_Rate_Out = SbInterleaver_Rate_In;

    *iSeqLength=hardware_pLengthSet[nBlock];
    int InpBlockShift = nBlock*(6144+4);
    /////////////////// TxRateMatch this block /////////////////////


    for(int r=0;r<hardware_Rate;r++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
    #endif
        for(int i=0;i<(*iSeqLength)+4;i++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=6148)
        #endif
            pInMatrix[r][i]=hardware_pcMatrix[r][InpBlockShift+i];
        }
    }
}

void hardware_GetPcSeq(
        int pOutMatrix[MAX_RATE][6148],
        int hardware_pcSeq[MAX_Layer*MAX_NInfoBits],
        int nBlock,
        int hardware_Rate,
        int iSeqLength)
{
    int OutBlockShift = nBlock*(6144*hardware_Rate+12);
    for(int i=0;i<iSeqLength+4;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=6148)
    #endif
    hardware_pcSeq[OutBlockShift+3*i+0]=pOutMatrix[0][i]; //hardware_pcMatrix[0][InpBlockShift+i];
    hardware_pcSeq[OutBlockShift+3*i+1]=pOutMatrix[1][i]; //hardware_pcMatrix[1][InpBlockShift+i];
    hardware_pcSeq[OutBlockShift+3*i+2]=pOutMatrix[2][i]; //hardware_pcMatrix[2][InpBlockShift+i];
    }
}

void hardware_TxRateMatching(
        int hardware_NumBlock,
        int hardware_Rate,
        int hardware_NumExtraBits,
        int hardware_pcMatrix[MAX_RATE][MAX_NumBlock*6148],
        int hardware_pLengthSet[MAX_NumBlock],
        int hardware_pEncS[MAX_EncLen],
        int hardware_pcSeq[MAX_Layer*MAX_NInfoBits],
        int SbInterleaver_C_sb,
        int SbInterleaver_Rate,
        int SbInterleaver_InterColumnPattern [32])
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=hardware_NumBlock
#pragma HLS INTERFACE s_axilite port=hardware_Rate
#pragma HLS INTERFACE s_axilite port=hardware_NumExtraBits
#pragma HLS INTERFACE s_axilite port=SbInterleaver_C_sb
#pragma HLS INTERFACE s_axilite port=SbInterleaver_Rate
#pragma HLS RESOURCE variable=hardware_pcMatrix core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pLengthSet core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pEncS core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pcSeq core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=SbInterleaver_InterColumnPattern core=RAM_1P_BRAM
#endif
    ////////////// Start Rate Matching ///////////
    hardware_MakePEncS(hardware_pcMatrix, hardware_pLengthSet, hardware_pEncS, hardware_Rate);

    for(int nBlock=0;nBlock<hardware_NumBlock;nBlock++)
    {
    #ifdef IS_HLS
	#pragma HLS DATAFLOW
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_NumBlock)
    #endif
    int iSeqLength_1, iSeqLength_2, iSeqLength_3;
    int hardware_Rate_1, hardware_Rate_2, hardware_Rate_3;
    int nBlock_1, nBlock_2, nBlock_3;
    int SbInterleaver_C_sb_1, SbInterleaver_C_sb_2;
    int SbInterleaver_Rate_1, SbInterleaver_Rate_2;
    int SbInterleaver_InterColumnPattern_1[32];
    int SbInterleaver_InterColumnPattern_2[32];

    int pInMatrix[MAX_RATE][6148];
    int pInterMatrix[MAX_RATE-1][MAX_R_sb][MAX_C_sb];
    int Pi[MAX_K_pi];
    int pInterSeq[MAX_K_pi];
    int pOutMatrix[MAX_RATE][6148];

    hardware_ReadPcMatrix(
        SbInterleaver_InterColumnPattern,
        SbInterleaver_InterColumnPattern_1,
        hardware_pcMatrix,
        hardware_pLengthSet,
        pInMatrix,
        SbInterleaver_C_sb,
        &SbInterleaver_C_sb_1,
        SbInterleaver_Rate,
        &SbInterleaver_Rate_1,
        nBlock,
        &nBlock_1,
        hardware_Rate,
        &hardware_Rate_1,
        &iSeqLength_1);



    Hardware_SubblockInterleaving_f1(
                SbInterleaver_InterColumnPattern_1,
                SbInterleaver_InterColumnPattern_2,
                pInMatrix,
                pInterMatrix,
                Pi,
                pInterSeq,
                SbInterleaver_C_sb_1,
                &SbInterleaver_C_sb_2,
                SbInterleaver_Rate_1,
                &SbInterleaver_Rate_2,
                nBlock_1,
                &nBlock_2,
                hardware_Rate_1,
                &hardware_Rate_2,
                iSeqLength_1,
                &iSeqLength_2
                );


    Hardware_SubblockInterleaving_f2(
        SbInterleaver_InterColumnPattern_2,
        pInterMatrix,
        Pi,
        pInterSeq,
        pOutMatrix,
        SbInterleaver_C_sb_2,
        SbInterleaver_Rate_2,
        nBlock_2,
        &nBlock_3,
        hardware_Rate_2,
        &hardware_Rate_3,
        iSeqLength_2,
        &iSeqLength_3);


    hardware_GetPcSeq(
        pOutMatrix,
        hardware_pcSeq,
        nBlock_3,
        hardware_Rate_3,
        iSeqLength_3);

    }

    int offset = ((hardware_NumBlock-1)*(6144*hardware_Rate+12)+1*((*(hardware_pLengthSet+hardware_NumBlock-1))*hardware_Rate+12));
    for(int i=0;i<hardware_NumExtraBits;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_Layer*MAX_NInfoBits)
    #endif
        hardware_pcSeq[offset+i]=0;
    }
    return;
}

#endif
#endif
