#ifndef DF_TURBOENCODER_H
#define DF_TURBOENCODER_H

#include "hw_def.h"
#include "math.h"
#ifndef IS_PIPELINE
#ifndef IS_BARE

#define MAX_RATE 3
#define MAX_DataLength 2368
#define MAX_LastBlockLen 6143
#define MAX_BlockLen 6144
//#define MAX_NumBlock (MAX_DataLength/6144)+1
#define MAX_NumBlock 2
#define MAX_Layer  2
#define MAX_MDFT 75
#define MAX_SYM 14
#define MAX_QAMLen MAX_MDFT*(MAX_SYM-2)
#define MAX_MQAM 16
#define MAX_LOG_MQAM 4
#define MAX_BitsPerSymb MAX_LOG_MQAM
#define MAX_NInfoBits MAX_QAMLen*MAX_BitsPerSymb
#define MAX_EncDataLen (MAX_NumBlock)*(6144*MAX_RATE+12)
#define MAX_EncLen 3*MAX_DataLength+12
#define MAX_Itr 5

#define MAX_I 2
#define MAX_S 8
#define MAX_O 2

#define MAX_C_sb 32
//#define MAX_R_sb (6148/MAX_C_sb)+1
#define MAX_R_sb 193
#define MAX_K_pi MAX_C_sb*MAX_R_sb



struct myComplex
{
    float re;
    float im;
};


void hardware_Interleaving(
    int SeqLen,
    int inputShift,
    int pInpSeq [MAX_DataLength],
    int pOutSeq [6144],
    int paraTable[188][3]);

int hardware_maxElen(
    int num,
    int p[MAX_S*MAX_S],
    int pos,
    int space);

void Hardware_TurboEncoding(
    int hw_NumBlock,
    int hw_Rate,
    int hw_pLengthSet[MAX_NumBlock],
    int hw_piSeq[MAX_DataLength],
    int hw_pcSeq[3][MAX_NumBlock*(6144+4)],
    int FSM_I,
    int FSM_S,
    int FSM_pNS[MAX_I*MAX_S],
    int FSM_pOS[MAX_I*MAX_S],
    int FSM_pTMl[MAX_S*MAX_S],
    int FSM_pTMi[MAX_S*MAX_S],
    int paraTable[188][3]);

#endif
#endif

#endif // DF_TURBOENCODER_H
