#include "Df_TurboEncoder.h"
#ifndef IS_PIPELINE
#ifndef IS_BARE

void hardware_Interleaving(
        int  iSeqLength_In,
        int* iSeqLength_Out,
        int  hw_Rate_In,
        int* hw_Rate_Out,
        int  OutBlockShift_In,
        int* OutBlockShift_Out,
        int hw_pcSeq0_In[MAX_BlockLen],
        int hw_pcSeq0_Out[MAX_BlockLen],
        int hw_pcSeq1_In[MAX_BlockLen],
        int hw_pcSeq1_Out[MAX_BlockLen],
        int FSM_I_In,
        int FSM_S_In,
        int FSM_pNS_In[MAX_I*MAX_S],
        int FSM_pOS_In[MAX_I*MAX_S],
        int FSM_pTMl_In[MAX_S*MAX_S],
        int FSM_pTMi_In[MAX_S*MAX_S],
        int* FSM_I_Out,
        int* FSM_S_Out,
        int FSM_pNS_Out[MAX_I*MAX_S],
        int FSM_pOS_Out[MAX_I*MAX_S],
        int FSM_pTMl_Out[MAX_S*MAX_S],
        int FSM_pTMi_Out[MAX_S*MAX_S],
        int pT1_In[6],
        int pT1_Out[6],
        int pInpSeq [MAX_BlockLen],
        int pOutSeq [6144],
        int paraTable[188][3]
        )
{
    *iSeqLength_Out =  iSeqLength_In;
    *hw_Rate_Out = hw_Rate_In;
    *OutBlockShift_Out = OutBlockShift_In;
    *FSM_I_Out = FSM_I_In;
    *FSM_S_Out = FSM_S_In;

    for(int i=0; i<6; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_I*MAX_S)
    #endif
        pT1_Out[i] = pT1_In[i];
    }

    for(int i=0; i<FSM_I_In*FSM_S_In; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_I*MAX_S)
    #endif
        FSM_pNS_Out[i] = FSM_pNS_In[i];
        FSM_pOS_Out[i] = FSM_pOS_In[i];
    }
    for(int i=0; i<FSM_S_In*FSM_S_In; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S*MAX_S)
    #endif
        FSM_pTMl_Out[i] = FSM_pTMl_In[i];
        FSM_pTMi_Out[i] = FSM_pTMi_In[i];
    }
    for(int i=0; i<iSeqLength_In; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BlockLen)
    #endif
        hw_pcSeq0_Out[i] = hw_pcSeq0_In[i];
        hw_pcSeq1_Out[i] = hw_pcSeq1_In[i];
    }

    //************************ Permutation Pattern *****************************//
    int K = iSeqLength_In;
    int f1,f2;
    bool continueflag = 1;
    for(int idx = 187;idx>=0&&continueflag;idx--)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=188)
    #endif
        if(paraTable[idx][0]==iSeqLength_In)
            {
            f1 = paraTable[idx][1];
            f2 = paraTable[idx][2];
            continueflag = 0;
            }
    }
    int pPi[6148];
    long long tmp;
    for(int idx=0;idx<K;idx++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BlockLen)
    #endif
        tmp=((((long long)idx)*((long long)f1))+((((long long)idx)*((long long)idx))*((long long)f2)));
        pPi[idx]=(int)(tmp%((long long)K));
    }
    //********************* Start Interleaving ****************************//
    for(int idx=0;idx<K;idx++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BlockLen)
    #endif
        pOutSeq[idx] = pInpSeq[pPi[idx]];
    }
}

int hardware_maxElen(
        int num,
        int p[MAX_S*MAX_S],
        int pos,
        int space)
{
    int mamm = p[0];
    for(int i=0;i<num;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
    #endif
        mamm = (mamm>p[i*space+pos])?mamm:p[i*space+pos];
    }
    return mamm;
}


void Hardware_TurboEncoding_F1(
    int nBlock,
    int hw_pLengthSet[MAX_NumBlock],
    int* iSeqLength,
    int* OutBlockShift,
    int  hw_Rate_In,
    int* hw_Rate_Out,
    int FSM_I_In,
    int FSM_S_In,
    int FSM_pNS_In[MAX_I*MAX_S],
    int FSM_pOS_In[MAX_I*MAX_S],
    int FSM_pTMl_In[MAX_S*MAX_S],
    int FSM_pTMi_In[MAX_S*MAX_S],
    int* FSM_I_Out,
    int* FSM_S_Out,
    int FSM_pNS_Out[MAX_I*MAX_S],
    int FSM_pOS_Out[MAX_I*MAX_S],
    int FSM_pTMl_Out[MAX_S*MAX_S],
    int FSM_pTMi_Out[MAX_S*MAX_S],
    int paraTable_In[188][3],
    int paraTable_Out[188][3],
    int hw_piSeq[MAX_DataLength],
    int hw_piSeqOut[MAX_BlockLen],
    int hw_pcSeq0[MAX_BlockLen],
    int hw_pcSeq1[MAX_BlockLen],
    int pT1[6])
{
    *iSeqLength=hw_pLengthSet[nBlock];
    int InpBlockShift=nBlock*6144;
    *OutBlockShift=nBlock*(6144+4);

    *hw_Rate_Out = hw_Rate_In;
    *FSM_I_Out = FSM_I_In;
    *FSM_S_Out = FSM_S_In;

    for(int i=0; i<FSM_I_In*FSM_S_In; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_I*MAX_S)
    #endif
        FSM_pNS_Out[i] = FSM_pNS_In[i];
        FSM_pOS_Out[i] = FSM_pOS_In[i];
    }
    for(int i=0; i<FSM_S_In*FSM_S_In; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S*MAX_S)
    #endif
        FSM_pTMl_Out[i] = FSM_pTMl_In[i];
        FSM_pTMi_Out[i] = FSM_pTMi_In[i];
    }

    for(int i=0; i<188; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    #endif
        for(int j=0; j<3; j++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        #endif
            paraTable_Out[i][j] = paraTable_In[i][j];
        }
    }


    // Start Encoding this Block
    int cs;         //current state
    int ns;         //next state
    int isym;       //input symbol
    int osym;       //output symbol

    // rsc1
    cs=0;   //start from 0 state
    for(int i=0;i<(*iSeqLength);i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_NumBlock)
    #endif
        isym = hw_piSeq[InpBlockShift+i];
        hw_pcSeq0[i] = isym;
        hw_piSeqOut[i] = isym;
        ns  = FSM_pNS_In[(FSM_I_In)*cs+isym];
        osym = FSM_pOS_In[(FSM_I_In)*cs+isym];
        hw_pcSeq1[i]=osym;
        cs = ns;
    }

    // Adding termination
    int ends = cs; // ending state of Turbo saved in ends
    int maxLen = hardware_maxElen(FSM_S_In,FSM_pTMl_In,0,FSM_S_In);
    int ptaili[MAX_S];
    for(int numidx=0;numidx<maxLen;numidx++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
    #endif
        if(cs!=0)
        {
            ptaili[numidx]=FSM_pTMi_In[cs*FSM_S_In+0];
            cs = FSM_pNS_In[(FSM_I_In)*cs+ptaili[numidx]];
        }
        else
        {
            ptaili[numidx]=0;
        }
    }
    cs = ends; //start from last state to zero-state


    for(int i=0;i<maxLen;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
    #endif
        isym = ptaili[i];
        ns   = FSM_pNS_In[FSM_I_In*cs+isym];
        osym = FSM_pOS_In[FSM_I_In*cs+isym];
        pT1[2*i+0]=isym;
        pT1[2*i+1]=osym;
        cs = ns;
    }
}



void Hardware_TurboEncoding_F2_P1(
        int  iSeqLength_In,
        int* iSeqLength_Out,
        int  hw_Rate_In,
        int* hw_Rate_Out,
        int  OutBlockShift_In,
        int* OutBlockShift_Out,
        int hw_pcSeq0_In[MAX_BlockLen],
        int hw_pcSeq0_Out[MAX_BlockLen],
        int hw_pcSeq1_In[MAX_BlockLen],
        int hw_pcSeq1_Out[MAX_BlockLen],
        int pT1_In[6],
        int pT1_Out[6])
{
#ifdef IS_HLS
#pragma HLS INLINE off
#endif
    *iSeqLength_Out =  iSeqLength_In;
    *hw_Rate_Out = hw_Rate_In;
    *OutBlockShift_Out = OutBlockShift_In;

    for(int i=0; i<iSeqLength_In; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BlockLen)
    #endif
        hw_pcSeq0_Out[i] = hw_pcSeq0_In[i];
        hw_pcSeq1_Out[i] = hw_pcSeq1_In[i];
    }

    for(int i=0; i<6; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    #endif
        pT1_Out[i] = pT1_In[i];
    }
}

/*
void Hardware_TurboEncoding_F2_P2(
        int  iSeqLength_In,
        int FSM_I,
        int FSM_S,
        int FSM_pNS[MAX_I*MAX_S],
        int FSM_pOS[MAX_I*MAX_S],
        int FSM_pTMl[MAX_S*MAX_S],
        int FSM_pTMi[MAX_S*MAX_S],
        int piSeq2[6144],
        int pT2[6],
        int hw_pcSeq2[MAX_BlockLen])
{
    // Start Encoding this Block
    int cs;         //current state
    int ns;         //next state
    int isym;       //input symbol
    int osym;       //output symbol

    // rsc2
    cs = 0; //start from 0 state
    for(int i=0;i<iSeqLength_In;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BlockLen)
    #endif
        isym = piSeq2[i];
        ns  = FSM_pNS[FSM_I*cs+isym];
        osym = FSM_pOS[FSM_I*cs+isym];
        hw_pcSeq2[i]=osym;
        cs = ns;
    }

    // Adding termination
    int ends = cs;
    int maxLen = hardware_maxElen(FSM_S,FSM_pTMl,0,FSM_S);
    int ptail2i[MAX_S];
    for(int i=0;i<maxLen;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
    #endif
        if(cs!=0)
            {
            ptail2i[i]=FSM_pTMi[cs*FSM_S+0];
            cs = FSM_pNS[FSM_I*cs+ptail2i[i]];
            }
        else
            ptail2i[i]=0;
    }
    cs = ends; //start from last state to zero-state

    for(int i=0;i<maxLen;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
    #endif
        isym = ptail2i[i];
        ns  = FSM_pNS[FSM_I*cs+isym];
        osym = FSM_pOS[FSM_I*cs+isym];
        pT2[2*i+0]=isym;
        pT2[2*i+1]=osym;
        cs = ns;
    }

}
*/

void Hardware_TurboEncoding_F2_P3(
        int  iSeqLength_In,
        int FSM_I,
        int FSM_S,
        int FSM_pNS[MAX_I*MAX_S],
        int FSM_pOS[MAX_I*MAX_S],
        int FSM_pTMl[MAX_S*MAX_S],
        int FSM_pTMi[MAX_S*MAX_S],
        int piSeq2[6144],
        int pT2[6],
        int hw_pcSeq2[MAX_BlockLen])
{
#ifdef IS_HLS
#pragma HLS INLINE off
#endif
    // Start Encoding this Block
    int cs;         //current state
    int ns;         //next state
    int isym;       //input symbol
    int osym;       //output symbol

    // rsc2
    cs = 0; //start from 0 state
    for(int i=0;i<iSeqLength_In;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BlockLen)
    #endif
        isym = piSeq2[i];
        ns  = FSM_pNS[FSM_I*cs+isym];
        osym = FSM_pOS[FSM_I*cs+isym];
        hw_pcSeq2[i]=osym;
        cs = ns;
    }

    // Adding termination
    int ends = cs;
    int cs2 = cs;
    int maxLen = hardware_maxElen(FSM_S,FSM_pTMl,0,FSM_S);
    int ptail2i[MAX_S];
    for(int i=0;i<maxLen;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
    #endif
        if(cs!=0)
            {
            isym=FSM_pTMi[cs*FSM_S+0];
            cs = FSM_pNS[FSM_I*cs+isym];
            }
        else
            isym=0;

        ns  = FSM_pNS[FSM_I*cs2+isym];
        osym = FSM_pOS[FSM_I*cs2+isym];
        pT2[2*i+0]=isym;
        pT2[2*i+1]=osym;
        cs2 = ns;
    }
    /*
    cs = ends; //start from last state to zero-state

    for(int i=0;i<maxLen;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
    #endif
        isym = ptail2i[i];
        ns  = FSM_pNS[FSM_I*cs+isym];
        osym = FSM_pOS[FSM_I*cs+isym];
        pT2[2*i+0]=isym;
        pT2[2*i+1]=osym;
        cs = ns;
    }*/

}
void Hardware_TurboEncoding_F2(
        int  iSeqLength_In,
        int* iSeqLength_Out,
        int  hw_Rate_In,
        int* hw_Rate_Out,
        int  OutBlockShift_In,
        int* OutBlockShift_Out,
        int hw_pcSeq0_In[MAX_BlockLen],
        int hw_pcSeq0_Out[MAX_BlockLen],
        int hw_pcSeq1_In[MAX_BlockLen],
        int hw_pcSeq1_Out[MAX_BlockLen],
        int FSM_I,
        int FSM_S,
        int FSM_pNS[MAX_I*MAX_S],
        int FSM_pOS[MAX_I*MAX_S],
        int FSM_pTMl[MAX_S*MAX_S],
        int FSM_pTMi[MAX_S*MAX_S],
        int pT1_In[6],
        int pT1_Out[6],
        int piSeq2[6144],
        int pT2[6],
        int hw_pcSeq2[MAX_BlockLen])
{

    Hardware_TurboEncoding_F2_P1(
            iSeqLength_In,
            iSeqLength_Out,
            hw_Rate_In,
            hw_Rate_Out,
            OutBlockShift_In,
            OutBlockShift_Out,
            hw_pcSeq0_In,
            hw_pcSeq0_Out,
            hw_pcSeq1_In,
            hw_pcSeq1_Out,
            pT1_In,
            pT1_Out);

    Hardware_TurboEncoding_F2_P3(
            iSeqLength_In,
            FSM_I,
            FSM_S,
            FSM_pNS,
            FSM_pOS,
            FSM_pTMl,
            FSM_pTMi,
            piSeq2,
            pT2,
            hw_pcSeq2);

}


void Hardware_TurboEncoding_F3(
    int iSeqLength,
    int hw_Rate,
    int OutBlockShift,
    int hw_pcSeq0[MAX_BlockLen],
    int hw_pcSeq1[MAX_BlockLen],
    int hw_pcSeq2[MAX_BlockLen],
    int hw_pcSeq[3][MAX_NumBlock*(6144+4)],
    int pT1[6],
    int pT2[6]
        )
{

    for(int i=0;i<iSeqLength;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    	DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BlockLen)
    #endif
        hw_pcSeq[0][OutBlockShift+i] =  hw_pcSeq0[i];
        hw_pcSeq[1][OutBlockShift+i] =  hw_pcSeq1[i];
        hw_pcSeq[2][OutBlockShift+i] =  hw_pcSeq2[i];
    }


    for(int i=0;i<2;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    #endif
        hw_pcSeq[0][OutBlockShift+iSeqLength+i] =  pT1[i*hw_Rate+0];
        hw_pcSeq[1][OutBlockShift+iSeqLength+i] =  pT1[i*hw_Rate+1];
        hw_pcSeq[2][OutBlockShift+iSeqLength+i] =  pT1[i*hw_Rate+2];
        hw_pcSeq[0][OutBlockShift+iSeqLength+2+i] =  pT2[i*hw_Rate+0];
        hw_pcSeq[1][OutBlockShift+iSeqLength+2+i] =  pT2[i*hw_Rate+1];
        hw_pcSeq[2][OutBlockShift+iSeqLength+2+i] =  pT2[i*hw_Rate+2];
    }

}


void Hardware_TurboEncoding(
    int hw_NumBlock,
    int hw_Rate,
    int hw_pLengthSet[MAX_NumBlock],
    int hw_piSeq[MAX_DataLength],
    int hw_pcSeq[3][MAX_NumBlock*(6144+4)],
    int FSM_I,
    int FSM_S,
    int FSM_pNS[MAX_I*MAX_S],
    int FSM_pOS[MAX_I*MAX_S],
    int FSM_pTMl[MAX_S*MAX_S],
    int FSM_pTMi[MAX_S*MAX_S],
    int paraTable[188][3])
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=hw_NumBlock
#pragma HLS INTERFACE s_axilite port=hw_Rate
#pragma HLS INTERFACE s_axilite port=FSM_I
#pragma HLS INTERFACE s_axilite port=FSM_S
#pragma HLS RESOURCE variable=hw_pLengthSet core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hw_piSeq core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hw_pcSeq core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=FSM_pNS core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=FSM_pOS core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=FSM_pTMl core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=FSM_pTMl core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=paraTable core=RAM_1P_BRAM
#endif

    for(int nBlock=0;nBlock<hw_NumBlock;nBlock++)
    {
    #ifdef IS_HLS
	#pragma HLS DATAFLOW
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_NumBlock)
    #endif
        int hw_piSeqInt[MAX_BlockLen];
        int hw_pcSeq0_1[MAX_BlockLen];
        int hw_pcSeq0_2[MAX_BlockLen];
        int hw_pcSeq0_3[MAX_BlockLen];
        int hw_pcSeq1_1[MAX_BlockLen];
        int hw_pcSeq1_2[MAX_BlockLen];
        int hw_pcSeq1_3[MAX_BlockLen];
        int hw_pcSeq2[MAX_BlockLen];
        int pT1_1[6], pT1_2[6], pT1_3[6];
        int pT2[6];
        int piSeq2[6144];
        int paraTable_1[188][3];


        int FSM_I_1, FSM_I_2;
        int FSM_S_1, FSM_S_2;
        int FSM_pNS_1[MAX_I*MAX_S], FSM_pNS_2[MAX_I*MAX_S];
        int FSM_pOS_1[MAX_I*MAX_S], FSM_pOS_2[MAX_I*MAX_S];
        int FSM_pTMl_1[MAX_S*MAX_S], FSM_pTMl_2[MAX_S*MAX_S];
        int FSM_pTMi_1[MAX_S*MAX_S], FSM_pTMi_2[MAX_S*MAX_S];

        int iSeqLength, iSeqLength_2, iSeqLength_3;
        int hw_Rate_1, hw_Rate_2, hw_Rate_3;
        int OutBlockShift, OutBlockShift_2, OutBlockShift_3;

        Hardware_TurboEncoding_F1(
            nBlock,
            hw_pLengthSet,
            &iSeqLength,
            &OutBlockShift,
            hw_Rate,
            &hw_Rate_1,
            FSM_I,
            FSM_S,
            FSM_pNS,
            FSM_pOS,
            FSM_pTMl,
            FSM_pTMi,
            &FSM_I_1,
            &FSM_S_1,
            FSM_pNS_1,
            FSM_pOS_1,
            FSM_pTMl_1,
            FSM_pTMi_1,
            paraTable,
            paraTable_1,
            hw_piSeq,
            hw_piSeqInt,
            hw_pcSeq0_1,
            hw_pcSeq1_1,
            pT1_1);


        hardware_Interleaving(
                iSeqLength,
                &iSeqLength_2,
                hw_Rate_1,
                &hw_Rate_2,
                OutBlockShift,
                &OutBlockShift_2,
                hw_pcSeq0_1,
                hw_pcSeq0_2,
                hw_pcSeq1_1,
                hw_pcSeq1_2,
                FSM_I_1,
                FSM_S_1,
                FSM_pNS_1,
                FSM_pOS_1,
                FSM_pTMl_1,
                FSM_pTMi_1,
                &FSM_I_2,
                &FSM_S_2,
                FSM_pNS_2,
                FSM_pOS_2,
                FSM_pTMl_2,
                FSM_pTMi_2,
                pT1_1,
                pT1_2,
                hw_piSeqInt,
                piSeq2,
                paraTable_1
                );


        Hardware_TurboEncoding_F2(
            iSeqLength_2,
            &iSeqLength_3,
            hw_Rate_2,
            &hw_Rate_3,
            OutBlockShift_2,
            &OutBlockShift_3,
            hw_pcSeq0_2,
            hw_pcSeq0_3,
            hw_pcSeq1_2,
            hw_pcSeq1_3,
            FSM_I_2,
            FSM_S_2,
            FSM_pNS_2,
            FSM_pOS_2,
            FSM_pTMl_2,
            FSM_pTMi_2,
            pT1_2,
            pT1_3,
            piSeq2,           
            pT2,
            hw_pcSeq2
            );

        Hardware_TurboEncoding_F3(
            iSeqLength_3,
            hw_Rate_3,
            OutBlockShift_3,
            hw_pcSeq0_3,
            hw_pcSeq1_3,
            hw_pcSeq2,
            hw_pcSeq,
            pT1_3,
            pT2);
    }

}

#endif
#endif
