#include "Hw_TurboEncoder.h"
#ifndef IS_DATAFLOW
#ifndef IS_PIPELINE


void hardware_Interleaving(
        int SeqLen,
        int inputShift,
        int pInpSeq [MAX_DataLength],
        int pOutSeq [6144],
        int paraTable[188][3]
        )
{
    //************************ Permutation Pattern *****************************//
    int K = SeqLen;
    int f1,f2;
    bool continueflag = 1;
    for(int idx = 187;idx>=0&&continueflag;idx--)
    {
    #ifdef IS_HLS
    //#pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=188)
    #endif
        if(paraTable[idx][0]==SeqLen)
            {
            f1 = paraTable[idx][1];
            f2 = paraTable[idx][2];
            continueflag = 0;
            }
    }
    int pPi[6148];
    long long tmp;
    for(int idx=0;idx<K;idx++)
    {
    #ifdef IS_HLS
    //#pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BlockLen)
    #endif
        tmp=((((long long)idx)*((long long)f1))+((((long long)idx)*((long long)idx))*((long long)f2)));
        pPi[idx]=(int)(tmp%((long long)K));
    }
    //********************* Start Interleaving ****************************//
    for(int idx=0;idx<K;idx++)
    {
    #ifdef IS_HLS
    //#pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BlockLen)
    #endif
        pOutSeq[idx] = pInpSeq[inputShift + pPi[idx]];
    }
}

int hardware_maxElen(
        int num,
        int p[MAX_S*MAX_S],
        int pos,
        int space)
{
    int mamm = p[0];
    for(int i=0;i<num;i++)
    {
	#ifdef IS_HLS
	//#pragma HLS PIPELINE enable_flush
	DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
	#endif
        mamm = (mamm>p[i*space+pos])?mamm:p[i*space+pos];
    }
    return mamm;
}


void Hardware_TurboEncoding(
    int hw_NumBlock,
    int hw_Rate,
    int hw_pLengthSet[MAX_NumBlock],
    int hw_piSeq[MAX_DataLength],
    int hw_pcSeq[MAX_RATE][MAX_NumBlock*(6144+4)],
    int FSM_I,
    int FSM_S,
    int FSM_pNS[MAX_I*MAX_S],
    int FSM_pOS[MAX_I*MAX_S],
    int FSM_pTMl[MAX_S*MAX_S],
    int FSM_pTMi[MAX_S*MAX_S],
    int paraTable[188][3])
{
	for(int nBlock=0;nBlock<hw_NumBlock;nBlock++)
    {
    #ifdef IS_HLS
    //#pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_NumBlock)
    #endif
        int iSeqLength=hw_pLengthSet[nBlock];
        int InpBlockShift=nBlock*6144;
        int OutBlockShift=nBlock*(6144+4);

        // Start Encoding this Block
        int cs;         //current state
        int ns;         //next state
        int isym;       //input symbol
        int osym;       //output symbol

        for(int i=0;i<iSeqLength;i++)
        {
        #ifdef IS_HLS
        //#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BlockLen)
        #endif
            hw_pcSeq[0][OutBlockShift+i] = hw_piSeq[InpBlockShift+i];
        }

        // rsc1
        cs=0;   //start from 0 state
        for(int i=0;i<iSeqLength;i++)
        {
        #ifdef IS_HLS
        //#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_NumBlock)
        #endif
            isym = hw_piSeq[InpBlockShift+i];
            ns  = FSM_pNS[(FSM_I)*cs+isym];
            osym = FSM_pOS[(FSM_I)*cs+isym];
            hw_pcSeq[1][OutBlockShift+i]=osym;
            cs = ns;
        }

        // Adding termination
        int ends = cs; // ending state of Turbo saved in ends
        int maxLen = hardware_maxElen(FSM_S,FSM_pTMl,0,FSM_S);
        int ptaili[MAX_S];
        for(int i=0;i<maxLen;i++)
        {
        #ifdef IS_HLS
        //#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
        #endif
            ptaili[i]=0;
        }

        int numidx=0;
        while(cs!=0&&numidx<maxLen)//MAX_S
        {
        #ifdef IS_HLS
        //#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
        #endif
            ptaili[numidx]=FSM_pTMi[cs*FSM_S+0];
            cs = FSM_pNS[(FSM_I)*cs+(*(ptaili+numidx))];
            numidx++;
        }
        cs = ends; //start from last state to zero-state

        int pT1[6];
        for(int i=0;i<maxLen;i++)
        {
        #ifdef IS_HLS
        //#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
        #endif
            isym = ptaili[i];
            ns   = FSM_pNS[FSM_I*cs+isym];
            osym = FSM_pOS[FSM_I*cs+isym];
            pT1[2*i+0]=isym;
            pT1[2*i+1]=osym;
            cs = ns;
        }

        for(int i=0;i<2;i++)
        {
        #ifdef IS_HLS
        //#pragma HLS PIPELINE enable_flush
        #endif
            hw_pcSeq[0][OutBlockShift+iSeqLength+i] =  pT1[i*hw_Rate+0];
            hw_pcSeq[1][OutBlockShift+iSeqLength+i] =  pT1[i*hw_Rate+1];
            hw_pcSeq[2][OutBlockShift+iSeqLength+i] =  pT1[i*hw_Rate+2];
        }
        cs=-1;
        ns=-1;
        isym=-1;
        osym=-1;

        int piSeq2[6144];
        hardware_Interleaving(
                iSeqLength,
                InpBlockShift,
                hw_piSeq,
                piSeq2,
                paraTable
                );
        //EInter.Interleaving(iSeqLength,(piSeq+InpBlockShift),piSeq2);

        // rsc2
        cs = 0; //start from 0 state
        for(int i=0;i<iSeqLength;i++)
        {
        #ifdef IS_HLS
        //#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BlockLen)
        #endif
                isym = piSeq2[i];
                ns  = FSM_pNS[FSM_I*cs+isym];
                osym = FSM_pOS[FSM_I*cs+isym];
                hw_pcSeq[2][OutBlockShift+i]=osym;
                cs = ns;
        }

        // Adding termination
        ends = cs;
        maxLen = hardware_maxElen(FSM_S,FSM_pTMl,0,FSM_S);
        int ptail2i[MAX_S];
        for(int i=0;i<maxLen;i++)
        {
        #ifdef IS_HLS
        //#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
        #endif
            ptail2i[i]=0;
        }
        numidx=0;
        while(cs!=0&&numidx<maxLen)
        {
        #ifdef IS_HLS
        //#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
        #endif
            ptail2i[numidx]=FSM_pTMi[cs*FSM_S+0];
            cs = FSM_pNS[FSM_I*cs+ptail2i[numidx]];
            numidx++;
        }
        cs = ends; //start from last state to zero-state
        int pT2[6];
        for(int i=0;i<maxLen;i++)
        {
        #ifdef IS_HLS
        //#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_S)
        #endif
            isym = ptail2i[i];
            ns  = FSM_pNS[FSM_I*cs+isym];
            osym = FSM_pOS[FSM_I*cs+isym];
            pT2[2*i+0]=isym;
            pT2[2*i+1]=osym;
            cs = ns;
        }

        for(int i=0;i<2;i++)
        {
        #ifdef IS_HLS
        //#pragma HLS PIPELINE enable_flush
        #endif
            hw_pcSeq[0][OutBlockShift+iSeqLength+2+i] =  pT2[i*hw_Rate+0];
            hw_pcSeq[1][OutBlockShift+iSeqLength+2+i] =  pT2[i*hw_Rate+1];
            hw_pcSeq[2][OutBlockShift+iSeqLength+2+i] =  pT2[i*hw_Rate+2];
        }
    }

}

#endif
#endif
