#include "Pl_SCMap.h"
#ifndef IS_DATAFLOW
#ifndef IS_BARE

void hardware_SCMap(
        myComplex hardware_pInpData[(MAX_SYM-2)*MAX_Layer][MAX_MDFT],
        myComplex hardware_VpDMRS[2][MAX_Layer][MAX_MDFT],
        int hardware_DMRSSymbPos[2],
        myComplex hardware_pOutData[MAX_SYM*MAX_Layer][MAX_NIFFT],
        int hardware_NumLayer,
        int hardware_NumULSymbSF,
        int hardware_SCLoc,
        int hardware_MDFT)
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=hardware_DMRSSymbPos
#pragma HLS INTERFACE s_axilite port=hardware_NumLayer
#pragma HLS INTERFACE s_axilite port=hardware_NumULSymbSF
#pragma HLS INTERFACE s_axilite port=hardware_SCLoc
#pragma HLS INTERFACE s_axilite port=hardware_MDFT
#pragma HLS RESOURCE variable=hardware_pInpData core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_VpDMRS core=RAM_1P_BRAM
    #pragma HLS RESOURCE variable=hardware_pOutData core=RAM_1P_BRAM
#endif
    for(int nlayer=0;nlayer<hardware_NumLayer;nlayer++)
    {
    #ifdef IS_HLS
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_Layer)
    #endif
        int DMRSslot=0;
        for(int nsym=0;nsym<hardware_NumULSymbSF;nsym++)
        {
        #ifdef IS_HLS
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SYM)

        #endif
            int SymIdx = nlayer*hardware_NumULSymbSF+nsym;
            if(nsym==hardware_DMRSSymbPos[DMRSslot])
            {
                for(int n=hardware_SCLoc;n<hardware_SCLoc+hardware_MDFT;n++)
                {
                #ifdef IS_HLS
				#pragma HLS PIPELINE enable_flush
                DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MDFT+MAX_SCLoc)
                #endif
                    hardware_pOutData[SymIdx][n]=hardware_VpDMRS[DMRSslot][nlayer][n-hardware_SCLoc];
                }
                DMRSslot++;
            }
            else
            {
                for(int n=hardware_SCLoc;n<hardware_SCLoc+hardware_MDFT;n++)
                {
                #ifdef IS_HLS
				#pragma HLS PIPELINE enable_flush
                DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MDFT+MAX_SCLoc)
                #endif
                    hardware_pOutData[SymIdx][n]=hardware_pInpData[nlayer*(hardware_NumULSymbSF-2)+nsym-DMRSslot][n-hardware_SCLoc];
                }
            }
        }
    }
}

#endif
#endif
