#include "Hw_SCDemap.h"
#ifndef IS_DATAFLOW
#ifndef IS_PIPELINE

void hardware_SCDemap(
        myComplex hardware_pInpData[MAX_SYM*MAX_RX_ANT][MAX_NIFFT],
        myComplex hardware_pOutData[MAX_SYM*MAX_RX_ANT][MAX_MDFT],
        int hardware_DMRSSymbPos[2],
        int hardware_MDFT,
        int hardware_SCLoc,
        int hardware_NumRxAntenna,
        int hardware_NumULSymbSF)
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=hardware_DMRSSymbPos
#pragma HLS INTERFACE s_axilite port=hardware_MDFT
#pragma HLS INTERFACE s_axilite port=hardware_SCLoc
#pragma HLS INTERFACE s_axilite port=hardware_NumRxAntenna
#pragma HLS INTERFACE s_axilite port=hardware_NumULSymbSF
#pragma HLS RESOURCE variable=hardware_pInpData core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pOutData core=RAM_1P_BRAM
#endif    

    //////////// Get DMRS /////////////

    for(int nrs=0;nrs<2;nrs++)
    {
        int DMRSPos=hardware_DMRSSymbPos[nrs];
        for(int nrx=0;nrx<hardware_NumRxAntenna;nrx++)
        {
        #ifdef IS_HLS
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RX_ANT)
        #endif
            int SymIdxIn = nrx*hardware_NumULSymbSF+DMRSPos;
            int SymIdxOut= nrx*2+nrs;
            for(int n=0;n<hardware_MDFT;n++)
            {
            #ifdef IS_HLS
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MDFT)
            #endif
                hardware_pOutData[SymIdxOut][n]=hardware_pInpData[SymIdxIn][n+hardware_SCLoc];
            }
        }
    }
    //////////// Get Data /////////////

    for(int nrx=0;nrx<hardware_NumRxAntenna;nrx++)
    {
    #ifdef IS_HLS
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RX_ANT)
    #endif
        int SymOutIdx=0;
        for(int nsym=0;nsym<hardware_NumULSymbSF;nsym++)
        {
        #ifdef IS_HLS
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SYM)
        #endif
            int SymIdxIn = hardware_NumULSymbSF*nrx+nsym;
            if(!((nsym==hardware_DMRSSymbPos[0])||(nsym==hardware_DMRSSymbPos[1])))
            {
                int SymOutT=(hardware_NumULSymbSF-2)*nrx+SymOutIdx+hardware_NumRxAntenna*2;

                for(int n=0;n<hardware_MDFT;n++)
                {
                #ifdef IS_HLS
                DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MDFT)
                #endif
                    hardware_pOutData[SymOutT][n]=hardware_pInpData[SymIdxIn][n+hardware_SCLoc];
                }
                SymOutIdx++;
            }
        }
    }
}

#endif
#endif
