#include "Pl_Scramble.h"
#ifndef IS_BARE
#ifndef IS_PIPELINE

void hardware_Scramble(
        int hardware_pInpSeq[MAX_Layer*MAX_NInfoBits],
        int hardware_pScrambSeq[MAX_Layer*MAX_NInfoBits],
        int hardware_pOutSeq[MAX_Layer*MAX_NInfoBits],
        int hardware_NumLayer,
        int hardware_NInfoBits
)
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=hardware_NumLayer
#pragma HLS INTERFACE s_axilite port=hardware_NInfoBits
#pragma HLS RESOURCE variable=hardware_pInpSeq core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pScrambSeq core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pOutSeq core=RAM_1P_BRAM
#endif    
    int Mpn=hardware_NumLayer*hardware_NInfoBits;
    ///////////////////Scrambling////////////////////////////
    for(int n=0;n<Mpn;n++)
    {
        #ifdef IS_HLS
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_NInfoBits*MAX_Layer)
		#pragma HLS PIPELINE enable_flush
        #endif
        hardware_pOutSeq[n]=(hardware_pInpSeq[n] + hardware_pScrambSeq[n]) & 0x01;
    }
    return;
}

#endif
#endif
