#ifndef PL_RXRATEMATCHER_H
#define PL_RXRATEMATCHER_H

#include "hw_def.h"
#include "math.h"
#ifndef IS_DATAFLOW
#ifndef IS_BARE


#define MAX_RATE 3
#define MAX_DataLength 2368
#define MAX_LastBlockLen 6143
//#define MAX_NumBlock (MAX_DataLength/6144)+1
#define MAX_NumBlock 2
#define MAX_Layer  2
#define MAX_MDFT 75
#define MAX_SYM 14
#define MAX_QAMLen MAX_MDFT*(MAX_SYM-2)
#define MAX_MQAM 16
#define MAX_LOG_MQAM 4
#define MAX_BitsPerSymb MAX_LOG_MQAM
#define MAX_NInfoBits MAX_QAMLen*MAX_BitsPerSymb
//#define MAX_EncDataLen (MAX_NumBlock)*(6144*MAX_RATE+12)
#define MAX_EncDataLen 36888
#define MAX_C_sb 32
//#define MAX_R_sb (6148/MAX_C_sb)+1
#define MAX_R_sb 193
#define MAX_K_pi MAX_C_sb*MAX_R_sb

struct myComplex
{
    float re;
    float im;
};

void hardware_RxRateMatching(
        int hardware_pLengthSet[MAX_NumBlock],
        float hardware_pLLRin[MAX_Layer*(MAX_SYM-2)*MAX_MDFT*MAX_LOG_MQAM],
        float hardware_pLLRout[MAX_EncDataLen],
        int hardware_pHD[MAX_EncDataLen],
        int hardware_NumBlock,
        int hardware_Rate,
        int hardware_EncDataLen,
        int SbDeInterleaver_InterColumnPattern [32],
        int SbDeInterleaver_C_sb,
        int SbDeInterleaver_Rate);

void Hardware_SubblockDeInterleaving(
        int SeqLen,
        int C_sb,
        int Rate,
        float pInpMtr [MAX_RATE][6144+4],
        float pOutMtr [MAX_RATE][6144+4],
        int InterColumnPattern [32]);

#endif
#endif

#endif // PL_RXRATEMATCHER_H
