#include "Df_RxRateMatcher.h"
#ifndef IS_PIPELINE
#ifndef IS_BARE


void Hardware_SubblockDeInterleaving_1(
        int SeqLen,
        int* iSeqLength_out,
        int hardware_Rate_In,
        int* hardware_Rate_Out,
        int OutBlockShift_In,
        int* OutBlockShift_Out,
        int C_sb,
        int* C_sb_out,
        int Rate,
        int* Rate_out,
        float pInpMtr [MAX_RATE][6144+4],
        float pInterSeq[6144+4],
        float pInterMatrix[MAX_RATE][MAX_R_sb][MAX_C_sb],
        int InterColumnPattern [32],
        int InterColumnPattern_Out [32])
{

    *iSeqLength_out = SeqLen;
    *hardware_Rate_Out = hardware_Rate_In;
    *OutBlockShift_Out = OutBlockShift_In;
    *C_sb_out = C_sb;
    *Rate_out = Rate;
    int D=SeqLen;
    int R_sb=(int)(ceil((((double)D)/((double)C_sb))));
    int K_pi=R_sb*C_sb;
    int NumDummy=K_pi-D;
    int InIdx;

    for(int i=0; i<32; i++)
    {
	#ifdef IS_HLS
	#pragma HLS PIPELINE enable_flush
	#endif
        InterColumnPattern_Out[i] = InterColumnPattern[i];
    }
    //////////////////// DeInterleaving for i=0,1 ///////////////////////
    float *VpInpSeq;
    float DummyValue = 1000000;
    for(int StrIdx=0;StrIdx<(Rate-1);StrIdx++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
    #endif
        VpInpSeq=pInpMtr[StrIdx];
        //////////////////// Write DeInter Matrix//////////////////////
        InIdx=0;
        for(int c=0;c<C_sb;c++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_C_sb)
        #endif
            int col = InterColumnPattern[c];
            for(int r=0;r<R_sb;r++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_R_sb)
            #endif
                int k=r*C_sb+col;
                if(k<NumDummy)
                {
                    pInterMatrix[StrIdx][r][col]=DummyValue;
                }
                else
                {
                    pInterMatrix[StrIdx][r][col]=VpInpSeq[InIdx];
                    InIdx++;
                }
            }
        }
    }

    for(int ii=0; ii<6148; ii++)
    {
	#ifdef IS_HLS
	#pragma HLS PIPELINE enable_flush
	#endif
        pInterSeq[ii] = pInpMtr[Rate-1][ii];
    }
}


void Hardware_SubblockDeInterleaving_2(
        int SeqLen,
        int* iSeqLength_out,
        int hardware_Rate_In,
        int* hardware_Rate_Out,
        int OutBlockShift_In,
        int* OutBlockShift_Out,
        int C_sb,
        int Rate,
        float pInterMatrix[MAX_RATE][MAX_R_sb][MAX_C_sb],
        float pInpMtr [6144+4],
        float pOutMtr [MAX_RATE][6144+4],
        int InterColumnPattern [32])
{
    int D=SeqLen;
    int R_sb=(int)(ceil((((double)D)/((double)C_sb))));
    int K_pi=R_sb*C_sb;
    int NumDummy=K_pi-D;
    int InIdx;
    int OutIdx;
    *iSeqLength_out = SeqLen-4;
    *hardware_Rate_Out = hardware_Rate_In;
    *OutBlockShift_Out = OutBlockShift_In;

    //////////////////// DeInterleaving for i=2 ///////////////////////
    int Pi[MAX_K_pi];
    float pInterSeq[MAX_K_pi];
    float *VpInpSeq;
    float *VpOutSeq;
    VpInpSeq=pInpMtr;

    float DummyValue = 1000000;
    for(int k=0;k<NumDummy;k++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
        #endif
        pInterSeq[k]=DummyValue;
        }
    //////////////// Pi & DePi//////////////////
    for(int k=0;k<K_pi;k++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
        #endif
        int idxP=(int)(floor((((double)(k))/((double)(R_sb)))));
        int idx = ((InterColumnPattern[idxP])+(C_sb*(k%R_sb))+1)%K_pi;
        Pi[k]=idx;
        }
    /////////////// DeInterleaving ////////////////////
    InIdx=0;
    for(int k=0;k<K_pi;k++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
        #endif
        int tmp = Pi[k];
        //float v = pInterSeq[Pi[k]];
        if(tmp >= NumDummy)
            {
            pInterSeq[tmp]=VpInpSeq[InIdx];
            InIdx++;
            }
        }

    //////////////////// Read Out DeInter Matrix//////////////////////

    for(int StrIdx=0;StrIdx<(Rate-1);StrIdx++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE-1)
    #endif
        VpOutSeq=pOutMtr[StrIdx];
        OutIdx=0;
        for(int r=0;r<R_sb;r++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_R_sb)
        #endif
            for(int c=0;c<C_sb;c++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_C_sb)
            #endif
                float v = pInterMatrix[StrIdx][r][c];
                if(v!=DummyValue)
                {
                    VpOutSeq[OutIdx]=pInterMatrix[StrIdx][r][c];
                    OutIdx++;
                }
            }
        }
    }
    VpOutSeq=pOutMtr[Rate-1];
    OutIdx=0;
    for(int k=NumDummy;k<K_pi;k++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
        #endif
        VpOutSeq[OutIdx]=pInterSeq[k];
        OutIdx++;
        }
}





void ReadIntoPInMatrix(
        float hardware_pLLRin[MAX_Layer*(MAX_SYM-2)*MAX_MDFT*MAX_LOG_MQAM],
        float pInMatrix [MAX_RATE][6144+4],
        int hardware_pLengthSet[MAX_NumBlock],
        int SbDeInterleaver_InterColumnPattern_In [32],
        int SbDeInterleaver_InterColumnPattern_Out [32],
        int nBlock,
        int hardware_Rate_in,
        int* hardware_Rate_out,
        int* iSeqLength,
        int* OutBlockShift,
        int SbDeInterleaver_C_sb_In,
        int* SbDeInterleaver_C_sb_Out,
        int SbDeInterleaver_Rate_In,
        int* SbDeInterleaver_Rate_Out)
{

    *iSeqLength=hardware_pLengthSet[nBlock];
    *OutBlockShift = nBlock*(6144*hardware_Rate_in+12);
    *hardware_Rate_out = hardware_Rate_in;
    *SbDeInterleaver_Rate_Out = SbDeInterleaver_Rate_In;
    *SbDeInterleaver_C_sb_Out = SbDeInterleaver_C_sb_In;

    for(int i=0; i<32; i++)
        SbDeInterleaver_InterColumnPattern_Out[i] = SbDeInterleaver_InterColumnPattern_In[i];

    int idx = (*OutBlockShift);
    for(int i=0;i<(*iSeqLength)+4;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=6148)
    #endif
        for(int r=0;r<hardware_Rate_in;r++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
        #endif
            pInMatrix[r][i]=hardware_pLLRin[idx];
            idx++;
        }
    }

}





void WriteIntoPLLTemp(
        float hardware_pLLRin_tmp[MAX_Layer*(MAX_SYM-2)*MAX_MDFT*MAX_LOG_MQAM],
        float pOutMatrix [MAX_RATE][6144+4],
        int iSeqLength,
        int hardware_Rate,
        int OutBlockShift)
{
    for(int i=0;i<iSeqLength+4;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=6148)
    #endif
        for(int r=0;r<hardware_Rate;r++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
        #endif
            hardware_pLLRin_tmp[OutBlockShift+hardware_Rate*i+r]=pOutMatrix[r][i];
        }
    }
}

void MakeOutputs(
        int hardware_EncDataLen,
        float hardware_pLLRin_tmp[MAX_Layer*(MAX_SYM-2)*MAX_MDFT*MAX_LOG_MQAM],
        int hardware_pHD[MAX_EncDataLen],
        float hardware_pLLRout[MAX_EncDataLen]
        )
{
    for(int i=0;i<hardware_EncDataLen;i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_EncDataLen)
    #endif
        float tmp = hardware_pLLRin_tmp[i];
        hardware_pLLRout[i]=tmp;
        hardware_pHD[i]=(tmp<0)?0:1;
    }
}

void hardware_RxRateMatching(
        int hardware_pLengthSet[MAX_NumBlock],
        float hardware_pLLRin[MAX_Layer*(MAX_SYM-2)*MAX_MDFT*MAX_LOG_MQAM],
        float hardware_pLLRout[MAX_EncDataLen],
        int hardware_pHD[MAX_EncDataLen],
        int hardware_NumBlock,
        int hardware_Rate,
        int hardware_EncDataLen,
        int SbDeInterleaver_InterColumnPattern [32],
        int SbDeInterleaver_C_sb,
        int SbDeInterleaver_Rate)
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=hardware_NumBlock
#pragma HLS INTERFACE s_axilite port=hardware_Rate
#pragma HLS INTERFACE s_axilite port=hardware_EncDataLen
#pragma HLS INTERFACE s_axilite port=SbDeInterleaver_C_sb
#pragma HLS INTERFACE s_axilite port=SbDeInterleaver_Rate
#pragma HLS RESOURCE variable=hardware_pLengthSet core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pLLRin core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pLLRout core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pHD core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=SbDeInterleaver_InterColumnPattern core=RAM_1P_BRAM
#endif


    float hardware_pLLRin_tmp[MAX_Layer*(MAX_SYM-2)*MAX_MDFT*MAX_LOG_MQAM];
    int hardware_Rate_1, hardware_Rate_2, hardware_Rate_3;
    int iSeqLength, iSeqLength_1, iSeqLength_2;
    int OutBlockShift, OutBlockShift_1, OutBlockShift_2;
    int SbDeInterleaver_InterColumnPattern_1 [32];
    int SbDeInterleaver_InterColumnPattern_2 [32];
    int SbDeInterleaver_C_sb_1, SbDeInterleaver_C_sb_2;
    int SbDeInterleaver_Rate_1, SbDeInterleaver_Rate_2;
    float pInMatrix [MAX_RATE][6144+4];
    float pInterSeq[6148];
    float pOutMatrix [MAX_RATE][6144+4];
    float pInterMatrix[MAX_RATE][MAX_R_sb][MAX_C_sb];

    for(int nBlock=0;nBlock<hardware_NumBlock;nBlock++)
    {
    #ifdef IS_HLS
	#pragma HLS DATAFLOW
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_NumBlock)
    #endif

        ReadIntoPInMatrix(
                    hardware_pLLRin,
                    pInMatrix,
                    hardware_pLengthSet,
                    SbDeInterleaver_InterColumnPattern,
                    SbDeInterleaver_InterColumnPattern_1,
                    nBlock,
                    hardware_Rate,
                    &hardware_Rate_1,
                    &iSeqLength,
                    &OutBlockShift,
                    SbDeInterleaver_C_sb,
                    &SbDeInterleaver_C_sb_1,
                    SbDeInterleaver_Rate,
                    &SbDeInterleaver_Rate_1);



        Hardware_SubblockDeInterleaving_1(
                    iSeqLength+4,
                    &iSeqLength_1,
                    hardware_Rate_1,
                    &hardware_Rate_2,
                    OutBlockShift,
                    &OutBlockShift_1,
                    SbDeInterleaver_C_sb_1,
                    &SbDeInterleaver_C_sb_2,
                    SbDeInterleaver_Rate_1,
                    &SbDeInterleaver_Rate_2,
                    pInMatrix,
                    pInterSeq,
                    pInterMatrix,
                    SbDeInterleaver_InterColumnPattern_1,
                    SbDeInterleaver_InterColumnPattern_2);

Hardware_SubblockDeInterleaving_2(
            iSeqLength_1,
            &iSeqLength_2,
            hardware_Rate_2,
            &hardware_Rate_3,
            OutBlockShift_1,
            &OutBlockShift_2,
            SbDeInterleaver_C_sb_2,
            SbDeInterleaver_Rate_2,
            pInterMatrix,
            pInterSeq,
            pOutMatrix,
            SbDeInterleaver_InterColumnPattern_2);


        WriteIntoPLLTemp(
                    hardware_pLLRin_tmp,
                    pOutMatrix,
                    iSeqLength_1,
                    hardware_Rate_2,
                    OutBlockShift_1);

    }

    MakeOutputs(
                hardware_EncDataLen,
                hardware_pLLRin_tmp,
                hardware_pHD,
                hardware_pLLRout);
    return;
}

#endif
#endif
