#include "Hw_RxRateMatcher.h"
#ifndef IS_DATAFLOW
#ifndef IS_PIPELINE



void Hardware_SubblockDeInterleaving(int SeqLen,
                                     int C_sb,
                                     int Rate,
                                     float pInpMtr [MAX_RATE][6144+4],
                                     float pOutMtr [MAX_RATE][6144+4],
                                     int InterColumnPattern [32])
{
	int D=SeqLen;
	int R_sb=(int)(ceil((((double)D)/((double)C_sb))));
	int K_pi=R_sb*C_sb;
	int NumDummy=K_pi-D;
	int InIdx;
	int OutIdx;

	//////////////////// DeInterleaving for i=0,1 ///////////////////////
	float pInterMatrix[MAX_R_sb][MAX_C_sb];

	float *VpInpSeq;
	float *VpOutSeq;
	float DummyValue = 1000000;
	for(int StrIdx=0;StrIdx<(Rate-1);StrIdx++)
	{
	#ifdef IS_HLS
	//#pragma HLS PIPELINE enable_flush
	DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
	#endif
		VpInpSeq=pInpMtr[StrIdx];
		VpOutSeq=pOutMtr[StrIdx];
		//////////////////// Write DeInter Matrix//////////////////////
		InIdx=0;
		//////////////// write into matrix //////////////////
		for(int r=0;r<R_sb;r++)
		{
		#ifdef IS_HLS
		//#pragma HLS PIPELINE enable_flush
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_R_sb)
		#endif
			for(int c=0;c<C_sb;c++)
			{
			#ifdef IS_HLS
			//#pragma HLS PIPELINE enable_flush
			DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_C_sb)
			#endif
				int k=r*C_sb+c;
				if(k<NumDummy)
				{
					pInterMatrix[r][c]=DummyValue;
				}
				else
				{
					pInterMatrix[r][c]=0;
				}
			}
		}
		////////////// Read out matrix ///////////////////////
		for(int c=0;c<C_sb;c++)
		{
		#ifdef IS_HLS
		//#pragma HLS PIPELINE enable_flush
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_C_sb)
		#endif
			int col = InterColumnPattern[c];
			for(int r=0;r<R_sb;r++)
			{
			#ifdef IS_HLS
			//#pragma HLS PIPELINE enable_flush
			DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_R_sb)
			#endif
				float v = pInterMatrix[r][col];
				if(v!=DummyValue)
				{
					pInterMatrix[r][col]=VpInpSeq[InIdx];
					InIdx++;
				}
			}
		}
		//////////////////// Read Out DeInter Matrix//////////////////////
		OutIdx=0;
		for(int r=0;r<R_sb;r++)
		{
		#ifdef IS_HLS
		//#pragma HLS PIPELINE enable_flush
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_R_sb)
		#endif
			for(int c=0;c<C_sb;c++)
			{
			#ifdef IS_HLS
			//#pragma HLS PIPELINE enable_flush
			DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_C_sb)
			#endif
				float v = *(*(pInterMatrix+r)+c);
				if(v!=DummyValue)
				{
					VpOutSeq[OutIdx]=pInterMatrix[r][c];
					OutIdx++;
				}
			}
		}
	}

	//////////////////// DeInterleaving for i=2 ///////////////////////
	int Pi[MAX_K_pi];
	float pInterSeq[MAX_K_pi];
	VpInpSeq=pInpMtr[Rate-1];
	VpOutSeq=pOutMtr[Rate-1];
	for(int k=0;k<NumDummy;k++)
		{
		#ifdef IS_HLS
		//#pragma HLS PIPELINE enable_flush
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
		#endif
		pInterSeq[k]=DummyValue;
		}
	//////////////// Pi & DePi//////////////////
	for(int k=0;k<K_pi;k++)
		{
		#ifdef IS_HLS
		//#pragma HLS PIPELINE enable_flush
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
		#endif
		int idxP=(int)(floor((((double)(k))/((double)(R_sb)))));
		int idx = ((InterColumnPattern[idxP])+(C_sb*(k%R_sb))+1)%K_pi;
		Pi[k]=idx;
		}
	/////////////// DeInterleaving ////////////////////
	InIdx=0;
	for(int k=0;k<K_pi;k++)
		{
		#ifdef IS_HLS
		//#pragma HLS PIPELINE enable_flush
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
		#endif
		float v = pInterSeq[Pi[k]];
		if(v!=DummyValue)
			{
			pInterSeq[Pi[k]]=VpInpSeq[InIdx];
			InIdx++;
			}
		}
	OutIdx=0;
	for(int k=NumDummy;k<K_pi;k++)
		{
		#ifdef IS_HLS
		//#pragma HLS PIPELINE enable_flush
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_K_pi)
		#endif
		VpOutSeq[OutIdx]=pInterSeq[k];
		OutIdx++;
		}
}




void hardware_RxRateMatching(
        int hardware_pLengthSet[MAX_NumBlock],
        float hardware_pLLRin[MAX_Layer*(MAX_SYM-2)*MAX_MDFT*MAX_LOG_MQAM],
        float hardware_pLLRout[MAX_EncDataLen],
        int hardware_pHD[MAX_EncDataLen],
        int hardware_NumBlock,
        int hardware_Rate,
        int hardware_EncDataLen,
        int SbDeInterleaver_InterColumnPattern [32],
        int SbDeInterleaver_C_sb,
        int SbDeInterleaver_Rate)
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=hardware_NumBlock
#pragma HLS INTERFACE s_axilite port=hardware_Rate
#pragma HLS INTERFACE s_axilite port=hardware_EncDataLen
#pragma HLS INTERFACE s_axilite port=SbDeInterleaver_C_sb
#pragma HLS INTERFACE s_axilite port=SbDeInterleaver_Rate
#pragma HLS RESOURCE variable=hardware_pLengthSet core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pLLRin core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pLLRout core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pHD core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=SbDeInterleaver_InterColumnPattern core=RAM_1P_BRAM
#endif

    for(int nBlock=0;nBlock<hardware_NumBlock;nBlock++)
    {
	#ifdef IS_HLS
	//#pragma HLS PIPELINE enable_flush
	DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_NumBlock)
	#endif
        int iSeqLength=hardware_pLengthSet[nBlock];
        int OutBlockShift = nBlock*(6144*hardware_Rate+12);

        ////////////////////// Read into pInMatrix //////////////////
        float pInMatrix [MAX_RATE][6144+4];
        float pOutMatrix [MAX_RATE][6144+4];
        for(int i=0;i<iSeqLength+4;i++)
        {
		#ifdef IS_HLS
		//#pragma HLS PIPELINE enable_flush
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=6148)
		#endif
            for(int r=0;r<hardware_Rate;r++)
            {
			#ifdef IS_HLS
			//#pragma HLS PIPELINE enable_flush
			DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
			#endif
                pInMatrix[r][i]=hardware_pLLRin[OutBlockShift+hardware_Rate*i+r];
            }
        }
        ////////////////////// Subblock DeInterleaver //////////////////////////

        Hardware_SubblockDeInterleaving(
            iSeqLength+4,
            SbDeInterleaver_C_sb,
            SbDeInterleaver_Rate,
            pInMatrix,
            pOutMatrix,
            SbDeInterleaver_InterColumnPattern);

        ////////////////////// Write back to pLLRin //////////////////
        for(int i=0;i<iSeqLength+4;i++)
        {
		#ifdef IS_HLS
		//#pragma HLS PIPELINE enable_flush
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=6148)
		#endif
            for(int r=0;r<hardware_Rate;r++)
            {
			#ifdef IS_HLS
			//#pragma HLS PIPELINE enable_flush
			DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RATE)
			#endif
                hardware_pLLRin[OutBlockShift+hardware_Rate*i+r]=pOutMatrix[r][i];
            }
        }
    }

    for(int i=0;i<hardware_EncDataLen;i++)
    {
	#ifdef IS_HLS
	//#pragma HLS PIPELINE enable_flush
	DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_EncDataLen)
	#endif
        if((*(hardware_pLLRin+i))<0)
        {
            *(hardware_pHD+i)=0;
        }
        else
        {
            *(hardware_pHD+i)=1;
        }
    }

    for(int i=0;i<hardware_EncDataLen;i++)
    {
	#ifdef IS_HLS
	//#pragma HLS PIPELINE enable_flush
	DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_EncDataLen)
	#endif
        hardware_pLLRout[i]=hardware_pLLRin[i];
    }

    return;
}

#endif
#endif
