#include "Df_Modulation.h"
#ifndef IS_BARE
#ifndef IS_PIPELINE

void hardware_Modulating(
        int hardware_pBitsSeq [MAX_Layer*MAX_NInfoBits],
        float hardware_pTable[64][2],
        myComplex hardware_pQAMSeq[MAX_Layer*MAX_QAMLen],
        int hardware_QAMLen,
        int hardware_NumLayer,
        int hardware_BitsPerSymb
        )
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=hardware_QAMLen
#pragma HLS INTERFACE s_axilite port=hardware_NumLayer
#pragma HLS INTERFACE s_axilite port=hardware_BitsPerSymb
#pragma HLS RESOURCE variable=hardware_pBitsSeq core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pTable core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pQAMSeq core=RAM_1P_BRAM
#endif

    ///////////// Modulating ////////////
    int idx_ofset = 0;
    for(int nsymb=0;nsymb<hardware_QAMLen*hardware_NumLayer;nsymb++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_QAMLen*MAX_Layer)
    #endif
        int Idx=0;
        int shift_size = hardware_BitsPerSymb-1;
        for(int b=0;b<hardware_BitsPerSymb;b++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BitsPerSymb)
        #endif
            Idx+=(hardware_pBitsSeq[idx_ofset+b]<<shift_size);
            shift_size -= 1;
        }
        hardware_pQAMSeq[nsymb].re = hardware_pTable[Idx][0];
        hardware_pQAMSeq[nsymb].im = hardware_pTable[Idx][1];
        idx_ofset += hardware_BitsPerSymb;
    }

    return;
}

#endif
#endif
