#include "Pl_Equalizer.h"

#ifndef IS_DATAFLOW
#ifndef IS_BARE

hwComplex hwConj(hwComplex a)
{
    hwComplex t;
    t.re = a.re;
    t.im = -a.im;
    return t;
}

hwComplex hwAdd(hwComplex a, hwComplex b)
{
    hwComplex c;
    c.re = a.re + b.re;
    c.im = a.im + b.im;
    return c;
}

hwComplex hwSub(hwComplex a, hwComplex b)
{
    hwComplex c;
    c.re = a.re - b.re;
    c.im = a.im - b.im;
    return c;
}

hwComplex hwMul(hwComplex a, hwComplex b)
{
    hwComplex c;
    c.re = (a.re * b.re) - (a.im * b.im);
    c.im = (a.re * b.im) + (a.im * b.re);
    return c;
}

hwComplex hwDiv(hwComplex a, hwComplex b)
{
    hwComplex c;
    c.re = ((a.re * b.re) + (a.im * b.im))/((b.re * b.re) + (b.im * b.im));
    c.im = ((a.im * b.re) - (a.re * b.im))/((b.re * b.re) + (b.im * b.im));
    return c;
}

void hwMatrixInv(int sz,hwComplex pM[MAX_LAYER][MAX_LAYER],hwComplex pInvM[MAX_LAYER][MAX_LAYER])
{
    hwComplex pX [MAX_SIZE][2*MAX_SIZE];
    for(int r=0;r<sz;r++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SIZE)
    #endif
        for(int c=0;c<sz;c++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SIZE)
        #endif
            pX[r][c]=pM[r][c];
        }
        for(int c=sz;c<2*sz;c++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SIZE)
        #endif
            if(c==r+sz)
            {
                pX[r][c].re=1.0;
                pX[r][c].im=0.0;
            }
            else
            {
                pX[r][c].re=0.0;
                pX[r][c].im=0.0;
            }
        }
    }

    hwComplex pCurRow[2*MAX_SIZE];
    for(int r=0;r<sz;r++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SIZE)
    #endif
        for(int c=0;c<2*sz;c++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=2*MAX_SIZE)
        #endif
            pCurRow[c]=hwDiv(pX[r][c],pX[r][r]);
        }
        for(int c=0;c<2*sz;c++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=2*MAX_SIZE)
        #endif
            pX[r][c]=pCurRow[c];
        }
        for(int er=r+1;er<sz;er++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SIZE)
        #endif
            hwComplex curC=pX[er][r];
            for(int c=0;c<2*sz;c++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=2*MAX_SIZE)
            #endif
                pX[er][c]=hwSub(pX[er][c],hwMul(curC,pCurRow[c]));
            }
        }
    }


    for(int r=sz-1;r>=0;r--)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SIZE)
    #endif
        for(int c=0;c<2*sz;c++)
        {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=2*MAX_SIZE)
            #endif
            pCurRow[c]=pX[r][c];
        }
        for(int er=r-1;er>=0;er--)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SIZE)
        #endif
            hwComplex curC = pX[er][r];
            for(int c=0;c<2*sz;c++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=2*MAX_SIZE)
            #endif
                pX[er][c]=hwSub(pX[er][c],hwMul(curC,pCurRow[c]));
            }
        }
    }

    for(int r=0;r<sz;r++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SIZE)
    #endif
        for(int c=0;c<sz;c++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SIZE)
        #endif
            int col=c+sz;
            pInvM[r][c]=pX[r][col];
        }
    }
}

void hardware_FDLSEqualization(
        hwComplex hardware_pInpData[MAX_SYM*MAX_LAYER][MAX_MDFT],
        hwComplex hardware_pEqW[MAX_MDFT][MAX_LAYER][MAX_RX_ANT],
        hwComplex hardware_pHdm[MAX_MDFT][MAX_RX_ANT][MAX_LAYER],
        hwComplex hardware_pHTranspose[MAX_LAYER][MAX_RX_ANT],
        hwComplex hardware_pOutData[MAX_SYM*MAX_LAYER][MAX_MDFT],
        int m,
        int NumLayer,
        int NumRxAntenna,
        int NumULSymbSF)
{
    //////////////////// Freq Domain Equalize received Data /////////////////
    hwComplex pH[MAX_RX_ANT][MAX_LAYER];
    hwComplex pHDagger[MAX_LAYER][MAX_RX_ANT];
    hwComplex pHDH[MAX_LAYER][MAX_LAYER];
    hwComplex pInvHDH[MAX_LAYER][MAX_LAYER];
    hwComplex pHDY[MAX_LAYER];

    for(int nrx=0;nrx<NumRxAntenna;nrx++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RX_ANT)
    #endif
        for(int layer=0;layer<NumLayer;layer++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
        #endif
            pH[nrx][layer]=hardware_pHTranspose[layer][nrx];
            pHDagger[layer][nrx]=hwConj(hardware_pHTranspose[layer][nrx]);
        }
    }


    for(int i=0; i<NumLayer; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
    #endif
        for(int j=0; j<NumLayer; j++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
        #endif
            hwComplex tmp;
            tmp.re=0;
            tmp.im=0;
            for(int k=0; k<NumRxAntenna; k++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RX_ANT)
            #endif
                tmp=hwAdd(tmp,hwMul(pHDagger[i][k],pH[k][j]));
            }
            pHDH[i][j]=tmp;
        }
    }
   hwMatrixInv(NumLayer,pHDH,pInvHDH);

    ////////////////// Equalizing Data /////////////////
    for(int nSymb=0;nSymb<NumULSymbSF-2;nSymb++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SYM-2)
    #endif
        hwComplex pYData[MAX_RX_ANT];
        for(int nrx=0;nrx<NumRxAntenna;nrx++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RX_ANT)
        #endif
            int IDX=(NumULSymbSF-2)*nrx+nSymb+2*NumRxAntenna;
            pYData[nrx]=hardware_pInpData[IDX][m];
        }


        for(int i=0;i<NumLayer;i++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
        #endif
            hwComplex tmp;
            tmp.re = 0;
            tmp.im = 0;
            for(int k=0;k<NumRxAntenna;k++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RX_ANT)
            #endif
                tmp=hwAdd(tmp, hwMul(pHDagger[i][k],(pYData[k])));
            }
            pHDY[i] = tmp; //InnerProd(d2,*(M1+i),V2);
        }

        hwComplex pXData[MAX_LAYER];
        for(int i=0;i<NumLayer;i++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
        #endif
            hwComplex tmp;
            tmp.re = 0;
            tmp.im = 0;
            for(int k=0;k<NumLayer;k++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
            #endif
                tmp=hwAdd(tmp, hwMul(pInvHDH[i][k],(pHDY[k])));
            }
            pXData[i] = tmp;
        }


        /////////////////////// Get EqW ////////////////////////
        hwComplex pW [MAX_LAYER][MAX_RX_ANT];

        for(int i=0; i<NumLayer; i++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
        #endif
            for(int j=0; j<1; j++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            #endif
                hwComplex tmp;
                tmp.re=0;
                tmp.im=0;
                for(int k=0; k<NumLayer; k++)
                {
                #ifdef IS_HLS
                #pragma HLS PIPELINE enable_flush
                DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
                #endif
                    tmp=hwAdd(tmp,hwMul(pInvHDH[i][k],pHDagger[k][j]));
                }
                pW[i][j]=tmp;
            }
        }


        for(int layer=0;layer<NumLayer;layer++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
        #endif
            for(int nrx=0;nrx<NumRxAntenna;nrx++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RX_ANT)
            #endif
                hardware_pEqW[m][layer][nrx]=pW[layer][nrx];
            }
        }


        //////////////////////// Get pHdm ////////////////////////
        for(int nrx=0;nrx<NumRxAntenna;nrx++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RX_ANT)
        #endif
            for(int layer=0;layer<NumLayer;layer++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
            #endif
                hardware_pHdm[m][nrx][layer]=pH[nrx][layer];
            }
        }
        /////////////////////// END Get pHdm /////////////////////
        for(int layer=0;layer<NumLayer;layer++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
        #endif
            int IDX = (NumULSymbSF-2)*layer+nSymb;
            hardware_pOutData[IDX][m]=pXData[layer];
        }
    }
}

void hardware_FDLSEstimation(
        hwComplex pXt[2][MAX_LAYER],
        hwComplex pXtDagger[MAX_LAYER][2],
        hwComplex pYt[2][MAX_RX_ANT],
        hwComplex pHTranspose[MAX_LAYER][MAX_RX_ANT],
        int NumLayer,
        int NumRxAntenna)
{
    //////////////////// Freq Domain Estimate HTranspose ////////////////////
    hwComplex pXDX[MAX_LAYER][MAX_LAYER];
    hwComplex pInvXDX[MAX_LAYER][MAX_LAYER];
    hwComplex pXDY[MAX_LAYER][MAX_RX_ANT];

    for(int i=0; i<NumLayer; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
    #endif
        for(int j=0; j<NumLayer; j++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
        #endif
            hwComplex tmp;
            tmp.re=0;
            tmp.im=0;
            for(int k=0; k<2; k++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            #endif
                tmp=hwAdd(tmp,hwMul(pXtDagger[i][k],pXt[k][j]));
            }
            pXDX[i][j]=tmp;
        }
    }
    hwMatrixInv(NumLayer,pXDX,pInvXDX);


    for(int i=0; i<NumLayer; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
    #endif

        for(int j=0; j<NumRxAntenna; j++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RX_ANT)
        #endif
            hwComplex tmp;
            tmp.re=0;
            tmp.im=0;
            for(int k=0; k<2; k++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            #endif
                tmp=hwAdd(tmp,hwMul(pXtDagger[i][k],pYt[k][j]));
            }
            pXDY[i][j]=tmp;
        }
    }
    for(int i=0; i<NumLayer; i++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
    #endif
        for(int j=0; j<NumRxAntenna; j++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RX_ANT)
        #endif
            hwComplex tmp;
            tmp.re=0;
            tmp.im=0;
            for(int k=0; k<NumLayer; k++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
            #endif
                tmp=hwAdd(tmp,hwMul(pInvXDX[i][k],pXDY[k][j]));
            }
            pHTranspose[i][j]=tmp;
        }
    }
}

void hardware_Equalizer(
        hwComplex hardware_pDMRS[MAX_SLOT][MAX_LAYER][MAX_MDFT],
        hwComplex hardware_pInpData[MAX_SYM*MAX_LAYER][MAX_MDFT],
        hwComplex hardware_pEqW[MAX_MDFT][MAX_LAYER][MAX_RX_ANT],
        hwComplex hardware_pHdm[MAX_MDFT][MAX_RX_ANT][MAX_LAYER],
        hwComplex hardware_pOutData[MAX_SYM*MAX_LAYER][MAX_MDFT],
        int MDFT,
        int NumLayer,
        int NumRxAntenna,
        int NumULSymbSF)
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=MDFT
#pragma HLS INTERFACE s_axilite port=NumLayer
#pragma HLS INTERFACE s_axilite port=NumRxAntenna
#pragma HLS INTERFACE s_axilite port=NumULSymbSF
#pragma HLS RESOURCE variable=hardware_pDMRS core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pInpData core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pEqW core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pHdm core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pOutData core=RAM_1P_BRAM
#endif
    for(int m=0;m<MDFT;m++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MDFT)
    #endif

    /////////////////////////// Xt XtDagger ///////////////////////////
    hwComplex pXt[2][MAX_LAYER];
    hwComplex pXtDagger[MAX_LAYER][2];

    for(int slot=0;slot<2;slot++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    #endif
        for(int layer=0;layer<NumLayer;layer++)
            {
            #ifdef IS_HLS
            #pragma HLS PIPELINE enable_flush
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAYER)
            #endif

            pXt[slot][layer]=hardware_pDMRS[slot][layer][m];
            pXtDagger[layer][slot]=hwConj(hardware_pDMRS[slot][layer][m]);
            }
    }
    /////////////////////////// Yt ///////////////////////////
    hwComplex pYt [2][MAX_RX_ANT];
    for(int slot=0;slot<2;slot++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    #endif

        for(int nrx=0;nrx<NumRxAntenna;nrx++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_RX_ANT)
        #endif
            pYt[slot][nrx]=hardware_pInpData[nrx*2+slot][m];
        }
    }
    ////////////////////////// HTranspose////////////////////////
    hwComplex pHTranspose[MAX_LAYER][MAX_RX_ANT];

    //////////////////// Freq Domain Estimate HTranspose ////////////////////
    hardware_FDLSEstimation(pXt,pXtDagger,pYt,pHTranspose,NumLayer,NumRxAntenna);

    //////////////////// Freq Domain Equalize received Data /////////////////
    hardware_FDLSEqualization(hardware_pInpData,hardware_pEqW,hardware_pHdm,pHTranspose,hardware_pOutData,m,NumLayer, NumRxAntenna,NumULSymbSF);

    }
}
#endif
#endif

