#include "Pl_Descramble.h"
#ifndef IS_DATAFLOW
#ifndef IS_BARE

void hardware_Descramble(
        float hardware_pInpSeq[MAX_Layer*MAX_NInfoBits],
        float hardware_pScrambSeq[MAX_Layer*MAX_NInfoBits],
        float hardware_pOutSeq[MAX_Layer*MAX_NInfoBits],
        int hardware_NumLayer,
        int hardware_NInfoBits
)
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=hardware_NumLayer
#pragma HLS INTERFACE s_axilite port=hardware_NInfoBits
#pragma HLS RESOURCE variable=hardware_pInpSeq core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pScrambSeq core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pOutSeq core=RAM_1P_BRAM
#endif    
    int Mpn=hardware_NumLayer*hardware_NInfoBits;
    ///////////////////Scrambling////////////////////////////
    for(int n=0;n<Mpn;n++)
    {
        #ifdef IS_HLS
		#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_NInfoBits*MAX_Layer)
        #endif
        hardware_pOutSeq[n]=(hardware_pInpSeq[n] * hardware_pScrambSeq[n]);
    }

    return;
}

#endif
#endif
