#include "Pl_Demodulation.h"
#ifndef IS_DATAFLOW
#ifndef IS_BARE

void hardware_Demodulating(
        myComplex hardware_pDecQAMSeq [MAX_QAMLen*MAX_Layer],
        float hardware_pTable [MAX_MQAM][2],
        int hardware_pIdxTable [MAX_MQAM][MAX_BitsPerSymb],
        float hardware_pLLR [MAX_NInfoBits*MAX_Layer],
        float No,
        int hardware_QAMLen,
        int hardware_NumLayer,
        int hardware_MQAM,
        int hardware_BitsPerSymb
        )
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=No
#pragma HLS INTERFACE s_axilite port=hardware_QAMLen
#pragma HLS INTERFACE s_axilite port=hardware_NumLayer
#pragma HLS INTERFACE s_axilite port=hardware_MQAM
#pragma HLS INTERFACE s_axilite port=hardware_BitsPerSymb
#pragma HLS RESOURCE variable=hardware_pDecQAMSeq core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pTable core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pIdxTable core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pLLR core=RAM_1P_BRAM
#endif

    for(int nsymb=0;nsymb<hardware_QAMLen*hardware_NumLayer;nsymb++)
    {
    #ifdef IS_HLS
    #pragma HLS PIPELINE enable_flush
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_QAMLen*MAX_Layer)
    #endif
    //////////////////////Calc metric///////////////////////
    float pMetric [MAX_MQAM];
    for(int idx=0;idx<hardware_MQAM;idx++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MQAM)
        #endif
        float tmp_re = hardware_pDecQAMSeq[nsymb].re - hardware_pTable[idx][0];
        float tmp_im = hardware_pDecQAMSeq[nsymb].im - hardware_pTable[idx][1];
        pMetric[idx] = (tmp_re*tmp_re) + (tmp_im*tmp_im);
        }

    /////////////////// Generate LLR for each bit ///////////////
    for(int nbit=0;nbit<hardware_BitsPerSymb;nbit++)
        {
        #ifdef IS_HLS
        #pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BitsPerSymb)
        #endif
        float pMetricSet [2][MAX_MQAM/2];
        int MSidx0=0;
        int MSidx1=0;
        for(int midx=0;midx<hardware_MQAM;midx++)
            {
            #ifdef IS_HLS
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MQAM)
            #pragma HLS PIPELINE enable_flush
            #endif
            if(hardware_pIdxTable[midx][nbit]==0)
                {
                pMetricSet[0][MSidx0]=pMetric[midx];
                MSidx0++;
                }
            else
                {
                pMetricSet[1][MSidx1]=pMetric[midx];
                MSidx1++;
                }
            }
          float minZero = pMetricSet[0][0];
          float minOne = pMetricSet[1][0];
          for(int i=1;i<hardware_MQAM/2;i++)
            {
            #ifdef IS_HLS
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MQAM/2)
            #pragma HLS PIPELINE enable_flush
            #endif
            if(pMetricSet[0][i] < minZero)
                minZero = pMetricSet[0][i];
            if(pMetricSet[1][i] < minOne)
                minOne = pMetricSet[1][i];
            }

          if(No==(float)0)
            hardware_pLLR[nsymb*hardware_BitsPerSymb+nbit]=minZero-minOne;
           else
            hardware_pLLR[nsymb*hardware_BitsPerSymb+nbit]=(minZero-minOne)/No;
         }
    }
    return;
}

#endif
#endif
