#include "Df_Demodulation.h"
#ifndef IS_BARE
#ifndef IS_PIPELINE

void hwGenerateLLR_Phase1(
        float pMetric [MAX_MQAM],
        int hardware_pIdxTable [MAX_MQAM][MAX_BitsPerSymb],
        float pMetricSet [2][MAX_MQAM/2],
        int hardware_MQAM_in,
        int* hardware_MQAM_out,
        float No_in,
        float* No_out,
        int numBits_in,
        int* numBits_out,
        int nbit_in,
        int* nbit_out
        )
{
    int MSidx0=0;
    int MSidx1=0;
    for(int midx=0;midx<hardware_MQAM_in;midx++)
        {
        #ifdef IS_HLS
		#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MQAM)
        #endif
        if(hardware_pIdxTable[midx][nbit_in]==0)
            {
            pMetricSet[0][MSidx0]=pMetric[midx];
            MSidx0++;
            }
        else
            {
            pMetricSet[1][MSidx1]=pMetric[midx];
            MSidx1++;
            }
        }
    *hardware_MQAM_out = hardware_MQAM_in;
    *No_out = No_in;
    *numBits_out = numBits_in;
    *nbit_out = nbit_in;
}

void hwGenerateLLR_Phase2(
        float pMetricSet [2][MAX_MQAM/2],
        int hardware_MQAM,
        float* minZero,
        float* minOne,
        float No_in,
        float* No_out,
        int numBits_in,
        int* numBits_out,
        int nbit_in,
        int* nbit_out
)
{
	float minZero_tmp = pMetricSet[0][0];
	float minOne_tmp = pMetricSet[1][0];
	for(int i=1;i<hardware_MQAM/2;i++)
		{
		#ifdef IS_HLS
		#pragma HLS PIPELINE enable_flush
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MQAM/2)
		#endif
		if(pMetricSet[0][i] < minZero_tmp)
			minZero_tmp = pMetricSet[0][i];
		if(pMetricSet[1][i] < minOne_tmp)
			minOne_tmp = pMetricSet[1][i];
		}
	*minZero = minZero_tmp;
	*minOne = minOne_tmp;

	*No_out = No_in;
	*numBits_out = numBits_in;
	*nbit_out = nbit_in;
}

void hwGenerateLLR_Phase2half(
        float minZero,
        float minOne,
		float* minOut,
        float No_in,
        float* No_out,
        int numBits_in,
        int* numBits_out,
        int nbit_in,
        int* nbit_out
)
{
	*minOut = (minZero - minOne);
	*No_out = No_in;
	*numBits_out = numBits_in;
	*nbit_out = nbit_in;
}

void hwGenerateLLR_Phase3(
        float hardware_pLLR [MAX_NInfoBits*MAX_Layer],
        float minIn,
        float No,
        int numBits,
        int nbit
        )
{
    if(No==(float)0)
        hardware_pLLR[numBits+nbit]=minIn;
    else
        hardware_pLLR[numBits+nbit]=(minIn)/No;
}

void hwGenerateLLR(
        float pMetric [MAX_MQAM],
        int hardware_pIdxTable [MAX_MQAM][MAX_BitsPerSymb],
        float hardware_pLLR [MAX_NInfoBits*MAX_Layer],
        int hardware_MQAM,
        int hardware_BitsPerSymb,
        float No,
        int nsymb)
{
	int numBits = nsymb*hardware_BitsPerSymb;
	int numBits_1, numBits_2, numBits_2half;
    /////////////////// Generate LLR for each bit ///////////////
    for(int nbit=0;nbit<hardware_BitsPerSymb;nbit++)
        {
        #ifdef IS_HLS
		#pragma HLS DATAFLOW
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BitsPerSymb)
        #endif
        float pMetricSet [2][MAX_MQAM/2];
        float minZero, minOne, minTmp;

        float No_1, No_2, No_2half;
        int nbit_1, nbit_2, nbit_2half;
        int hardware_MQAM_1;

        hwGenerateLLR_Phase1(
                pMetric,
                hardware_pIdxTable,
                pMetricSet,
                hardware_MQAM,
                &hardware_MQAM_1,
                No,
                &No_1,
				numBits,
                &numBits_1,
                nbit,
                &nbit_1
                );

        hwGenerateLLR_Phase2(
                pMetricSet,
                hardware_MQAM_1,
                &minZero,
                &minOne,
                No_1,
                &No_2,
				numBits_1,
                &numBits_2,
                nbit_1,
                &nbit_2
                );

        hwGenerateLLR_Phase2half(
                minZero,
                minOne,
        		&minTmp,
                No_2,
                &No_2half,
                numBits_2,
                &numBits_2half,
                nbit_2,
                &nbit_2half
        );

        hwGenerateLLR_Phase3(
                hardware_pLLR,
                minTmp,
                No_2half,
				numBits_2half,
                nbit_2half
                );

         }
}

void hwCalcMetric_f1(
		myComplex hardware_pDecQAMSeq [MAX_QAMLen*MAX_Layer],
		float hardware_pTable [MAX_MQAM][2],
		float pMetric [MAX_MQAM],
		int nsymb_in,
		int hardware_MQAM_in
)
{
#ifdef IS_HLS
#pragma HLS INLINE off
#endif
    for(int idx=0;idx<hardware_MQAM_in;idx++)
        {
        #ifdef IS_HLS
		#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MQAM)
        #endif
        float tmp_re = hardware_pDecQAMSeq[nsymb_in].re - hardware_pTable[idx][0];
        float tmp_im = hardware_pDecQAMSeq[nsymb_in].im - hardware_pTable[idx][1];
        pMetric[idx] = (tmp_re*tmp_re) + (tmp_im*tmp_im);
        }
}

void hwCalcMetric_f2(
		int hardware_MQAM_in,
		int hardware_BitsPerSymb_in,
        int hardware_pIdxTable_in [MAX_MQAM][MAX_BitsPerSymb],
        int hardware_pIdxTable_out [MAX_MQAM][MAX_BitsPerSymb]
)
{
#ifdef IS_HLS
#pragma HLS INLINE off
#endif
    for(int ii=0; ii <hardware_MQAM_in; ii++)
    {
        #ifdef IS_HLS
		#pragma HLS PIPELINE enable_flush
        DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_MQAM)
        #endif
        for(int jj=0; jj<hardware_BitsPerSymb_in; jj++)
        {
            #ifdef IS_HLS
            DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_BitsPerSymb)
            #endif
            hardware_pIdxTable_out[ii][jj] = hardware_pIdxTable_in[ii][jj];
        }
    }
}

void hwCalcMetric(
        myComplex hardware_pDecQAMSeq [MAX_QAMLen*MAX_Layer],
        float hardware_pTable [MAX_MQAM][2],
        int hardware_pIdxTable_in [MAX_MQAM][MAX_BitsPerSymb],
        int hardware_pIdxTable_out [MAX_MQAM][MAX_BitsPerSymb],
        float pMetric [MAX_MQAM],
        int hardware_MQAM_in,
        int* hardware_MQAM_out,
        int hardware_BitsPerSymb_in,
        int* hardware_BitsPerSymb_out,
        float No_in,
        float* No_out,
        int nsymb_in,
        int* nsymb_out)

{

	hwCalcMetric_f1(
			hardware_pDecQAMSeq,
			hardware_pTable,
			pMetric,
			nsymb_in,
			hardware_MQAM_in);



	hwCalcMetric_f2(
			hardware_MQAM_in,
			hardware_BitsPerSymb_in,
	        hardware_pIdxTable_in,
	        hardware_pIdxTable_out);
    //hardware_pIdxTable_out = hardware_pIdxTable_in;

    *hardware_MQAM_out = hardware_MQAM_in;
    *hardware_BitsPerSymb_out = hardware_BitsPerSymb_in;
    *No_out = No_in;
    *nsymb_out = nsymb_in;
}




void hardware_Demodulating(
        myComplex hardware_pDecQAMSeq [MAX_QAMLen*MAX_Layer],
        float hardware_pTable [MAX_MQAM][2],
        int hardware_pIdxTable [MAX_MQAM][MAX_BitsPerSymb],
        float hardware_pLLR [MAX_NInfoBits*MAX_Layer],
        float No,
        int hardware_QAMLen,
        int hardware_NumLayer,
        int hardware_MQAM,
        int hardware_BitsPerSymb
        )
{
#ifdef IS_HLS
#pragma HLS INTERFACE s_axilite port=return
#pragma HLS INTERFACE s_axilite port=No
#pragma HLS INTERFACE s_axilite port=hardware_QAMLen
#pragma HLS INTERFACE s_axilite port=hardware_NumLayer
#pragma HLS INTERFACE s_axilite port=hardware_MQAM
#pragma HLS INTERFACE s_axilite port=hardware_BitsPerSymb
#pragma HLS RESOURCE variable=hardware_pDecQAMSeq core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pTable core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pIdxTable core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=hardware_pLLR core=RAM_1P_BRAM
#endif

    for(int nsymb=0;nsymb<hardware_QAMLen*hardware_NumLayer;nsymb++)
    {
    #ifdef IS_HLS
	#pragma HLS DATAFLOW
    DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_QAMLen*MAX_Layer)
    #endif
    //////////////////////Calc metric///////////////////////
    float pMetric [MAX_MQAM];
    int hardware_pIdxTable_1 [MAX_MQAM][MAX_BitsPerSymb];
    float No_1;
    int hardware_MQAM_1;
    int hardware_BitsPerSymb_1;
    int nsymb_1;

    hwCalcMetric(hardware_pDecQAMSeq,
            hardware_pTable,
            hardware_pIdxTable,
            hardware_pIdxTable_1,
            pMetric,
            hardware_MQAM,
            &hardware_MQAM_1,
            hardware_BitsPerSymb,
            &hardware_BitsPerSymb_1,
            No,
            &No_1,
            nsymb,
            &nsymb_1);

    hwGenerateLLR(
            pMetric,
            hardware_pIdxTable_1,
            hardware_pLLR,
            hardware_MQAM_1,
            hardware_BitsPerSymb_1,
            No_1,
            nsymb_1);

    }
    return;
}

#endif
#endif
