`timescale 1ns / 1ps

module top();
 
// AXI-lite  Control Ports 
wire [39:0]	Buffers_Control_AXI_araddr;
wire [2:0]	Buffers_Control_AXI_arprot;
wire [0:0]	Buffers_Control_AXI_arready;
wire [0:0]	Buffers_Control_AXI_arvalid;
wire [39:0]	Buffers_Control_AXI_awaddr;
wire [2:0]	Buffers_Control_AXI_awprot;
wire [0:0]	Buffers_Control_AXI_awready;
wire [0:0]	Buffers_Control_AXI_awvalid;
wire [0:0]	Buffers_Control_AXI_bready;
wire [1:0]	Buffers_Control_AXI_bresp;
wire [0:0]	Buffers_Control_AXI_bvalid;
wire [31:0]	Buffers_Control_AXI_rdata;
wire [0:0]	Buffers_Control_AXI_rready;
wire [1:0]	Buffers_Control_AXI_rresp;
wire [0:0]	Buffers_Control_AXI_rvalid;
wire [31:0]	Buffers_Control_AXI_wdata;
wire [0:0]	Buffers_Control_AXI_wready;
wire  [3:0]	Buffers_Control_AXI_wstrb;
wire  [0:0]	Buffers_Control_AXI_wvalid;

wire  [31:0]M_AXIS_MM2S_tdata;
wire  [3:0]M_AXIS_MM2S_tkeep;
wire  M_AXIS_MM2S_tlast;
wire  M_AXIS_MM2S_tready;
wire  M_AXIS_MM2S_tvalid;
wire [31:0]S_AXIS_S2MM_tdata;
wire [3:0]S_AXIS_S2MM_tkeep;
wire S_AXIS_S2MM_tlast;
wire  S_AXIS_S2MM_tready;
wire S_AXIS_S2MM_tvalid;

wire pl_clk;
wire pl_resetn;    
wire gpio_pr;    
wire interrupt;


                            
design_1_wrapper design_1_wrapper_i ( 
    .Buffers_Control_AXI_araddr     (Buffers_Control_AXI_araddr ),
    .Buffers_Control_AXI_arprot     (Buffers_Control_AXI_arprot ),
    .Buffers_Control_AXI_arready    (Buffers_Control_AXI_arready),
    .Buffers_Control_AXI_arvalid    (Buffers_Control_AXI_arvalid),
    .Buffers_Control_AXI_awaddr     (Buffers_Control_AXI_awaddr ),
    .Buffers_Control_AXI_awprot     (Buffers_Control_AXI_awprot ),
    .Buffers_Control_AXI_awready    (Buffers_Control_AXI_awready),
    .Buffers_Control_AXI_awvalid    (Buffers_Control_AXI_awvalid),
    .Buffers_Control_AXI_bready     (Buffers_Control_AXI_bready ),
    .Buffers_Control_AXI_bresp      (Buffers_Control_AXI_bresp  ),
    .Buffers_Control_AXI_bvalid     (Buffers_Control_AXI_bvalid ),
    .Buffers_Control_AXI_rdata      (Buffers_Control_AXI_rdata  ),
    .Buffers_Control_AXI_rready     (Buffers_Control_AXI_rready ),
    .Buffers_Control_AXI_rresp      (Buffers_Control_AXI_rresp  ),
    .Buffers_Control_AXI_rvalid     (Buffers_Control_AXI_rvalid ),
    .Buffers_Control_AXI_wdata      (Buffers_Control_AXI_wdata  ),
    .Buffers_Control_AXI_wready     (Buffers_Control_AXI_wready ),
    .Buffers_Control_AXI_wstrb      (Buffers_Control_AXI_wstrb  ),
    .Buffers_Control_AXI_wvalid     (Buffers_Control_AXI_wvalid ),
    
    
    .M_AXIS_MM2S_tdata    		(M_AXIS_MM2S_tdata),
    .M_AXIS_MM2S_tkeep    		(M_AXIS_MM2S_tkeep),
    .M_AXIS_MM2S_tlast    		(M_AXIS_MM2S_tlast),
    .M_AXIS_MM2S_tready   		(M_AXIS_MM2S_tready),
    .M_AXIS_MM2S_tvalid   		(M_AXIS_MM2S_tvalid),
    .S_AXIS_S2MM_tdata    		(S_AXIS_S2MM_tdata),
    .S_AXIS_S2MM_tkeep    		(S_AXIS_S2MM_tkeep),
    .S_AXIS_S2MM_tlast    		(S_AXIS_S2MM_tlast),
    .S_AXIS_S2MM_tready   		(S_AXIS_S2MM_tready),
    .S_AXIS_S2MM_tvalid   		(S_AXIS_S2MM_tvalid),
    .pl_clk                     (pl_clk),
    .pl_resetn                  (pl_resetn),
    .gpio_pr                    (gpio_pr)
	);


Kernel
/*# (
	.C_S00_AXI_DATA_WIDTH(32)  ,
	.C_S00_AXI_ADDR_WIDTH(32)   ,
	.C_M00_AXIS_TDATA_WIDTH(32),
	.C_M00_AXIS_TADDR_WIDTH(32),
	.C_M00_AXIS_START_COUNT(32),
	.C_S00_AXIS_TDATA_WIDTH(32),
	.C_S00_AXIS_TADDR_WIDTH(32)
	)*/ kernel_i(
    .pl_clk             (pl_clk),
    .pl_resetn          (pl_resetn&gpio_pr),
    //AXI lite
	.s00_axi_awaddr     (Buffers_Control_AXI_awaddr),
    .s00_axi_awprot     (Buffers_Control_AXI_awprot),
    .s00_axi_awvalid    (Buffers_Control_AXI_awvalid),
    .s00_axi_awready    (Buffers_Control_AXI_awready),
    .s00_axi_wdata      (Buffers_Control_AXI_wdata),
    .s00_axi_wstrb      (Buffers_Control_AXI_wstrb),
    .s00_axi_wvalid     (Buffers_Control_AXI_wvalid),
    .s00_axi_wready     (Buffers_Control_AXI_wready),
    .s00_axi_bresp      (Buffers_Control_AXI_bresp),
    .s00_axi_bvalid     (Buffers_Control_AXI_bvalid),
    .s00_axi_bready     (Buffers_Control_AXI_bready),
    .s00_axi_araddr     (Buffers_Control_AXI_araddr),
    .s00_axi_arprot     (Buffers_Control_AXI_arprot),
    .s00_axi_arvalid    (Buffers_Control_AXI_arvalid),
    .s00_axi_arready    (Buffers_Control_AXI_arready),
    .s00_axi_rdata      (Buffers_Control_AXI_rdata),
    .s00_axi_rresp      (Buffers_Control_AXI_rresp),
    .s00_axi_rvalid     (Buffers_Control_AXI_rvalid),
    .s00_axi_rready     (Buffers_Control_AXI_rready),
    // S2MM
    .m00_axis_tvalid    (S_AXIS_S2MM_tvalid),
    .m00_axis_tdata     (S_AXIS_S2MM_tdata),
    .m00_axis_tstrb     (S_AXIS_S2MM_tkeep),
    .m00_axis_tlast     (S_AXIS_S2MM_tlast),
    .m00_axis_tready    (S_AXIS_S2MM_tready),
    
    .s00_axis_tready    (M_AXIS_MM2S_tready),
    .s00_axis_tdata     (M_AXIS_MM2S_tdata),
    .s00_axis_tstrb     (M_AXIS_MM2S_tkeep),
    .s00_axis_tlast     (M_AXIS_MM2S_tlast),
    .s00_axis_tvalid    (M_AXIS_MM2S_tvalid)
);

/*
ila_1 ila_i(
.clk     (pl_clk),
.probe0  ({Buffers_Control_AXI_rdata, Buffers_Control_AXI_rvalid, Buffers_Control_AXI_wdata, Buffers_Control_AXI_wvalid}),
.probe1  ({M_AXIS_MM2S_tdata, M_AXIS_MM2S_tlast, M_AXIS_MM2S_tready, M_AXIS_MM2S_tvalid}),
.probe2  ({S_AXIS_S2MM_tdata, S_AXIS_S2MM_tlast, S_AXIS_S2MM_tready, S_AXIS_S2MM_tvalid})
);
*/

    
endmodule
