`timescale 1ns / 1ps

module Windowing(
	input      pl_clk,
	input      pl_rstn,
	
	input [31:0] In_Data,
    input In_En,
    input [31:0] In_Addr,
    input [31:0] Out_Addr,
    output[31:0] Out_Data,
    input [31:0] Select,

    input   [15:0]      start,
    output  [15:0]      done,
    output  [15:0]      idle,
    output  [15:0]      ready,
    input   [31:0]      n,
    input   [31:0]      lay,
    output  [15:0]      power_vld,
	input [31:0] inPow_Rx1_L1,
	input [31:0] inPow_Rx1_L2,
	input [31:0] inPow_Rx1_L3,
	input [31:0] inPow_Rx1_L4,
	/*input [31:0] inPow_Rx2_L1,
	input [31:0] inPow_Rx2_L2,
	input [31:0] inPow_Rx2_L3,
	input [31:0] inPow_Rx2_L4,
	input [31:0] inPow_Rx3_L1,
	input [31:0] inPow_Rx3_L2,
	input [31:0] inPow_Rx3_L3,
	input [31:0] inPow_Rx3_L4,
	input [31:0] inPow_Rx4_L1,
	input [31:0] inPow_Rx4_L2,
	input [31:0] inPow_Rx4_L3,
	input [31:0] inPow_Rx4_L4,*/
	output [31:0] Rx1_L1_power,	
    output [31:0] Rx1_L2_power,	
    output [31:0] Rx1_L3_power,
    output [31:0] Rx1_L4_power/*,	
    output [31:0] Rx2_L1_power,	
    output [31:0] Rx2_L2_power,	
    output [31:0] Rx2_L3_power,	
    output [31:0] Rx2_L4_power,	
    output [31:0] Rx3_L1_power,	
    output [31:0] Rx3_L2_power,	
    output [31:0] Rx3_L3_power,	
    output [31:0] Rx3_L4_power,	
    output [31:0] Rx4_L1_power,	
    output [31:0] Rx4_L2_power,	
    output [31:0] Rx4_L3_power,	
    output [31:0] Rx4_L4_power*/
    );
    
wire [31:0] in_Rx1_L1_address0 ;
wire [31:0] in_Rx1_L1_q0       ;
wire 		out_Rx1_L1_we0     ;
wire [31:0] out_Rx1_L1_address0;
wire [31:0] out_Rx1_L1_d0      ;
/*   
wire [31:0] in_Rx1_L2_address0 ;
wire [31:0] in_Rx1_L2_q0       ;
wire 		out_Rx1_L2_we0     ;
wire [31:0] out_Rx1_L2_address0;
wire [31:0] out_Rx1_L2_d0      ;   
 wire [31:0] in_Rx1_L3_address0;
wire [31:0] in_Rx1_L3_q0       ;
wire 		out_Rx1_L3_we0     ;
wire [31:0] out_Rx1_L3_address0;
wire [31:0] out_Rx1_L3_d0      ;   
wire [31:0] in_Rx1_L4_address0 ;
wire [31:0] in_Rx1_L4_q0       ;
wire 		out_Rx1_L4_we0     ;
wire [31:0] out_Rx1_L4_address0;
wire [31:0] out_Rx1_L4_d0      ;   
wire [31:0] in_Rx2_L1_address0 ;
wire [31:0] in_Rx2_L1_q0       ;
wire 		out_Rx2_L1_we0     ;
wire [31:0] out_Rx2_L1_address0;
wire [31:0] out_Rx2_L1_d0      ;   
wire [31:0] in_Rx2_L2_address0 ;
wire [31:0] in_Rx2_L2_q0       ;
wire 		out_Rx2_L2_we0     ;
wire [31:0] out_Rx2_L2_address0;
wire [31:0] out_Rx2_L2_d0      ;   
 wire [31:0] in_Rx2_L3_address0;
wire [31:0] in_Rx2_L3_q0       ;
wire 		out_Rx2_L3_we0     ;
wire [31:0] out_Rx2_L3_address0;
wire [31:0] out_Rx2_L3_d0      ;   
wire [31:0] in_Rx2_L4_address0 ;
wire [31:0] in_Rx2_L4_q0       ;
wire 		out_Rx2_L4_we0     ;
wire [31:0] out_Rx2_L4_address0;
wire [31:0] out_Rx2_L4_d0      ; 
wire [31:0] in_Rx3_L1_address0 ;
wire [31:0] in_Rx3_L1_q0       ;
wire 		out_Rx3_L1_we0     ;
wire [31:0] out_Rx3_L1_address0;
wire [31:0] out_Rx3_L1_d0      ;   
wire [31:0] in_Rx3_L2_address0 ;
wire [31:0] in_Rx3_L2_q0       ;
wire 		out_Rx3_L2_we0     ;
wire [31:0] out_Rx3_L2_address0;
wire [31:0] out_Rx3_L2_d0      ;   
wire [31:0] in_Rx3_L3_address0 ;
wire [31:0] in_Rx3_L3_q0       ;
wire 		out_Rx3_L3_we0     ;
wire [31:0] out_Rx3_L3_address0;
wire [31:0] out_Rx3_L3_d0      ;   
wire [31:0] in_Rx3_L4_address0 ;
wire [31:0] in_Rx3_L4_q0       ;
wire 		out_Rx3_L4_we0     ;
wire [31:0] out_Rx3_L4_address0;
wire [31:0] out_Rx3_L4_d0      ;   
wire [31:0] in_Rx4_L1_address0 ;
wire [31:0] in_Rx4_L1_q0       ;
wire 		out_Rx4_L1_we0     ;
wire [31:0] out_Rx4_L1_address0;
wire [31:0] out_Rx4_L1_d0      ;   
wire [31:0] in_Rx4_L2_address0 ;
wire [31:0] in_Rx4_L2_q0       ;
wire 		out_Rx4_L2_we0     ;
wire [31:0] out_Rx4_L2_address0;
wire [31:0] out_Rx4_L2_d0      ;   
 wire [31:0] in_Rx4_L3_address0;
wire [31:0] in_Rx4_L3_q0       ;
wire 		out_Rx4_L3_we0     ;
wire [31:0] out_Rx4_L3_address0;
wire [31:0] out_Rx4_L3_d0      ;   
wire [31:0] in_Rx4_L4_address0 ;
wire [31:0] in_Rx4_L4_q0       ;
wire 		out_Rx4_L4_we0     ;
wire [31:0] out_Rx4_L4_address0;
wire [31:0] out_Rx4_L4_d0      ; 
*/
wire [31:0] out_Rx1_L1_data;
/*
wire [31:0] out_Rx1_L2_data;
wire [31:0] out_Rx1_L3_data;
wire [31:0] out_Rx1_L4_data;
wire [31:0] out_Rx2_L1_data;
wire [31:0] out_Rx2_L2_data;
wire [31:0] out_Rx2_L3_data;
wire [31:0] out_Rx2_L4_data;
wire [31:0] out_Rx3_L1_data;
wire [31:0] out_Rx3_L2_data;
wire [31:0] out_Rx3_L3_data;
wire [31:0] out_Rx3_L4_data;
wire [31:0] out_Rx4_L1_data;
wire [31:0] out_Rx4_L2_data;
wire [31:0] out_Rx4_L3_data;
wire [31:0] out_Rx4_L4_data;
*/

assign Out_Data = (Select ==32'd32)? out_Rx1_L1_data:0;/*(
			(Select ==32'd33)?  out_Rx1_L2_data:(
			(Select ==32'd34)?  out_Rx1_L3_data:(
			(Select ==32'd35)?  out_Rx1_L4_data:(
			(Select ==32'd36)?  out_Rx2_L1_data:(
			(Select ==32'd37)?  out_Rx2_L2_data:(
			(Select ==32'd38)?  out_Rx2_L3_data:(
			(Select ==32'd39)?  out_Rx2_L4_data:(
			(Select ==32'd40)?  out_Rx3_L1_data:(
			(Select ==32'd41)?  out_Rx3_L2_data:(
			(Select ==32'd42)?  out_Rx3_L3_data:(
			(Select ==32'd43)?  out_Rx3_L4_data:(
			(Select ==32'd44)?  out_Rx4_L1_data:(
			(Select ==32'd45)?  out_Rx4_L2_data:(
			(Select ==32'd46)?  out_Rx4_L3_data:(
			(Select ==32'd47)?  out_Rx4_L4_data:32'd0)))))))))))))));*/

Windowing_simpDual_19200_32bits Rx1_L1_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd0)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx1_L1_address0),
    .doutb  (in_Rx1_L1_q0)
  );
Windowing_simpDual_19200_32bits Rx1_L1_out(
    .clka   (pl_clk),
    .wea    (out_Rx1_L1_we0),
    .addra  (out_Rx1_L1_address0),
    .dina   (out_Rx1_L1_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx1_L1_data)
  );
  
chest_0 chest_Rx1_L1(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[0]),
    .ap_done       (done[0]),
    .ap_idle       (idle[0]),
    .ap_ready      (ready[0]),
    .n             (n),
    .lay           (lay),
    .out_power_0_ap_vld  (power_vld[0]),
    .out_power_1_ap_vld  (power_vld[1]),
    .out_power_2_ap_vld  (power_vld[2]),
    .out_power_3_ap_vld  (power_vld[3]),
    .out_power_0         (Rx1_L1_power    ),
    .out_power_1         (Rx1_L2_power    ),
    .out_power_2         (Rx1_L3_power    ),
    .out_power_3         (Rx1_L4_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx1_L1_address0),
	.in_r_q0	    (in_Rx1_L1_q0),
	.in_power_0     (inPow_Rx1_L1),
	.in_power_1     (inPow_Rx1_L2),
	.in_power_2     (inPow_Rx1_L3),
	.in_power_3     (inPow_Rx1_L4),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx1_L1_we0),
	.out_r_address0 (out_Rx1_L1_address0),
	.out_r_d0       (out_Rx1_L1_d0)
);
/*
ila_0 ila_i(
    .clk     (pl_clk),
    .probe0 ({start[0], done[0], idle[0], ready[0], power_vld[0]}),
    .probe1 ({n, Rx1_L1_power, inPow_Rx1_L1}),
    .probe2 ({in_Rx1_L1_address0, in_Rx1_L1_q0}),
    .probe3 ({out_Rx1_L1_address0, out_Rx1_L1_d0, out_Rx1_L1_we0})
);
*/
assign done[15:1]  = 15'd0;
assign idle[15:1]  = 15'd0;
assign ready[15:1] = 15'd0;

/*
blk_mem_simpDual_1200_32bits Rx1_L2_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd1)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx1_L2_address0),
    .doutb  (in_Rx1_L2_q0)
  ); 
blk_mem_simpDual_1200_32bits Rx1_L2_out(
    .clka   (pl_clk),
    .wea    (out_Rx1_L2_we0),
    .addra  (out_Rx1_L2_address0),
    .dina   (out_Rx1_L2_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx1_L2_data)
  );         
chest_0 chest_Rx1_L2(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[1]),
    .ap_done       (done[1]),
    .ap_idle       (idle[1]),
    .ap_ready      (ready[1]),
    .n             (n),
    .out_power_ap_vld  (power_vld[1]),
    .out_power         (Rx1_L2_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx1_L2_address0),
	.in_r_q0	    (in_Rx1_L2_q0),
	.in_power       (inPow_Rx1_L2),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx1_L2_we0),
	.out_r_address0 (out_Rx1_L2_address0),
	.out_r_d0       (out_Rx1_L2_d0)
);   

blk_mem_simpDual_1200_32bits Rx1_L3_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd2)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx1_L3_address0),
    .doutb  (in_Rx1_L3_q0)
  );
blk_mem_simpDual_1200_32bits Rx1_L3_out(
    .clka   (pl_clk),
    .wea    (out_Rx1_L3_we0),
    .addra  (out_Rx1_L3_address0),
    .dina   (out_Rx1_L3_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx1_L3_data)
  );
  
chest_0 chest_Rx1_L3(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[2]),
    .ap_done       (done[2]),
    .ap_idle       (idle[2]),
    .ap_ready      (ready[2]),
    .n             (n),
    .out_power_ap_vld  (power_vld[2]),
    .out_power         (Rx1_L3_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx1_L3_address0),
	.in_r_q0	    (in_Rx1_L3_q0),
	.in_power       (inPow_Rx1_L3),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx1_L3_we0),
	.out_r_address0 (out_Rx1_L3_address0),
	.out_r_d0       (out_Rx1_L3_d0)
);


blk_mem_simpDual_1200_32bits Rx1_L4_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd3)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx1_L4_address0),
    .doutb  (in_Rx1_L4_q0)
  );
blk_mem_simpDual_1200_32bits Rx1_L4_out(
    .clka   (pl_clk),
    .wea    (out_Rx1_L4_we0),
    .addra  (out_Rx1_L4_address0),
    .dina   (out_Rx1_L4_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx1_L4_data)
  );         
chest_0 chest_Rx1_L4(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[3]),
    .ap_done       (done[3]),
    .ap_idle       (idle[3]),
    .ap_ready      (ready[3]),
    .n             (n),
    .out_power_ap_vld  (power_vld[3]),
    .out_power         (Rx1_L4_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx1_L4_address0),
	.in_r_q0	    (in_Rx1_L4_q0),
	.in_power       (inPow_Rx1_L4),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx1_L4_we0),
	.out_r_address0 (out_Rx1_L4_address0),
	.out_r_d0       (out_Rx1_L4_d0)
);  

blk_mem_simpDual_1200_32bits Rx2_L1_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd4)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx2_L1_address0),
    .doutb  (in_Rx2_L1_q0)
  );
blk_mem_simpDual_1200_32bits Rx2_L1_out(
    .clka   (pl_clk),
    .wea    (out_Rx2_L1_we0),
    .addra  (out_Rx2_L1_address0),
    .dina   (out_Rx2_L1_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx2_L1_data)
  );
  
chest_0 chest_Rx2_L1(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[4]),
    .ap_done       (done[4]),
    .ap_idle       (idle[4]),
    .ap_ready      (ready[4]),
    .n             (n),
    .out_power_ap_vld  (power_vld[4]),
    .out_power         (Rx2_L1_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx2_L1_address0),
	.in_r_q0	    (in_Rx2_L1_q0),
	.in_power       (inPow_Rx2_L1),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx2_L1_we0),
	.out_r_address0 (out_Rx2_L1_address0),
	.out_r_d0       (out_Rx2_L1_d0)
);


blk_mem_simpDual_1200_32bits Rx2_L2_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd5)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx2_L2_address0),
    .doutb  (in_Rx2_L2_q0)
  );
blk_mem_simpDual_1200_32bits Rx2_L2_out(
    .clka   (pl_clk),
    .wea    (out_Rx2_L2_we0),
    .addra  (out_Rx2_L2_address0),
    .dina   (out_Rx2_L2_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx2_L2_data)
  );         
chest_0 chest_Rx2_L2(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[5]),
    .ap_done       (done[5]),
    .ap_idle       (idle[5]),
    .ap_ready      (ready[5]),
    .n             (n),
    .out_power_ap_vld  (power_vld[5]),
    .out_power         (Rx2_L2_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx2_L2_address0),
	.in_r_q0	    (in_Rx2_L2_q0),
	.in_power       (inPow_Rx2_L2),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx2_L2_we0),
	.out_r_address0 (out_Rx2_L2_address0),
	.out_r_d0       (out_Rx2_L2_d0)
);   

blk_mem_simpDual_1200_32bits Rx2_L3_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd6)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx2_L3_address0),
    .doutb  (in_Rx2_L3_q0)
  );    
blk_mem_simpDual_1200_32bits Rx2_L3_out(
    .clka   (pl_clk),
    .wea    (out_Rx2_L3_we0),
    .addra  (out_Rx2_L3_address0),
    .dina   (out_Rx2_L3_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx2_L3_data)
  );
  
chest_0 chest_Rx2_L3(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[6]),
    .ap_done       (done[6]),
    .ap_idle       (idle[6]),
    .ap_ready      (ready[6]),
    .n             (n),
    .out_power_ap_vld  (power_vld[6]),
    .out_power         (Rx2_L3_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx2_L3_address0),
	.in_r_q0	    (in_Rx2_L3_q0),
	.in_power       (inPow_Rx2_L3),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx2_L3_we0),
	.out_r_address0 (out_Rx2_L3_address0),
	.out_r_d0       (out_Rx2_L3_d0)
);


blk_mem_simpDual_1200_32bits Rx2_L4_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd7)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx2_L4_address0),
    .doutb  (in_Rx2_L4_q0)
  );
blk_mem_simpDual_1200_32bits Rx2_L4_out(
    .clka   (pl_clk),
    .wea    (out_Rx2_L4_we0),
    .addra  (out_Rx2_L4_address0),
    .dina   (out_Rx2_L4_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx2_L4_data)
  );         
chest_0 chest_Rx2_L4(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[7]),
    .ap_done       (done[7]),
    .ap_idle       (idle[7]),
    .ap_ready      (ready[7]),
    .n             (n),
    .out_power_ap_vld  (power_vld[7]),
    .out_power         (Rx2_L4_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx2_L4_address0),
	.in_r_q0	    (in_Rx2_L4_q0),
	.in_power       (inPow_Rx2_L4),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx2_L4_we0),
	.out_r_address0 (out_Rx2_L4_address0),
	.out_r_d0       (out_Rx2_L4_d0)
);


blk_mem_simpDual_1200_32bits Rx3_L1_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd8)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx3_L1_address0),
    .doutb  (in_Rx3_L1_q0)
  );
blk_mem_simpDual_1200_32bits Rx3_L1_out(
    .clka   (pl_clk),
    .wea    (out_Rx3_L1_we0),
    .addra  (out_Rx3_L1_address0),
    .dina   (out_Rx3_L1_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx3_L1_data)
  );
  
chest_0 chest_Rx3_L1(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[8]),
    .ap_done       (done[8]),
    .ap_idle       (idle[8]),
    .ap_ready      (ready[8]),
    .n             (n),
    .out_power_ap_vld  (power_vld[8]),
    .out_power         (Rx3_L1_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx3_L1_address0),
	.in_r_q0	    (in_Rx3_L1_q0),
	.in_power       (inPow_Rx3_L1),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx3_L1_we0),
	.out_r_address0 (out_Rx3_L1_address0),
	.out_r_d0       (out_Rx3_L1_d0)
);


blk_mem_simpDual_1200_32bits Rx3_L2_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd9)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx3_L2_address0),
    .doutb  (in_Rx3_L2_q0)
  );  
blk_mem_simpDual_1200_32bits Rx3_L2_out(
    .clka   (pl_clk),
    .wea    (out_Rx3_L2_we0),
    .addra  (out_Rx3_L2_address0),
    .dina   (out_Rx3_L2_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx3_L2_data)
  );         
chest_0 chest_Rx3_L2(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[9]),
    .ap_done       (done[9]),
    .ap_idle       (idle[9]),
    .ap_ready      (ready[9]),
    .n             (n),
    .out_power_ap_vld  (power_vld[9]),
    .out_power         (Rx3_L2_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx3_L2_address0),
	.in_r_q0	    (in_Rx3_L2_q0),
	.in_power       (inPow_Rx3_L2),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx3_L2_we0),
	.out_r_address0 (out_Rx3_L2_address0),
	.out_r_d0       (out_Rx3_L2_d0)
);   

blk_mem_simpDual_1200_32bits Rx3_L3_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd10)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx3_L3_address0),
    .doutb  (in_Rx3_L3_q0)
  );
blk_mem_simpDual_1200_32bits Rx3_L3_out(
    .clka   (pl_clk),
    .wea    (out_Rx3_L3_we0),
    .addra  (out_Rx3_L3_address0),
    .dina   (out_Rx3_L3_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx3_L3_data)
  );
  
chest_0 chest_Rx3_L3(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[10]),
    .ap_done       (done[10]),
    .ap_idle       (idle[10]),
    .ap_ready      (ready[10]),
    .n             (n),
    .out_power_ap_vld  (power_vld[10]),
    .out_power         (Rx3_L3_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx3_L3_address0),
	.in_r_q0	    (in_Rx3_L3_q0),
	.in_power       (inPow_Rx3_L3),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx3_L3_we0),
	.out_r_address0 (out_Rx3_L3_address0),
	.out_r_d0       (out_Rx3_L3_d0)
);


blk_mem_simpDual_1200_32bits Rx3_L4_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd11)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx3_L4_address0),
    .doutb  (in_Rx3_L4_q0)
  ); 
blk_mem_simpDual_1200_32bits Rx3_L4_out(
    .clka   (pl_clk),
    .wea    (out_Rx3_L4_we0),
    .addra  (out_Rx3_L4_address0),
    .dina   (out_Rx3_L4_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx3_L4_data)
  );         
chest_0 chest_Rx3_L4(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[11]),
    .ap_done       (done[11]),
    .ap_idle       (idle[11]),
    .ap_ready      (ready[11]),
    .n             (n),
    .out_power_ap_vld  (power_vld[11]),
    .out_power         (Rx3_L4_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx3_L4_address0),
	.in_r_q0	    (in_Rx3_L4_q0),
	.in_power          (inPow_Rx3_L4),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx3_L4_we0),
	.out_r_address0 (out_Rx3_L4_address0),
	.out_r_d0       (out_Rx3_L4_d0)
);  

blk_mem_simpDual_1200_32bits Rx4_L1_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd12)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx4_L1_address0),
    .doutb  (in_Rx4_L1_q0)
  );
blk_mem_simpDual_1200_32bits Rx4_L1_out(
    .clka   (pl_clk),
    .wea    (out_Rx4_L1_we0),
    .addra  (out_Rx4_L1_address0),
    .dina   (out_Rx4_L1_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx4_L1_data)
  );
  
chest_0 chest_Rx4_L1(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[12]),
    .ap_done       (done[12]),
    .ap_idle       (idle[12]),
    .ap_ready      (ready[12]),
    .n             (n),
    .out_power_ap_vld  (power_vld[12]),
    .out_power         (Rx4_L1_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx4_L1_address0),
	.in_r_q0	    (in_Rx4_L1_q0),
	.in_power       (inPow_Rx4_L1),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx4_L1_we0),
	.out_r_address0 (out_Rx4_L1_address0),
	.out_r_d0       (out_Rx4_L1_d0)
);


blk_mem_simpDual_1200_32bits Rx4_L2_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd13)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx4_L2_address0),
    .doutb  (in_Rx4_L2_q0)
  );
blk_mem_simpDual_1200_32bits Rx4_L2_out(
    .clka   (pl_clk),
    .wea    (out_Rx4_L2_we0),
    .addra  (out_Rx4_L2_address0),
    .dina   (out_Rx4_L2_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx4_L2_data)
  );         
chest_0 chest_Rx4_L2(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[13]),
    .ap_done       (done[13]),
    .ap_idle       (idle[13]),
    .ap_ready      (ready[13]),
    .n             (n),
    .out_power_ap_vld  (power_vld[13]),
    .out_power         (Rx4_L2_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx4_L2_address0),
	.in_r_q0	    (in_Rx4_L2_q0),
	.in_power       (inPow_Rx4_L2),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx4_L2_we0),
	.out_r_address0 (out_Rx4_L2_address0),
	.out_r_d0       (out_Rx4_L2_d0)
);   

blk_mem_simpDual_1200_32bits Rx4_L3_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd14)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx4_L3_address0),
    .doutb  (in_Rx4_L3_q0)
  );   
blk_mem_simpDual_1200_32bits Rx4_L3_out(
    .clka   (pl_clk),
    .wea    (out_Rx4_L3_we0),
    .addra  (out_Rx4_L3_address0),
    .dina   (out_Rx4_L3_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx4_L3_data)
  );
  
chest_0 chest_Rx4_L3(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[14]),
    .ap_done       (done[14]),
    .ap_idle       (idle[14]),
    .ap_ready      (ready[14]),
    .n             (n),
    .out_power_ap_vld  (power_vld[14]),
    .out_power         (Rx4_L3_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx4_L3_address0),
	.in_r_q0	    (in_Rx4_L3_q0),
	.in_power       (inPow_Rx4_L3),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx4_L3_we0),
	.out_r_address0 (out_Rx4_L3_address0),
	.out_r_d0       (out_Rx4_L3_d0)
);


blk_mem_simpDual_1200_32bits Rx4_L4_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd15)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx4_L4_address0),
    .doutb  (in_Rx4_L4_q0)
  );   
blk_mem_simpDual_1200_32bits Rx4_L4_out(
    .clka   (pl_clk),
    .wea    (out_Rx4_L4_we0),
    .addra  (out_Rx4_L4_address0),
    .dina   (out_Rx4_L4_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx4_L4_data)
  );         
chest_0 chest_Rx4_L4(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[15]),
    .ap_done       (done[15]),
    .ap_idle       (idle[15]),
    .ap_ready      (ready[15]),
    .n             (n),
    .out_power_ap_vld  (power_vld[15]),
    .out_power         (Rx4_L4_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx4_L4_address0),
	.in_r_q0	    (in_Rx4_L4_q0),
	.in_power       (inPow_Rx4_L4),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx4_L4_we0),
	.out_r_address0 (out_Rx4_L4_address0),
	.out_r_d0       (out_Rx4_L4_d0)
);
*/ 
endmodule
