
`timescale 1 ns / 1 ps

	module Kernel_Interface_v1_0_S00_AXI #
	(
		// Users to add parameters here

		// User parameters ends
		// Do not modify the parameters beyond this line

		// Width of S_AXI data bus
		parameter integer C_S_AXI_DATA_WIDTH	= 32,
		// Width of S_AXI address bus
		parameter integer C_S_AXI_ADDR_WIDTH	= 32
	)
	(
		// Users to add ports here
		//<alihgh -Add
        output 	   alihgh_MIn_Start,
        output 	   alihgh_MOut_Start,
        output     [C_S_AXI_DATA_WIDTH-1 : 0] alihgh_MIn_Size,
        output     [C_S_AXI_DATA_WIDTH-1 : 0] alihgh_MOut_Size,
        output     [C_S_AXI_DATA_WIDTH-1 : 0] alihgh_Mem_Select,
        input      alihgh_MIn_Done, 
        input      alihgh_MOut_Done, 
       
        output [15:0] alihgh_start,
        input  [15:0] alihgh_done,
        input  [15:0] alihgh_idle,
        input  [15:0] alihgh_ready,
        output [31:0] alihgh_n,
        output [31:0] alihgh_lay,
        input  [15:0] alihgh_power_vld,
        input [31:0] alihgh_Rx1_L1_power,
        input [31:0] alihgh_Rx1_L2_power,
        input [31:0] alihgh_Rx1_L3_power,
        input [31:0] alihgh_Rx1_L4_power,
        /*input [31:0] alihgh_Rx2_L1_power,
        input [31:0] alihgh_Rx2_L2_power,
        input [31:0] alihgh_Rx2_L3_power,
        input [31:0] alihgh_Rx2_L4_power,
        input [31:0] alihgh_Rx3_L1_power,
        input [31:0] alihgh_Rx3_L2_power,
        input [31:0] alihgh_Rx3_L3_power,
        input [31:0] alihgh_Rx3_L4_power,
        input [31:0] alihgh_Rx4_L1_power,
        input [31:0] alihgh_Rx4_L2_power,
        input [31:0] alihgh_Rx4_L3_power,
        input [31:0] alihgh_Rx4_L4_power,  */      
		//alihgh>	
		// User ports ends
		// Do not modify the ports beyond this line

		// Global Clock Signal
		input wire  S_AXI_ACLK,
		// Global Reset Signal. This Signal is Active LOW
		input wire  S_AXI_ARESETN,
		// Write address (issued by master, acceped by Slave)
		input wire [C_S_AXI_ADDR_WIDTH-1 : 0] S_AXI_AWADDR,
		// Write channel Protection type. This signal indicates the
    		// privilege and security level of the transaction, and whether
    		// the transaction is a data access or an instruction access.
		input wire [2 : 0] S_AXI_AWPROT,
		// Write address valid. This signal indicates that the master signaling
    		// valid write address and control information.
		input wire  S_AXI_AWVALID,
		// Write address ready. This signal indicates that the slave is ready
    		// to accept an address and associated control signals.
		output wire  S_AXI_AWREADY,
		// Write data (issued by master, acceped by Slave) 
		input wire [C_S_AXI_DATA_WIDTH-1 : 0] S_AXI_WDATA,
		// Write strobes. This signal indicates which byte lanes hold
    		// valid data. There is one write strobe bit for each eight
    		// bits of the write data bus.    
		input wire [(C_S_AXI_DATA_WIDTH/8)-1 : 0] S_AXI_WSTRB,
		// Write valid. This signal indicates that valid write
    		// data and strobes are available.
		input wire  S_AXI_WVALID,
		// Write ready. This signal indicates that the slave
    		// can accept the write data.
		output wire  S_AXI_WREADY,
		// Write response. This signal indicates the status
    		// of the write transaction.
		output wire [1 : 0] S_AXI_BRESP,
		// Write response valid. This signal indicates that the channel
    		// is signaling a valid write response.
		output wire  S_AXI_BVALID,
		// Response ready. This signal indicates that the master
    		// can accept a write response.
		input wire  S_AXI_BREADY,
		// Read address (issued by master, acceped by Slave)
		input wire [C_S_AXI_ADDR_WIDTH-1 : 0] S_AXI_ARADDR,
		// Protection type. This signal indicates the privilege
    		// and security level of the transaction, and whether the
    		// transaction is a data access or an instruction access.
		input wire [2 : 0] S_AXI_ARPROT,
		// Read address valid. This signal indicates that the channel
    		// is signaling valid read address and control information.
		input wire  S_AXI_ARVALID,
		// Read address ready. This signal indicates that the slave is
    		// ready to accept an address and associated control signals.
		output wire  S_AXI_ARREADY,
		// Read data (issued by slave)
		output wire [C_S_AXI_DATA_WIDTH-1 : 0] S_AXI_RDATA,
		// Read response. This signal indicates the status of the
    		// read transfer.
		output wire [1 : 0] S_AXI_RRESP,
		// Read valid. This signal indicates that the channel is
    		// signaling the required read data.
		output wire  S_AXI_RVALID,
		// Read ready. This signal indicates that the master can
    		// accept the read data and response information.
		input wire  S_AXI_RREADY
	);

    // AXI4LITE signals
    reg [C_S_AXI_ADDR_WIDTH-1 : 0] 	axi_awaddr;
    reg  	axi_awready;
    reg  	axi_wready;
    reg [1 : 0] 	axi_bresp;
    reg  	axi_bvalid;
    reg [C_S_AXI_ADDR_WIDTH-1 : 0] 	axi_araddr;
    reg  	axi_arready;
    reg [C_S_AXI_DATA_WIDTH-1 : 0] 	axi_rdata;
    reg [1 : 0] 	axi_rresp;
    reg  	axi_rvalid;
    
    // Example-specific design signals
    // local parameter for addressing 32 bit / 64 bit C_S_AXI_DATA_WIDTH
    // ADDR_LSB is used for addressing 32/64 bit registers/memories
    // ADDR_LSB = 2 for 32 bits (n downto 2)
    // ADDR_LSB = 3 for 64 bits (n downto 3)
    localparam integer ADDR_LSB = (C_S_AXI_DATA_WIDTH/32) + 1;
    localparam integer OPT_MEM_ADDR_BITS = 4;
    //----------------------------------------------
    //-- Signals for user logic register space example
    //------------------------------------------------
    //-- Number of Slave Registers 4
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg0;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg1;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg2;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg3;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg4;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg5;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg6;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg7;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg8;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg9;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg10;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg11;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg12;
    //reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg13;
    //reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg14;
    //reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg15;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg16;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg17;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg18;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg19;
    /*reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg20;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg21;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg22;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg23;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg24;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg25;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg26;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg27;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg28;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg29;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg30;
    reg [C_S_AXI_DATA_WIDTH-1:0]	slv_reg31;	*/
    
    wire	 slv_reg_rden;
    wire	 slv_reg_wren;
    reg [C_S_AXI_DATA_WIDTH-1:0]	 reg_data_out;
    integer	 byte_index;
    //<alihgh -Add
    reg alihgh_slv_reg_rden_tmp;
    //alihgh>
    reg	 aw_en;
    
    reg [15:0] alihgh_done_reg = 16'd0;
    reg [15:0] alihgh_ready_reg = 16'd0;
    
    reg [31:0] alihgh_Rx1_L1_power_reg;
    reg [31:0] alihgh_Rx1_L2_power_reg;
    reg [31:0] alihgh_Rx1_L3_power_reg;
    reg [31:0] alihgh_Rx1_L4_power_reg;
    /*reg [31:0] alihgh_Rx2_L1_power_reg;
    reg [31:0] alihgh_Rx2_L2_power_reg;
    reg [31:0] alihgh_Rx2_L3_power_reg;
    reg [31:0] alihgh_Rx2_L4_power_reg;
    reg [31:0] alihgh_Rx3_L1_power_reg;
    reg [31:0] alihgh_Rx3_L2_power_reg;
    reg [31:0] alihgh_Rx3_L3_power_reg;
    reg [31:0] alihgh_Rx3_L4_power_reg;
    reg [31:0] alihgh_Rx4_L1_power_reg;
    reg [31:0] alihgh_Rx4_L2_power_reg;
    reg [31:0] alihgh_Rx4_L3_power_reg;
    reg [31:0] alihgh_Rx4_L4_power_reg;*/
	// I/O Connections assignments

	assign S_AXI_AWREADY	= axi_awready;
	assign S_AXI_WREADY	= axi_wready;
	assign S_AXI_BRESP	= axi_bresp;
	assign S_AXI_BVALID	= axi_bvalid;
	assign S_AXI_ARREADY	= axi_arready;
	assign S_AXI_RDATA	= axi_rdata;
	assign S_AXI_RRESP	= axi_rresp;
	assign S_AXI_RVALID	= axi_rvalid;

	// Implement axi_awready generation
	// axi_awready is asserted for one S_AXI_ACLK clock cycle when both
	// S_AXI_AWVALID and S_AXI_WVALID are asserted. axi_awready is
	// de-asserted when reset is low.

	always @( posedge S_AXI_ACLK )
	begin
	  if ( S_AXI_ARESETN == 1'b0 )
	    begin
	      axi_awready <= 1'b0;
	      aw_en <= 1'b1;
	    end 
	  else
	    begin    
	      if (~axi_awready && S_AXI_AWVALID && S_AXI_WVALID && aw_en)
	        begin
	          // slave is ready to accept write address when 
	          // there is a valid write address and write data
	          // on the write address and data bus. This design 
	          // expects no outstanding transactions. 
	          axi_awready <= 1'b1;
	          aw_en <= 1'b0;
	        end
	        else if (S_AXI_BREADY && axi_bvalid)
	            begin
	              aw_en <= 1'b1;
	              axi_awready <= 1'b0;
	            end
	      else           
	        begin
	          axi_awready <= 1'b0;
	        end
	    end 
	end       

	// Implement axi_awaddr latching
	// This process is used to latch the address when both 
	// S_AXI_AWVALID and S_AXI_WVALID are valid. 

	always @( posedge S_AXI_ACLK )
	begin
	  if ( S_AXI_ARESETN == 1'b0 )
	    begin
	      axi_awaddr <= 0;
	    end 
	  else
	    begin    
	      if (~axi_awready && S_AXI_AWVALID && S_AXI_WVALID && aw_en)
	        begin
	          // Write Address latching 
	          axi_awaddr <= S_AXI_AWADDR;
	        end
	    end 
	end       

	// Implement axi_wready generation
	// axi_wready is asserted for one S_AXI_ACLK clock cycle when both
	// S_AXI_AWVALID and S_AXI_WVALID are asserted. axi_wready is 
	// de-asserted when reset is low. 

	always @( posedge S_AXI_ACLK )
	begin
	  if ( S_AXI_ARESETN == 1'b0 )
	    begin
	      axi_wready <= 1'b0;
	    end 
	  else
	    begin    
	      if (~axi_wready && S_AXI_WVALID && S_AXI_AWVALID && aw_en )
	        begin
	          // slave is ready to accept write data when 
	          // there is a valid write address and write data
	          // on the write address and data bus. This design 
	          // expects no outstanding transactions. 
	          axi_wready <= 1'b1;
	        end
	      else
	        begin
	          axi_wready <= 1'b0;
	        end
	    end 
	end       

	// Implement memory mapped register select and write logic generation
	// The write data is accepted and written to memory mapped registers when
	// axi_awready, S_AXI_WVALID, axi_wready and S_AXI_WVALID are asserted. Write strobes are used to
	// select byte enables of slave registers while writing.
	// These registers are cleared when reset (active low) is applied.
	// Slave register write enable is asserted when valid address and data are available
	// and the slave is ready to accept the write address and write data.
	assign slv_reg_wren = axi_wready && S_AXI_WVALID && axi_awready && S_AXI_AWVALID;

	always @( posedge S_AXI_ACLK )
	begin
	  //<alihgh -Modify
	   //clear start after write
	  slv_reg3[1:0] <= 2'b00;
	  if(alihgh_ready != 16'd0)
	       slv_reg9[15:0] <= ((~alihgh_ready) & slv_reg9[15:0]);
	  //alihgh>
	  if ( S_AXI_ARESETN == 1'b0 )
	    begin
            slv_reg0  <= 0; slv_reg1  <= 0; slv_reg2  <= 0; slv_reg3  <= 0;
            slv_reg4  <= 0; slv_reg5  <= 0; slv_reg6  <= 0; slv_reg7  <= 0;
            slv_reg8  <= 0; slv_reg9  <= 0; slv_reg10 <= 0; slv_reg11 <= 0;
            slv_reg12 <= 0;
	    end 
	  else begin
	    if (slv_reg_wren)
	      begin
	        case (axi_awaddr[ADDR_LSB+OPT_MEM_ADDR_BITS:ADDR_LSB])
                5'd0 : slv_reg0  <= S_AXI_WDATA;
                5'd1 : slv_reg1  <= S_AXI_WDATA;
                5'd2 : slv_reg2  <= S_AXI_WDATA;
                5'd3 : slv_reg3  <= S_AXI_WDATA; 
                5'd4 : slv_reg4  <= S_AXI_WDATA;
                5'd5 : slv_reg5  <= S_AXI_WDATA;
                5'd6 : slv_reg6  <= S_AXI_WDATA;
                5'd7 : slv_reg7  <= S_AXI_WDATA; 
                5'd8 : slv_reg8  <= S_AXI_WDATA;
                5'd9 : slv_reg9  <= S_AXI_WDATA;
                5'd10: slv_reg10 <= S_AXI_WDATA;
                5'd11: slv_reg11 <= S_AXI_WDATA; 
                5'd12: slv_reg12 <= S_AXI_WDATA;
	          default : begin
	                      slv_reg0 <= slv_reg0;
	                      slv_reg1 <= slv_reg1;
	                      slv_reg2 <= slv_reg2;
	                      slv_reg3 <= slv_reg3;
	                    end
	        endcase
	      end
	  end
	end    

	// Implement write response logic generation
	// The write response and response valid signals are asserted by the slave 
	// when axi_wready, S_AXI_WVALID, axi_wready and S_AXI_WVALID are asserted.  
	// This marks the acceptance of address and indicates the status of 
	// write transaction.

	always @( posedge S_AXI_ACLK )
	begin
	  if ( S_AXI_ARESETN == 1'b0 )
	    begin
	      axi_bvalid  <= 0;
	      axi_bresp   <= 2'b0;
	    end 
	  else
	    begin    
	      if (axi_awready && S_AXI_AWVALID && ~axi_bvalid && axi_wready && S_AXI_WVALID)
	        begin
	          // indicates a valid write response is available
	          axi_bvalid <= 1'b1;
	          axi_bresp  <= 2'b0; // 'OKAY' response 
	        end                   // work error responses in future
	      else
	        begin
	          if (S_AXI_BREADY && axi_bvalid) 
	            //check if bready is asserted while bvalid is high) 
	            //(there is a possibility that bready is always asserted high)   
	            begin
	              axi_bvalid <= 1'b0; 
	            end  
	        end
	    end
	end   

	// Implement axi_arready generation
	// axi_arready is asserted for one S_AXI_ACLK clock cycle when
	// S_AXI_ARVALID is asserted. axi_awready is 
	// de-asserted when reset (active low) is asserted. 
	// The read address is also latched when S_AXI_ARVALID is 
	// asserted. axi_araddr is reset to zero on reset assertion.

	always @( posedge S_AXI_ACLK )
	begin
	  if ( S_AXI_ARESETN == 1'b0 )
	    begin
	      axi_arready <= 1'b0;
	      axi_araddr  <= 32'b0;
	    end 
	  else
	    begin    
	      if (~axi_arready && S_AXI_ARVALID)
	        begin
	          // indicates that the slave has acceped the valid read address
	          axi_arready <= 1'b1;
	          // Read address latching
	          axi_araddr  <= S_AXI_ARADDR;
	        end
	      else
	        begin
	          axi_arready <= 1'b0;
	        end
	    end 
	end       

	// Implement axi_arvalid generation
	// axi_rvalid is asserted for one S_AXI_ACLK clock cycle when both 
	// S_AXI_ARVALID and axi_arready are asserted. The slave registers 
	// data are available on the axi_rdata bus at this instance. The 
	// assertion of axi_rvalid marks the validity of read data on the 
	// bus and axi_rresp indicates the status of read transaction.axi_rvalid 
	// is deasserted on reset (active low). axi_rresp and axi_rdata are 
	// cleared to zero on reset (active low).  
	always @( posedge S_AXI_ACLK )
	begin
	  if ( S_AXI_ARESETN == 1'b0 )
	    begin
	      axi_rvalid <= 0;
	      axi_rresp  <= 0;
	    end 
	  else
	    begin    
	      if (axi_arready && S_AXI_ARVALID && ~axi_rvalid)
	        begin
	          // Valid read data is available at the read data bus
	          axi_rvalid <= 1'b1;
	          axi_rresp  <= 2'b0; // 'OKAY' response
	        end   
	      else if (axi_rvalid && S_AXI_RREADY)
	        begin
	          // Read data is accepted by the master
	          axi_rvalid <= 1'b0;
	        end                
	    end
	end    

	// Implement memory mapped register select and read logic generation
	// Slave register read enable is asserted when valid address is available
	// and the slave is ready to accept the read address.
	assign slv_reg_rden = axi_arready & S_AXI_ARVALID & ~axi_rvalid;
	always @(*)
	begin
	      // Address decoding for reading registers
		  //<alihgh -Modify	      		  
	      case ( axi_araddr[ADDR_LSB+OPT_MEM_ADDR_BITS:ADDR_LSB] )
	        5'd0   : reg_data_out <= slv_reg0; //alihgh_MIn1
	        5'd1   : reg_data_out <= slv_reg1; //alihgh_MIn2
	        5'd2   : reg_data_out <= slv_reg2; //alihgh_MOut
	        //2'h3   : reg_data_out <= slv_reg3;
	        5'd3 : reg_data_out <= {slv_reg3[C_S_AXI_DATA_WIDTH-1:4],alihgh_MIn_Done, alihgh_MOut_Done, 2'b00};
            5'd4 : reg_data_out <= slv_reg4 ;
            5'd5 : reg_data_out <= slv_reg5 ;
            5'd6 : reg_data_out <= slv_reg6 ;
            5'd7 : reg_data_out <= slv_reg7 ; 
            5'd8 : reg_data_out <= slv_reg8 ;
            5'd9 : reg_data_out <= slv_reg9 ;
            5'd10: reg_data_out <= slv_reg10;
            5'd11: reg_data_out <= slv_reg11;
            5'd12: reg_data_out <= slv_reg12;
            5'd13: reg_data_out <= {16'd0, alihgh_idle};
            5'd14: reg_data_out <= {16'd0, (alihgh_ready_reg | alihgh_ready)};
            5'd15: reg_data_out <= {16'd0, (alihgh_done_reg | alihgh_done)}; 
            5'd16: reg_data_out <= slv_reg16;
            5'd17: reg_data_out <= slv_reg17;
            5'd18: reg_data_out <= slv_reg18;
            5'd19: reg_data_out <= slv_reg19; 
            /*5'd20: reg_data_out <= slv_reg20;
            5'd21: reg_data_out <= slv_reg21;
            5'd22: reg_data_out <= slv_reg22;
            5'd23: reg_data_out <= slv_reg23; 
            5'd24: reg_data_out <= slv_reg24;
            5'd25: reg_data_out <= slv_reg25;
            5'd26: reg_data_out <= slv_reg26;
            5'd27: reg_data_out <= slv_reg27; 
            5'd28: reg_data_out <= slv_reg28;
            5'd29: reg_data_out <= slv_reg29;
            5'd30: reg_data_out <= slv_reg30;
            5'd31: reg_data_out <= slv_reg31; */
	        default : reg_data_out <= 0;
	      endcase
		  //alihgh>
	end

	// Output register or memory read data
	always @( posedge S_AXI_ACLK )
	begin
        alihgh_done_reg <= (alihgh_done_reg | alihgh_done);
        alihgh_ready_reg <= (alihgh_ready_reg | alihgh_ready);
	  if ( S_AXI_ARESETN == 1'b0 )
	    begin
	      axi_rdata  <= 0;
	    end 
	  else
	    begin    
	      // When there is a valid read address (S_AXI_ARVALID) with 
	      // acceptance of read address by the slave (axi_arready), 
	      // output the read dada 
	      if (slv_reg_rden)
	        begin
	          axi_rdata <= reg_data_out;     // register read data
	          if(axi_araddr[ADDR_LSB+OPT_MEM_ADDR_BITS:ADDR_LSB] == 5'd15)
                alihgh_done_reg <= 16'd0;
	          else if(axi_araddr[ADDR_LSB+OPT_MEM_ADDR_BITS:ADDR_LSB] == 5'd14)
                alihgh_ready_reg <= 16'd0;	          
	        end   
	    end
	end    

	// Add user logic here
	//<alihgh -Add
	assign alihgh_MIn_Start = slv_reg3[0];
	assign alihgh_MOut_Start = slv_reg3[1];
	assign alihgh_MIn_Size  = slv_reg0;			
	assign alihgh_MOut_Size  = slv_reg1;			
	assign alihgh_Mem_Select  = slv_reg2;	
	
    assign alihgh_lay     = slv_reg7; 	
    assign alihgh_n       = slv_reg8; 	
    assign alihgh_start   = slv_reg9;

    always @(posedge S_AXI_ACLK )
    begin
        if(alihgh_power_vld[0] == 1'b1) slv_reg16 <= alihgh_Rx1_L1_power;
        if(alihgh_power_vld[1] == 1'b1) slv_reg17 <= alihgh_Rx1_L2_power;
        if(alihgh_power_vld[2] == 1'b1) slv_reg18 <= alihgh_Rx1_L3_power;
        if(alihgh_power_vld[3] == 1'b1) slv_reg19 <= alihgh_Rx1_L4_power;
        /*if(alihgh_power_vld[4] == 1'b1) slv_reg20 <= alihgh_Rx2_L1_power;
        if(alihgh_power_vld[5] == 1'b1) slv_reg21 <= alihgh_Rx2_L2_power;
        if(alihgh_power_vld[6] == 1'b1) slv_reg22 <= alihgh_Rx2_L3_power;
        if(alihgh_power_vld[7] == 1'b1) slv_reg23 <= alihgh_Rx2_L4_power;
        if(alihgh_power_vld[8] == 1'b1) slv_reg24 <= alihgh_Rx3_L1_power;
        if(alihgh_power_vld[9] == 1'b1) slv_reg25 <= alihgh_Rx3_L2_power;
        if(alihgh_power_vld[10] == 1'b1)slv_reg26 <= alihgh_Rx3_L3_power;
        if(alihgh_power_vld[11] == 1'b1)slv_reg27 <= alihgh_Rx3_L4_power;
        if(alihgh_power_vld[12] == 1'b1)slv_reg28 <= alihgh_Rx4_L1_power;
        if(alihgh_power_vld[13] == 1'b1)slv_reg29 <= alihgh_Rx4_L2_power;
        if(alihgh_power_vld[14] == 1'b1)slv_reg30 <= alihgh_Rx4_L3_power;
        if(alihgh_power_vld[15] == 1'b1)slv_reg31 <= alihgh_Rx4_L4_power;*/
    end	
	//alihgh>
	// User logic ends

	endmodule
