`timescale 1ns / 1ps

module MatchFilter(
	input        pl_clk,
	input        pl_rstn,
	
	input [31:0] In_Data,
    input        In_En,
    input [31:0] In_Addr,
    input [31:0] Out_Addr,
    output[31:0] Out_Data,
    input [31:0] Select,

    input [15:0] start,
    output[15:0] done,
    output[15:0] idle,
    output[15:0] ready,
    input [31:0] n,
    input [31:0] lay,
    output[15:0] power_vld,
    output[31:0] Rx1_L1_power,	
    output [31:0] Rx1_L2_power,	
    output [31:0] Rx1_L3_power,
    output [31:0] Rx1_L4_power/*,	
    output [31:0] Rx2_L1_power,	
    output [31:0] Rx2_L2_power,	
    output [31:0] Rx2_L3_power,	
    output [31:0] Rx2_L4_power,	
    output [31:0] Rx3_L1_power,	
    output [31:0] Rx3_L2_power,	
    output [31:0] Rx3_L3_power,	
    output [31:0] Rx3_L4_power,	
    output [31:0] Rx4_L1_power,	
    output [31:0] Rx4_L2_power,	
    output [31:0] Rx4_L3_power,	
    output [31:0] Rx4_L4_power*/
    );
    
wire [31:0] in_Rx1_L1_address0 ;
wire [31:0] in_Rx1_L1_q0       ;
wire [31:0] rs_Rx1_L1_address0 ;
wire [31:0] rs_Rx1_L1_q0       ;
wire 		out_Rx1_L1_we0     ;
wire [31:0] out_Rx1_L1_address0;
wire [31:0] out_Rx1_L1_d0      ; 
/*  
wire [31:0] in_Rx1_L2_address0 ;
wire [31:0] in_Rx1_L2_q0       ;
wire [31:0] rs_Rx1_L2_address0 ;
wire [31:0] rs_Rx1_L2_q0       ;
wire 		out_Rx1_L2_we0     ;
wire [31:0] out_Rx1_L2_address0;
wire [31:0] out_Rx1_L2_d0      ;   
 wire [31:0] in_Rx1_L3_address0 ;
wire [31:0] in_Rx1_L3_q0       ;
wire [31:0] rs_Rx1_L3_address0 ;
wire [31:0] rs_Rx1_L3_q0       ;
wire 		out_Rx1_L3_we0     ;
wire [31:0] out_Rx1_L3_address0;
wire [31:0] out_Rx1_L3_d0      ;   
wire [31:0] in_Rx1_L4_address0 ;
wire [31:0] in_Rx1_L4_q0       ;
wire [31:0] rs_Rx1_L4_address0 ;
wire [31:0] rs_Rx1_L4_q0       ;
wire 		out_Rx1_L4_we0     ;
wire [31:0] out_Rx1_L4_address0;
wire [31:0] out_Rx1_L4_d0      ;   
wire [31:0] in_Rx2_L1_address0 ;
wire [31:0] in_Rx2_L1_q0       ;
wire [31:0] rs_Rx2_L1_address0 ;
wire [31:0] rs_Rx2_L1_q0       ;
wire 		out_Rx2_L1_we0     ;
wire [31:0] out_Rx2_L1_address0;
wire [31:0] out_Rx2_L1_d0      ;   
wire [31:0] in_Rx2_L2_address0 ;
wire [31:0] in_Rx2_L2_q0       ;
wire [31:0] rs_Rx2_L2_address0 ;
wire [31:0] rs_Rx2_L2_q0       ;
wire 		out_Rx2_L2_we0     ;
wire [31:0] out_Rx2_L2_address0;
wire [31:0] out_Rx2_L2_d0      ;   
 wire [31:0] in_Rx2_L3_address0 ;
wire [31:0] in_Rx2_L3_q0       ;
wire [31:0] rs_Rx2_L3_address0 ;
wire [31:0] rs_Rx2_L3_q0       ;
wire 		out_Rx2_L3_we0     ;
wire [31:0] out_Rx2_L3_address0;
wire [31:0] out_Rx2_L3_d0      ;   
wire [31:0] in_Rx2_L4_address0 ;
wire [31:0] in_Rx2_L4_q0       ;
wire [31:0] rs_Rx2_L4_address0 ;
wire [31:0] rs_Rx2_L4_q0       ;
wire 		out_Rx2_L4_we0     ;
wire [31:0] out_Rx2_L4_address0;
wire [31:0] out_Rx2_L4_d0      ; 
wire [31:0] in_Rx3_L1_address0 ;
wire [31:0] in_Rx3_L1_q0       ;
wire [31:0] rs_Rx3_L1_address0 ;
wire [31:0] rs_Rx3_L1_q0       ;
wire 		out_Rx3_L1_we0     ;
wire [31:0] out_Rx3_L1_address0;
wire [31:0] out_Rx3_L1_d0      ;   
wire [31:0] in_Rx3_L2_address0 ;
wire [31:0] in_Rx3_L2_q0       ;
wire [31:0] rs_Rx3_L2_address0 ;
wire [31:0] rs_Rx3_L2_q0       ;
wire 		out_Rx3_L2_we0     ;
wire [31:0] out_Rx3_L2_address0;
wire [31:0] out_Rx3_L2_d0      ;   
wire [31:0] in_Rx3_L3_address0 ;
wire [31:0] in_Rx3_L3_q0       ;
wire [31:0] rs_Rx3_L3_address0 ;
wire [31:0] rs_Rx3_L3_q0       ;
wire 		out_Rx3_L3_we0     ;
wire [31:0] out_Rx3_L3_address0;
wire [31:0] out_Rx3_L3_d0      ;   
wire [31:0] in_Rx3_L4_address0 ;
wire [31:0] in_Rx3_L4_q0       ;
wire [31:0] rs_Rx3_L4_address0 ;
wire [31:0] rs_Rx3_L4_q0       ;
wire 		out_Rx3_L4_we0     ;
wire [31:0] out_Rx3_L4_address0;
wire [31:0] out_Rx3_L4_d0      ;   
wire [31:0] in_Rx4_L1_address0 ;
wire [31:0] in_Rx4_L1_q0       ;
wire [31:0] rs_Rx4_L1_address0 ;
wire [31:0] rs_Rx4_L1_q0       ;
wire 		out_Rx4_L1_we0     ;
wire [31:0] out_Rx4_L1_address0;
wire [31:0] out_Rx4_L1_d0      ;   
wire [31:0] in_Rx4_L2_address0 ;
wire [31:0] in_Rx4_L2_q0       ;
wire [31:0] rs_Rx4_L2_address0 ;
wire [31:0] rs_Rx4_L2_q0       ;
wire 		out_Rx4_L2_we0     ;
wire [31:0] out_Rx4_L2_address0;
wire [31:0] out_Rx4_L2_d0      ;   
 wire [31:0] in_Rx4_L3_address0 ;
wire [31:0] in_Rx4_L3_q0       ;
wire [31:0] rs_Rx4_L3_address0 ;
wire [31:0] rs_Rx4_L3_q0       ;
wire 		out_Rx4_L3_we0     ;
wire [31:0] out_Rx4_L3_address0;
wire [31:0] out_Rx4_L3_d0      ;   
wire [31:0] in_Rx4_L4_address0 ;
wire [31:0] in_Rx4_L4_q0       ;
wire [31:0] rs_Rx4_L4_address0 ;
wire [31:0] rs_Rx4_L4_q0       ;
wire 		out_Rx4_L4_we0     ;
wire [31:0] out_Rx4_L4_address0;
wire [31:0] out_Rx4_L4_d0      ; 
*/
wire [31:0] out_Rx1_L1_data;
/*
wire [31:0] out_Rx1_L2_data;
wire [31:0] out_Rx1_L3_data;
wire [31:0] out_Rx1_L4_data;
wire [31:0] out_Rx2_L1_data;
wire [31:0] out_Rx2_L2_data;
wire [31:0] out_Rx2_L3_data;
wire [31:0] out_Rx2_L4_data;
wire [31:0] out_Rx3_L1_data;
wire [31:0] out_Rx3_L2_data;
wire [31:0] out_Rx3_L3_data;
wire [31:0] out_Rx3_L4_data;
wire [31:0] out_Rx4_L1_data;
wire [31:0] out_Rx4_L2_data;
wire [31:0] out_Rx4_L3_data;
wire [31:0] out_Rx4_L4_data;
*/

assign Out_Data = (Select ==32'd32)? out_Rx1_L1_data:0;/*(
			(Select ==32'd33)?  out_Rx1_L2_data:(
			(Select ==32'd34)?  out_Rx1_L3_data:(
			(Select ==32'd35)?  out_Rx1_L4_data:(
			(Select ==32'd36)?  out_Rx2_L1_data:(
			(Select ==32'd37)?  out_Rx2_L2_data:(
			(Select ==32'd38)?  out_Rx2_L3_data:(
			(Select ==32'd39)?  out_Rx2_L4_data:(
			(Select ==32'd40)?  out_Rx3_L1_data:(
			(Select ==32'd41)?  out_Rx3_L2_data:(
			(Select ==32'd42)?  out_Rx3_L3_data:(
			(Select ==32'd43)?  out_Rx3_L4_data:(
			(Select ==32'd44)?  out_Rx4_L1_data:(
			(Select ==32'd45)?  out_Rx4_L2_data:(
			(Select ==32'd46)?  out_Rx4_L3_data:(
			(Select ==32'd47)?  out_Rx4_L4_data:32'd0)))))))))))))));*/

MatchFilter_simpDual_19200_32bits Rx1_L1_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd0)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx1_L1_address0),
    .doutb  (in_Rx1_L1_q0)
  );

MatchFilter_simpDual_19200_32bits Rx1_L1_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd16)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx1_L1_address0),
    .doutb  (rs_Rx1_L1_q0)
  );  

MatchFilter_simpDual_19200_32bits Rx1_L1_out(
    .clka   (pl_clk),
    .wea    (out_Rx1_L1_we0),
    .addra  (out_Rx1_L1_address0),
    .dina   (out_Rx1_L1_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx1_L1_data)
  );
  
mf_0 mf_Rx1_L1(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[0]),
    .ap_done       (done[0]),
    .ap_idle       (idle[0]),
    .ap_ready      (ready[0]),
    .n             (n),
    .lay             (lay),
    .power_0_ap_vld  (power_vld[0]),
    .power_1_ap_vld  (power_vld[1]),
    .power_2_ap_vld  (power_vld[2]),
    .power_3_ap_vld  (power_vld[3]),
    .power_0         (Rx1_L1_power    ),
    .power_1         (Rx1_L2_power    ),
    .power_2         (Rx1_L3_power    ),
    .power_3         (Rx1_L4_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx1_L1_address0),
	.in_r_q0	    (in_Rx1_L1_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx1_L1_address0),
	.rs_q0          (rs_Rx1_L1_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx1_L1_we0),
	.out_r_address0 (out_Rx1_L1_address0),
	.out_r_d0       (out_Rx1_L1_d0)
);

assign done[15:1] =15'd0;
assign idle[15:1] =15'd0;
assign ready[15:1] =15'd0;

/*
blk_mem_simpDual_1200_32bits Rx1_L2_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd1)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx1_L2_address0),
    .doutb  (in_Rx1_L2_q0)
  );
blk_mem_simpDual_1200_32bits Rx1_L2_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd17)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx1_L2_address0),
    .doutb  (rs_Rx1_L2_q0)
  );    
blk_mem_simpDual_1200_32bits Rx1_L2_out(
    .clka   (pl_clk),
    .wea    (out_Rx1_L2_we0),
    .addra  (out_Rx1_L2_address0),
    .dina   (out_Rx1_L2_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx1_L2_data)
  );         
mf_0 mf_Rx1_L2(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[1]),
    .ap_done       (done[1]),
    .ap_idle       (idle[1]),
    .ap_ready      (ready[1]),
    .n             (n),
    .power_ap_vld  (power_vld[1]),
    .power         (Rx1_L2_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx1_L2_address0),
	.in_r_q0	    (in_Rx1_L2_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx1_L2_address0),
	.rs_q0          (rs_Rx1_L2_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx1_L2_we0),
	.out_r_address0 (out_Rx1_L2_address0),
	.out_r_d0       (out_Rx1_L2_d0)
);   

blk_mem_simpDual_1200_32bits Rx1_L3_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd2)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx1_L3_address0),
    .doutb  (in_Rx1_L3_q0)
  );
blk_mem_simpDual_1200_32bits Rx1_L3_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd18)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx1_L3_address0),
    .doutb  (rs_Rx1_L3_q0)
  );    
blk_mem_simpDual_1200_32bits Rx1_L3_out(
    .clka   (pl_clk),
    .wea    (out_Rx1_L3_we0),
    .addra  (out_Rx1_L3_address0),
    .dina   (out_Rx1_L3_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx1_L3_data)
  );
  
mf_0 mf_Rx1_L3(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[2]),
    .ap_done       (done[2]),
    .ap_idle       (idle[2]),
    .ap_ready      (ready[2]),
    .n             (n),
    .power_ap_vld  (power_vld[2]),
    .power         (Rx1_L3_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx1_L3_address0),
	.in_r_q0	    (in_Rx1_L3_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx1_L3_address0),
	.rs_q0          (rs_Rx1_L3_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx1_L3_we0),
	.out_r_address0 (out_Rx1_L3_address0),
	.out_r_d0       (out_Rx1_L3_d0)
);


blk_mem_simpDual_1200_32bits Rx1_L4_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd3)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx1_L4_address0),
    .doutb  (in_Rx1_L4_q0)
  );
blk_mem_simpDual_1200_32bits Rx1_L4_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd19)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx1_L4_address0),
    .doutb  (rs_Rx1_L4_q0)
  );    
blk_mem_simpDual_1200_32bits Rx1_L4_out(
    .clka   (pl_clk),
    .wea    (out_Rx1_L4_we0),
    .addra  (out_Rx1_L4_address0),
    .dina   (out_Rx1_L4_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx1_L4_data)
  );         
mf_0 mf_Rx1_L4(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[3]),
    .ap_done       (done[3]),
    .ap_idle       (idle[3]),
    .ap_ready      (ready[3]),
    .n             (n),
    .power_ap_vld  (power_vld[3]),
    .power         (Rx1_L4_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx1_L4_address0),
	.in_r_q0	    (in_Rx1_L4_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx1_L4_address0),
	.rs_q0          (rs_Rx1_L4_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx1_L4_we0),
	.out_r_address0 (out_Rx1_L4_address0),
	.out_r_d0       (out_Rx1_L4_d0)
);  

blk_mem_simpDual_1200_32bits Rx2_L1_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd4)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx2_L1_address0),
    .doutb  (in_Rx2_L1_q0)
  );
blk_mem_simpDual_1200_32bits Rx2_L1_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd20)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx2_L1_address0),
    .doutb  (rs_Rx2_L1_q0)
  );    
blk_mem_simpDual_1200_32bits Rx2_L1_out(
    .clka   (pl_clk),
    .wea    (out_Rx2_L1_we0),
    .addra  (out_Rx2_L1_address0),
    .dina   (out_Rx2_L1_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx2_L1_data)
  );
  
mf_0 mf_Rx2_L1(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[4]),
    .ap_done       (done[4]),
    .ap_idle       (idle[4]),
    .ap_ready      (ready[4]),
    .n             (n),
    .power_ap_vld  (power_vld[4]),
    .power         (Rx2_L1_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx2_L1_address0),
	.in_r_q0	    (in_Rx2_L1_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx2_L1_address0),
	.rs_q0          (rs_Rx2_L1_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx2_L1_we0),
	.out_r_address0 (out_Rx2_L1_address0),
	.out_r_d0       (out_Rx2_L1_d0)
);


blk_mem_simpDual_1200_32bits Rx2_L2_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd5)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx2_L2_address0),
    .doutb  (in_Rx2_L2_q0)
  );
blk_mem_simpDual_1200_32bits Rx2_L2_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd21)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx2_L2_address0),
    .doutb  (rs_Rx2_L2_q0)
  );    
blk_mem_simpDual_1200_32bits Rx2_L2_out(
    .clka   (pl_clk),
    .wea    (out_Rx2_L2_we0),
    .addra  (out_Rx2_L2_address0),
    .dina   (out_Rx2_L2_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx2_L2_data)
  );         
mf_0 mf_Rx2_L2(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[5]),
    .ap_done       (done[5]),
    .ap_idle       (idle[5]),
    .ap_ready      (ready[5]),
    .n             (n),
    .power_ap_vld  (power_vld[5]),
    .power         (Rx2_L2_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx2_L2_address0),
	.in_r_q0	    (in_Rx2_L2_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx2_L2_address0),
	.rs_q0          (rs_Rx2_L2_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx2_L2_we0),
	.out_r_address0 (out_Rx2_L2_address0),
	.out_r_d0       (out_Rx2_L2_d0)
);   

blk_mem_simpDual_1200_32bits Rx2_L3_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd6)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx2_L3_address0),
    .doutb  (in_Rx2_L3_q0)
  );
blk_mem_simpDual_1200_32bits Rx2_L3_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd22)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx2_L3_address0),
    .doutb  (rs_Rx2_L3_q0)
  );    
blk_mem_simpDual_1200_32bits Rx2_L3_out(
    .clka   (pl_clk),
    .wea    (out_Rx2_L3_we0),
    .addra  (out_Rx2_L3_address0),
    .dina   (out_Rx2_L3_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx2_L3_data)
  );
  
mf_0 mf_Rx2_L3(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[6]),
    .ap_done       (done[6]),
    .ap_idle       (idle[6]),
    .ap_ready      (ready[6]),
    .n             (n),
    .power_ap_vld  (power_vld[6]),
    .power         (Rx2_L3_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx2_L3_address0),
	.in_r_q0	    (in_Rx2_L3_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx2_L3_address0),
	.rs_q0          (rs_Rx2_L3_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx2_L3_we0),
	.out_r_address0 (out_Rx2_L3_address0),
	.out_r_d0       (out_Rx2_L3_d0)
);


blk_mem_simpDual_1200_32bits Rx2_L4_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd7)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx2_L4_address0),
    .doutb  (in_Rx2_L4_q0)
  );
blk_mem_simpDual_1200_32bits Rx2_L4_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd23)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx2_L4_address0),
    .doutb  (rs_Rx2_L4_q0)
  );    
blk_mem_simpDual_1200_32bits Rx2_L4_out(
    .clka   (pl_clk),
    .wea    (out_Rx2_L4_we0),
    .addra  (out_Rx2_L4_address0),
    .dina   (out_Rx2_L4_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx2_L4_data)
  );         
mf_0 mf_Rx2_L4(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[7]),
    .ap_done       (done[7]),
    .ap_idle       (idle[7]),
    .ap_ready      (ready[7]),
    .n             (n),
    .power_ap_vld  (power_vld[7]),
    .power         (Rx2_L4_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx2_L4_address0),
	.in_r_q0	    (in_Rx2_L4_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx2_L4_address0),
	.rs_q0          (rs_Rx2_L4_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx2_L4_we0),
	.out_r_address0 (out_Rx2_L4_address0),
	.out_r_d0       (out_Rx2_L4_d0)
);


blk_mem_simpDual_1200_32bits Rx3_L1_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd8)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx3_L1_address0),
    .doutb  (in_Rx3_L1_q0)
  );
blk_mem_simpDual_1200_32bits Rx3_L1_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd24)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx3_L1_address0),
    .doutb  (rs_Rx3_L1_q0)
  );    
blk_mem_simpDual_1200_32bits Rx3_L1_out(
    .clka   (pl_clk),
    .wea    (out_Rx3_L1_we0),
    .addra  (out_Rx3_L1_address0),
    .dina   (out_Rx3_L1_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx3_L1_data)
  );
  
mf_0 mf_Rx3_L1(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[8]),
    .ap_done       (done[8]),
    .ap_idle       (idle[8]),
    .ap_ready      (ready[8]),
    .n             (n),
    .power_ap_vld  (power_vld[8]),
    .power         (Rx3_L1_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx3_L1_address0),
	.in_r_q0	    (in_Rx3_L1_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx3_L1_address0),
	.rs_q0          (rs_Rx3_L1_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx3_L1_we0),
	.out_r_address0 (out_Rx3_L1_address0),
	.out_r_d0       (out_Rx3_L1_d0)
);


blk_mem_simpDual_1200_32bits Rx3_L2_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd9)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx3_L2_address0),
    .doutb  (in_Rx3_L2_q0)
  );
blk_mem_simpDual_1200_32bits Rx3_L2_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd25)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx3_L2_address0),
    .doutb  (rs_Rx3_L2_q0)
  );    
blk_mem_simpDual_1200_32bits Rx3_L2_out(
    .clka   (pl_clk),
    .wea    (out_Rx3_L2_we0),
    .addra  (out_Rx3_L2_address0),
    .dina   (out_Rx3_L2_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx3_L2_data)
  );         
mf_0 mf_Rx3_L2(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[9]),
    .ap_done       (done[9]),
    .ap_idle       (idle[9]),
    .ap_ready      (ready[9]),
    .n             (n),
    .power_ap_vld  (power_vld[9]),
    .power         (Rx3_L2_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx3_L2_address0),
	.in_r_q0	    (in_Rx3_L2_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx3_L2_address0),
	.rs_q0          (rs_Rx3_L2_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx3_L2_we0),
	.out_r_address0 (out_Rx3_L2_address0),
	.out_r_d0       (out_Rx3_L2_d0)
);   

blk_mem_simpDual_1200_32bits Rx3_L3_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd10)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx3_L3_address0),
    .doutb  (in_Rx3_L3_q0)
  );
blk_mem_simpDual_1200_32bits Rx3_L3_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd26)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx3_L3_address0),
    .doutb  (rs_Rx3_L3_q0)
  );    
blk_mem_simpDual_1200_32bits Rx3_L3_out(
    .clka   (pl_clk),
    .wea    (out_Rx3_L3_we0),
    .addra  (out_Rx3_L3_address0),
    .dina   (out_Rx3_L3_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx3_L3_data)
  );
  
mf_0 mf_Rx3_L3(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[10]),
    .ap_done       (done[10]),
    .ap_idle       (idle[10]),
    .ap_ready      (ready[10]),
    .n             (n),
    .power_ap_vld  (power_vld[10]),
    .power         (Rx3_L3_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx3_L3_address0),
	.in_r_q0	    (in_Rx3_L3_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx3_L3_address0),
	.rs_q0          (rs_Rx3_L3_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx3_L3_we0),
	.out_r_address0 (out_Rx3_L3_address0),
	.out_r_d0       (out_Rx3_L3_d0)
);


blk_mem_simpDual_1200_32bits Rx3_L4_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd11)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx3_L4_address0),
    .doutb  (in_Rx3_L4_q0)
  );
blk_mem_simpDual_1200_32bits Rx3_L4_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd27)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx3_L4_address0),
    .doutb  (rs_Rx3_L4_q0)
  );    
blk_mem_simpDual_1200_32bits Rx3_L4_out(
    .clka   (pl_clk),
    .wea    (out_Rx3_L4_we0),
    .addra  (out_Rx3_L4_address0),
    .dina   (out_Rx3_L4_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx3_L4_data)
  );         
mf_0 mf_Rx3_L4(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[11]),
    .ap_done       (done[11]),
    .ap_idle       (idle[11]),
    .ap_ready      (ready[11]),
    .n             (n),
    .power_ap_vld  (power_vld[11]),
    .power         (Rx3_L4_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx3_L4_address0),
	.in_r_q0	    (in_Rx3_L4_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx3_L4_address0),
	.rs_q0          (rs_Rx3_L4_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx3_L4_we0),
	.out_r_address0 (out_Rx3_L4_address0),
	.out_r_d0       (out_Rx3_L4_d0)
);  

blk_mem_simpDual_1200_32bits Rx4_L1_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd12)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx4_L1_address0),
    .doutb  (in_Rx4_L1_q0)
  );
blk_mem_simpDual_1200_32bits Rx4_L1_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd28)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx4_L1_address0),
    .doutb  (rs_Rx4_L1_q0)
  );    
blk_mem_simpDual_1200_32bits Rx4_L1_out(
    .clka   (pl_clk),
    .wea    (out_Rx4_L1_we0),
    .addra  (out_Rx4_L1_address0),
    .dina   (out_Rx4_L1_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx4_L1_data)
  );
  
mf_0 mf_Rx4_L1(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[12]),
    .ap_done       (done[12]),
    .ap_idle       (idle[12]),
    .ap_ready      (ready[12]),
    .n             (n),
    .power_ap_vld  (power_vld[12]),
    .power         (Rx4_L1_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx4_L1_address0),
	.in_r_q0	    (in_Rx4_L1_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx4_L1_address0),
	.rs_q0          (rs_Rx4_L1_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx4_L1_we0),
	.out_r_address0 (out_Rx4_L1_address0),
	.out_r_d0       (out_Rx4_L1_d0)
);


blk_mem_simpDual_1200_32bits Rx4_L2_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd13)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx4_L2_address0),
    .doutb  (in_Rx4_L2_q0)
  );
blk_mem_simpDual_1200_32bits Rx4_L2_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd29)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx4_L2_address0),
    .doutb  (rs_Rx4_L2_q0)
  );    
blk_mem_simpDual_1200_32bits Rx4_L2_out(
    .clka   (pl_clk),
    .wea    (out_Rx4_L2_we0),
    .addra  (out_Rx4_L2_address0),
    .dina   (out_Rx4_L2_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx4_L2_data)
  );         
mf_0 mf_Rx4_L2(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[13]),
    .ap_done       (done[13]),
    .ap_idle       (idle[13]),
    .ap_ready      (ready[13]),
    .n             (n),
    .power_ap_vld  (power_vld[13]),
    .power         (Rx4_L2_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx4_L2_address0),
	.in_r_q0	    (in_Rx4_L2_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx4_L2_address0),
	.rs_q0          (rs_Rx4_L2_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx4_L2_we0),
	.out_r_address0 (out_Rx4_L2_address0),
	.out_r_d0       (out_Rx4_L2_d0)
);   

blk_mem_simpDual_1200_32bits Rx4_L3_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd14)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx4_L3_address0),
    .doutb  (in_Rx4_L3_q0)
  );
blk_mem_simpDual_1200_32bits Rx4_L3_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd30)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx4_L3_address0),
    .doutb  (rs_Rx4_L3_q0)
  );    
blk_mem_simpDual_1200_32bits Rx4_L3_out(
    .clka   (pl_clk),
    .wea    (out_Rx4_L3_we0),
    .addra  (out_Rx4_L3_address0),
    .dina   (out_Rx4_L3_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx4_L3_data)
  );
  
mf_0 mf_Rx4_L3(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[14]),
    .ap_done       (done[14]),
    .ap_idle       (idle[14]),
    .ap_ready      (ready[14]),
    .n             (n),
    .power_ap_vld  (power_vld[14]),
    .power         (Rx4_L3_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx4_L3_address0),
	.in_r_q0	    (in_Rx4_L3_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx4_L3_address0),
	.rs_q0          (rs_Rx4_L3_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx4_L3_we0),
	.out_r_address0 (out_Rx4_L3_address0),
	.out_r_d0       (out_Rx4_L3_d0)
);


blk_mem_simpDual_1200_32bits Rx4_L4_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd15)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx4_L4_address0),
    .doutb  (in_Rx4_L4_q0)
  );
blk_mem_simpDual_1200_32bits Rx4_L4_rs(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd31)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (rs_Rx4_L4_address0),
    .doutb  (rs_Rx4_L4_q0)
  );    
blk_mem_simpDual_1200_32bits Rx4_L4_out(
    .clka   (pl_clk),
    .wea    (out_Rx4_L4_we0),
    .addra  (out_Rx4_L4_address0),
    .dina   (out_Rx4_L4_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx4_L4_data)
  );         
mf_0 mf_Rx4_L4(
	.ap_clk        (pl_clk),
	.ap_rst        (~pl_rstn),
    .ap_start      (start[15]),
    .ap_done       (done[15]),
    .ap_idle       (idle[15]),
    .ap_ready      (ready[15]),
    .n             (n),
    .power_ap_vld  (power_vld[15]),
    .power         (Rx4_L4_power    ),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx4_L4_address0),
	.in_r_q0	    (in_Rx4_L4_q0),
	.rs_ce0         (),
	.rs_address0    (rs_Rx4_L4_address0),
	.rs_q0          (rs_Rx4_L4_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx4_L4_we0),
	.out_r_address0 (out_Rx4_L4_address0),
	.out_r_d0       (out_Rx4_L4_d0)
);
*/ 
endmodule