`timescale 1ns / 1ps

module Interleaving(
	input      pl_clk,
	input      pl_rstn,
	
	input [31:0] In_Data,
    input In_En,
    input [31:0] In_Addr,
    input [31:0] Out_Addr,
    output[31:0] Out_Data,
    input [31:0] Select,

    input   [15:0]      start,
    output  [15:0]      done,
    output  [15:0]      idle,
    output  [15:0]      ready,
    input   [31:0]      n,
    input   [31:0]      lay
    );
    
wire [31:0] in_Rx1_L1_address0 ;
wire [31:0] in_Rx1_L1_q0       ;
wire 		out_Rx1_L1_we0     ;
wire [31:0] out_Rx1_L1_address0;
wire [31:0] out_Rx1_L1_d0      ;
wire [31:0] out_Rx1_L1_data;


assign Out_Data = (Select ==32'd32)? out_Rx1_L1_data:0;

Interleaving_simpDual_19200_32bits Rx1_L1_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd0)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (in_Rx1_L1_address0),
    .doutb  (in_Rx1_L1_q0)
  );
Interleaving_simpDual_19200_32bits Rx1_L1_out(
    .clka   (pl_clk),
    .wea    (out_Rx1_L1_we0),
    .addra  (out_Rx1_L1_address0),
    .dina   (out_Rx1_L1_d0),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx1_L1_data)
  );
  
  
interleave_0 interleave_Rx1_L1(
	.ap_clk         (pl_clk),
	.ap_rst         (~pl_rstn),
    .ap_start       (start[0]),
    .ap_done        (done[0]),
    .ap_idle        (idle[0]),
    .ap_ready       (ready[0]),
    .n              (n),
    .lay            (lay),
	.in_r_ce0       (),
	.in_r_address0  (in_Rx1_L1_address0),
	.in_r_q0	    (in_Rx1_L1_q0),
	.out_r_ce0      (),
	.out_r_we0      (out_Rx1_L1_we0),
	.out_r_address0 (out_Rx1_L1_address0),
	.out_r_d0       (out_Rx1_L1_d0)
);
/*
ila_0 ila_i(
    .clk     (pl_clk),
    .probe0 ({start[0], done[0], idle[0], ready[0]}),
    .probe1 ({n, Rx1_L1_power, inPow_Rx1_L1}),
    .probe2 ({in_Rx1_L1_address0, in_Rx1_L1_q0}),
    .probe3 ({out_Rx1_L1_address0, out_Rx1_L1_d0, out_Rx1_L1_we0})
);
*/
assign done[15:1]  = 15'd0;
assign idle[15:1]  = 15'd0;
assign ready[15:1] = 15'd0;

endmodule
