
`timescale 1 ns / 1 ps

module FFTCalculation_master_fft_stream_v1_0_M01_AXIS #
(
    // Users to add parameters here

    // User parameters ends
    // Do not modify the parameters beyond this line

    // Width of S_AXIS address bus. The slave accepts the read and write addresses of width C_M_AXIS_TDATA_WIDTH.
    parameter integer C_M_AXIS_TDATA_WIDTH	= 32,
    // Start count is the number of clock cycles the master will wait before initiating/issuing any transaction.
    parameter integer MEMORY_ADDR_WIDTH	= 14
)
(
    // Users to add ports here

    // User ports ends
    // Do not modify the ports beyond this line

    // Global ports
    input wire  M_AXIS_ACLK,
    // 
    input wire  M_AXIS_ARESETN,
    // Master Stream Ports. TVALID indicates that the master is driving a valid transfer, A transfer takes place when both TVALID and TREADY are asserted. 
    output wire  M_AXIS_TVALID,
    // TDATA is the primary payload that is used to provide the data that is passing across the interface from the master.
    output wire [C_M_AXIS_TDATA_WIDTH-1 : 0] M_AXIS_TDATA,
    // TSTRB is the byte qualifier that indicates whether the content of the associated byte of TDATA is processed as a data byte or a position byte.
    output wire [(C_M_AXIS_TDATA_WIDTH/8)-1 : 0] M_AXIS_TSTRB,
    // TLAST indicates the boundary of a packet.
    output wire  M_AXIS_TLAST,
    // TREADY indicates that the slave can accept a transfer in the current cycle.
    input wire  M_AXIS_TREADY,
    
    output [MEMORY_ADDR_WIDTH-1:0] fft_data_addrb,
    input [31:0] fft_data_doutb,
    input        fft_data_trigger,
    input [MEMORY_ADDR_WIDTH-1:0] fft_data_output_count
);                       
                                                                                                                   
                                                                                     
// Define the states of state machine                                                
// The control state machine oversees the writing of input streaming data to the FIFO,
// and outputs the streaming data from the FIFO                                      
parameter [1:0] IDLE = 2'b00,        // This is the initial/idle state                                                                                        
                INIT_COUNTER  = 2'b01, // This state initializes the counter, once   
                                // the counter reaches C_M_START_COUNT count,        
                                // the state machine changes state to SEND_STREAM     
                SEND_STREAM   = 2'b10; // In this state the                          
                                     // stream data is output through M_AXIS_TDATA   
// State variable                                                                    
reg [1:0] mst_exec_state;                                                            
// Example design FIFO read pointer                                                  
reg [MEMORY_ADDR_WIDTH-1:0] read_pointer;                                                      

// AXI Stream internal signals
//streaming data valid
wire  	axis_tvalid;
//streaming data valid delayed by one clock cycle
reg  	axis_tvalid_delay;
reg  	axis_tvalid_delay1;
reg  	axis_tvalid_delay2;
//Last of the streaming data 
wire  	axis_tlast;
//Last of the streaming data delayed by one clock cycle
reg  	axis_tlast_delay;
reg  	axis_tlast_delay1;
reg  	axis_tlast_delay2;
//FIFO implementation signals
reg [C_M_AXIS_TDATA_WIDTH-1 : 0] 	stream_data_out;
wire  	tx_en;
reg     tx_en_dealy1;
reg     tx_en_dealy2;
//The master has issued all the streaming data stored in FIFO
reg  	tx_done;


// I/O Connections assignments

assign M_AXIS_TVALID	= axis_tvalid_delay;
assign M_AXIS_TDATA	= stream_data_out;
assign M_AXIS_TLAST	= axis_tlast_delay;
assign M_AXIS_TSTRB	= {(C_M_AXIS_TDATA_WIDTH/8){1'b1}};
assign fft_data_addrb = read_pointer;
reg fft_data_trigger_reg;
reg fft_data_trigger_posedge;
always @(posedge M_AXIS_ACLK)                                                                  
begin
fft_data_trigger_reg <= fft_data_trigger;                                                                                          
if (!M_AXIS_ARESETN)                                                                                                                                                          
    fft_data_trigger_posedge <= 1'b0;                                                                                                                                                                                                                
else                                                                                         
    begin
    if((fft_data_trigger_reg == 1'b0) && (fft_data_trigger == 1'b1))                                                                                 
        fft_data_trigger_posedge <= 1'b1;
    else
        fft_data_trigger_posedge <= 1'b0;                                                      
    end                                                                                        
end 
           

// Control state machine implementation                             
always @(posedge M_AXIS_ACLK)                                             
begin                                                                     
  if (!M_AXIS_ARESETN)                                                    
  // Synchronous reset (active low)                                       
    begin                                                                 
      mst_exec_state <= IDLE;                                                                                                
    end                                                                   
  else                                                                    
    case (mst_exec_state)                                                 
      IDLE:                                                                                            
        if ( fft_data_trigger_posedge == 1'b1 )                                                 
          begin                                                           
            mst_exec_state  <= SEND_STREAM;                              
          end                                                             
        else                                                              
          begin                                                           
            mst_exec_state  <= IDLE;                                      
          end                                                                                                                      	                                                                          
      SEND_STREAM:                                                        
        // The example design streaming master functionality starts       
        // when the master drives output tdata from the FIFO and the slave
        // has finished storing the S_AXIS_TDATA                          
        if (tx_done)                                                      
          begin                                                           
            mst_exec_state <= IDLE;                                       
          end                                                             
        else                                                              
          begin                                                           
            mst_exec_state <= SEND_STREAM;                                
          end                                                             
    endcase                                                               
end                                                                       


//tvalid generation
//axis_tvalid is asserted when the control state machine's state is SEND_STREAM and
//number of output streaming data is less than the NUMBER_OF_OUTPUT_WORDS.
assign axis_tvalid = ((mst_exec_state == SEND_STREAM) && (read_pointer < fft_data_output_count));
                                                                                               
// AXI tlast generation                                                                        
// axis_tlast is asserted number of output streaming data is NUMBER_OF_OUTPUT_WORDS-1          
// (0 to NUMBER_OF_OUTPUT_WORDS-1)                                                             
assign axis_tlast = (read_pointer == fft_data_output_count-1);                                
                                                                                               
                                                                                               
// Delay the axis_tvalid and axis_tlast signal by one clock cycle                              
// to match the latency of M_AXIS_TDATA                                                        
always @(posedge M_AXIS_ACLK)                                                                  
begin                                                                                          
  if (!M_AXIS_ARESETN)                                                                         
    begin                                                                                      
      axis_tvalid_delay <= 1'b0;                                                               
      axis_tlast_delay <= 1'b0;     
      axis_tvalid_delay1 <= 1'b0;                                                               
      axis_tlast_delay1 <= 1'b0;  
      axis_tvalid_delay2 <= 1'b0;                                                               
      axis_tlast_delay2 <= 1'b0;                                                             
    end                                                                                        
  else                                                                                         
    begin                                                                                      
      axis_tvalid_delay2 <= axis_tvalid;                                                        
      axis_tlast_delay2 <= axis_tlast;   
      axis_tvalid_delay1 <= axis_tvalid_delay2;                                                        
      axis_tlast_delay1 <= axis_tlast_delay2;      
      axis_tvalid_delay <= axis_tvalid_delay1;                                                        
      axis_tlast_delay <= axis_tlast_delay1;                                                    
    end                                                                                        
end                                                                                            


//read_pointer pointer

always@(posedge M_AXIS_ACLK)                                               
begin                                                                            
    if(!M_AXIS_ARESETN)                                                            
    begin                                                                        
        read_pointer <= 0;                                                         
        tx_done <= 1'b0;                                                           
    end
    else if (fft_data_trigger_posedge == 1'b1)                                                 
    begin                                                           
        read_pointer <= 0;                                                         
        tx_done <= 1'b0;                             
    end                                                                    
    else if (read_pointer <= fft_data_output_count-1)                                
    begin                                                                      
        if (tx_en)                                                                                                
        begin                                                                  
            read_pointer <= read_pointer + 1;                                    
            tx_done <= 1'b0;                                                     
        end                                                                    
    end                                                                        
    else if (read_pointer == fft_data_output_count)                             
    begin                                                                                                                          
        tx_done <= 1'b1;                                                         
    end                                                                        
end                                                                              


//FIFO read enable generation 

assign tx_en = M_AXIS_TREADY && axis_tvalid;   
                                                     
    // Streaming output data is read from FIFO       
    always @( posedge M_AXIS_ACLK )                  
    begin     
      tx_en_dealy2 <= tx_en_dealy1;
      tx_en_dealy1 <= tx_en;                                       
      if(!M_AXIS_ARESETN)                            
        begin                                        
          stream_data_out <= 1;                      
        end                                          
      else if (tx_en_dealy2)// && M_AXIS_TSTRB[byte_index]  
        begin                                        
          stream_data_out <= {fft_data_doutb[15:0],fft_data_doutb[31:16]}; //read_pointer + 32'b1;   
        end                                          
    end                                              


endmodule
