`timescale 1 ns / 1 ps

module FFTCalculation_master_fft_stream_v1_0_M00_AXIS # (parameter integer C_M_AXIS_TDATA_WIDTH = 32)
(
    input wire fft_config_trigger,
    input [C_M_AXIS_TDATA_WIDTH-1:0] fft_config_command,
    // Global ports
    input wire  M_AXIS_ACLK,
    input wire  M_AXIS_ARESETN,
    // Master Stream Ports. TVALID indicates that the master is driving a valid transfer, A transfer takes place when both TVALID and TREADY are asserted. 
    output wire  M_AXIS_TVALID,
    // TDATA is the primary payload that is used to provide the data that is passing across the interface from the master.
    output wire [C_M_AXIS_TDATA_WIDTH-1 : 0] M_AXIS_TDATA,
    // TSTRB is the byte qualifier that indicates whether the content of the associated byte of TDATA is processed as a data byte or a position byte.
    output wire [(C_M_AXIS_TDATA_WIDTH/8)-1 : 0] M_AXIS_TSTRB,
    // TLAST indicates the boundary of a packet.
    output wire  M_AXIS_TLAST,
    // TREADY indicates that the slave can accept a transfer in the current cycle.
    input wire  M_AXIS_TREADY
);
               
//streaming data valid
wire  	axis_tvalid;
//streaming data valid delayed by one clock cycle
reg  	axis_tvalid_delay;
//Last of the streaming data 
wire  	axis_tlast;
//Last of the streaming data delayed by one clock cycle
reg  	axis_tlast_delay;
//FIFO implementation signals
reg [C_M_AXIS_TDATA_WIDTH-1 : 0] 	stream_data_out;
wire  	tx_en;
//The master has issued all the streaming data stored in FIFO
reg  	tx_done;

reg     fft_config_trigger_reg;
reg     fft_config_trigger_posedge;

// I/O Connections assignments
assign M_AXIS_TVALID= axis_tvalid_delay;
assign M_AXIS_TDATA	= stream_data_out;
assign M_AXIS_TLAST	= axis_tlast_delay;
assign M_AXIS_TSTRB	= {(C_M_AXIS_TDATA_WIDTH/8){1'b1}};                                                                   

//tvalid generation
assign axis_tvalid = (fft_config_trigger_posedge == 1'b1);
//FIFO read enable generation 
assign tx_en = M_AXIS_TREADY && axis_tvalid; 	                                                                                               
// AXI tlast generation                                                                                                                               
assign axis_tlast = tx_done;        



always @(posedge M_AXIS_ACLK)                                                                  
    begin
    fft_config_trigger_reg <= fft_config_trigger;                                                                                          
    if (!M_AXIS_ARESETN)    
        begin                                                                                                                                                       
        fft_config_trigger_posedge <= 1'b0;
        tx_done <= 1'b0; 
        end                                                                                                                                                                                                                   
    else                                                                                         
        begin
        if((fft_config_trigger_reg == 1'b0) && (fft_config_trigger == 1'b1))
            begin                                                                                       
            fft_config_trigger_posedge <= 1'b1;
            tx_done <= 1'b1;
            end 
        else
            begin
            fft_config_trigger_posedge <= 1'b0;
            tx_done <= 1'b0; 
            end                                                        
        end                                                                                        
    end 
                                                                                        
// Delay the axis_tvalid and axis_tlast signal by one clock cycle                              
// to match the latency of M_AXIS_TDATA                                                        
always @(posedge M_AXIS_ACLK)                                                                  
begin                                                                                          
  if (!M_AXIS_ARESETN)                                                                         
    begin                                                                                      
      axis_tvalid_delay <= 1'b0;                                                               
      axis_tlast_delay <= 1'b0;                                                                
    end                                                                                        
  else                                                                                         
    begin                                                                                      
      axis_tvalid_delay <= axis_tvalid;                                                        
      axis_tlast_delay <= axis_tlast;                                                          
    end                                                                                        
end                                                                                            
                                                
// Streaming output data is read from FIFO       
always @( posedge M_AXIS_ACLK )                  
begin                                            
  if(!M_AXIS_ARESETN)                            
    begin                                        
      stream_data_out <= 1;                      
    end                                          
  else if (tx_en)// && M_AXIS_TSTRB[byte_index]  
    begin                                        
      stream_data_out <= fft_config_command;   
    end                                          
end                                              

endmodule
