
`timescale 1 ns / 1 ps

	module FFTCalculation_master_fft_stream_v1_0 #
	(
		// Parameters of Axi Master Bus Interface M00_AXIS
		parameter integer C_M00_AXIS_TDATA_WIDTH	= 32,

		// Parameters of Axi Master Bus Interface M01_AXIS
		parameter integer C_M01_AXIS_TDATA_WIDTH	= 32,
		parameter integer BRAM0_MEMORY_ADDR_WIDTH	= 14
	)
	(
		// Ports of Axi Master Bus Interface M00_AXIS
		input wire  m00_axis_aclk,
		input wire  m00_axis_aresetn,
		output wire  m00_axis_tvalid,
		output wire [C_M00_AXIS_TDATA_WIDTH-1 : 0] m00_axis_tdata,
		output wire [(C_M00_AXIS_TDATA_WIDTH/8)-1 : 0] m00_axis_tstrb,
		output wire  m00_axis_tlast,
		input wire  m00_axis_tready,

		// Ports of Axi Master Bus Interface M01_AXIS
		input wire  m01_axis_aclk,
		input wire  m01_axis_aresetn,
		output wire  m01_axis_tvalid,
		output wire [C_M01_AXIS_TDATA_WIDTH-1 : 0] m01_axis_tdata,
		output wire [(C_M01_AXIS_TDATA_WIDTH/8)-1 : 0] m01_axis_tstrb,
		output wire  m01_axis_tlast,
		input wire  m01_axis_tready,
		    
		input wire fft_config_trigger,
        input [C_M00_AXIS_TDATA_WIDTH-1:0] fft_config_command,
        
        output [BRAM0_MEMORY_ADDR_WIDTH-1:0] fft_data_addrb,
        input [C_M01_AXIS_TDATA_WIDTH-1:0] fft_data_doutb,
        input fft_data_trigger,
        input [BRAM0_MEMORY_ADDR_WIDTH-1:0] fft_data_output_count
	);
// Instantiation of Axi Bus Interface M00_AXIS
	FFTCalculation_master_fft_stream_v1_0_M00_AXIS # (
	   .C_M_AXIS_TDATA_WIDTH(C_M00_AXIS_TDATA_WIDTH)
	   ) master_fft_stream_v1_0_M00_AXIS_inst (
		.M_AXIS_ACLK(m00_axis_aclk),
		.M_AXIS_ARESETN(m00_axis_aresetn),
		.M_AXIS_TVALID(m00_axis_tvalid),
		.M_AXIS_TDATA(m00_axis_tdata),
		.M_AXIS_TSTRB(m00_axis_tstrb),
		.M_AXIS_TLAST(m00_axis_tlast),
		.M_AXIS_TREADY(m00_axis_tready),
		.fft_config_trigger(fft_config_trigger),
        .fft_config_command(fft_config_command)
	);

// Instantiation of Axi Bus Interface M01_AXIS
	FFTCalculation_master_fft_stream_v1_0_M01_AXIS # ( 
		.C_M_AXIS_TDATA_WIDTH(C_M01_AXIS_TDATA_WIDTH),
		.MEMORY_ADDR_WIDTH(BRAM0_MEMORY_ADDR_WIDTH)
	) master_fft_stream_v1_0_M01_AXIS_inst (
		.M_AXIS_ACLK(m01_axis_aclk),
		.M_AXIS_ARESETN(m01_axis_aresetn),
		.M_AXIS_TVALID(m01_axis_tvalid),
		.M_AXIS_TDATA(m01_axis_tdata),
		.M_AXIS_TSTRB(m01_axis_tstrb),
		.M_AXIS_TLAST(m01_axis_tlast),
		.M_AXIS_TREADY(m01_axis_tready),
		.fft_data_addrb        (fft_data_addrb       ),
        .fft_data_doutb        (fft_data_doutb       ),
        .fft_data_trigger      (fft_data_trigger     ),
        .fft_data_output_count (fft_data_output_count)
	);

	// Add user logic here


	// User logic ends

	endmodule
