`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 02/15/2021 10:35:41 AM
// Design Name: 
// Module Name: top
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module FFTCalculation(
input pl_clk,
input pl_resetn,
input [31:0] alihgh_n,
input alihgh_rst,
input alihgh_start,
output reg alihgh_finish=1'b0,
input [31:0] In_Data,
input In_En,
input [31:0] In_Addr,
input [31:0] Out_Addr,
output[31:0] Out_Data,
input [31:0] Select);
    
wire [31:0]fft_data_addrb;
wire [31:0]fft_data_doutb;
wire [31:0]out_Rx1_L1_data;

 

reg alihgh_start_reg=1'b0;
reg alihgh_start_posedge=1'b0;

wire m00_axis_tvalid;
wire [32-1 : 0] m00_axis_tdata;
wire [(32/8)-1 : 0] m00_axis_tstrb;
wire m00_axis_tlast;
wire  m00_axis_tready;

wire m01_axis_tvalid;
wire [32-1 : 0] m01_axis_tdata;
wire [(32/8)-1 : 0] m01_axis_tstrb;
wire  m01_axis_tlast;
wire  m01_axis_tready;

reg fft_config_trigger;
reg [32-1:0] fft_config_command;
reg [1:0] fft_config_state;

reg fft_data_trigger;
wire [14-1:0] fft_data_output_count;


wire [31:0] m_axis_data_tdata 	;
wire m_axis_data_tvalid 		;
reg  [31:0] m_axis_data_address ; 
reg  m_axis_data_tready = 1'b1	;
wire m_axis_data_tlast 			;
wire event_frame_started 		;
wire event_tlast_unexpected 	;
wire event_tlast_missing 		;
wire event_status_channel_halt 	;
wire event_data_in_channel_halt ;
wire event_data_out_channel_halt;

wire event_frame_started_1 		;
wire event_tlast_unexpected_1 	;
wire event_tlast_missing_1 		;
wire event_status_channel_halt_1;
wire event_data_in_channel_halt_1;
wire event_data_out_channel_halt_1;


assign fft_data_output_count =  (alihgh_n <= 8)?14'h0008:
                               ((alihgh_n <= 16)?14'h0010:
                               ((alihgh_n <= 32)?14'h0020:
                               ((alihgh_n <= 64)?14'h0040:
                               ((alihgh_n <= 128)?14'h0080:
                               ((alihgh_n <= 256)?14'h0100:
                               ((alihgh_n <= 512)?14'h0200:
                               ((alihgh_n <= 1024)?14'h0400:14'h0800)))))));

assign Out_Data = (Select ==32'd32)? out_Rx1_L1_data:0;

FFT_simpDual_19200_32bits Rx1_L1_in(
    .clka   (pl_clk),
    .wea    (In_En && (Select == 32'd0)),
    .addra  (In_Addr),
    .dina   (In_Data),
    .clkb   (pl_clk),
    .addrb  (fft_data_addrb),
    .doutb  (fft_data_doutb)
  );
  
  

  
FFT_simpDual_19200_32bits Rx1_L1_out(
    .clka   (pl_clk),
    .wea    (m_axis_data_tvalid),
    .addra  (m_axis_data_address),
    .dina   (m_axis_data_tdata),
    .clkb   (pl_clk),
    .addrb  (Out_Addr),
    .doutb  (out_Rx1_L1_data)
  );


always @(posedge pl_clk)
begin
    alihgh_start_reg <= alihgh_start;
    alihgh_start_posedge <= 1'b0;
    if(m_axis_data_tlast == 1'b1)
        alihgh_finish <= 1'b1;
    if((alihgh_start_reg == 1'b0) && (alihgh_start==1'b1))
    begin
        alihgh_finish <= 1'b0;
        alihgh_start_posedge <= 1'b1;
        m_axis_data_address <= 32'd0;
    end
    else if(m_axis_data_tvalid == 1'b1)
        m_axis_data_address <= m_axis_data_address+1;
end


always @(posedge pl_clk)
begin    
    if((!pl_resetn) || (alihgh_rst == 1))
        begin
        fft_config_state <= 2'b00;
        fft_data_trigger <= 1'b0;
        fft_config_trigger <= 1'b0;
        end
    else if(fft_config_state == 2'b00)
        begin
        if(alihgh_start_posedge == 1'b1)
            fft_config_state <= 2'b10;
        end
    else if ((fft_config_state == 2'b01) && (m00_axis_tready == 1'b1))
        begin
        fft_data_trigger <= 1'b0;
        fft_config_state <= 2'b10;
        fft_config_command <= 32'd0;
        fft_config_trigger <= 1'b1;
        end
    else if ((fft_config_state == 2'b10) && (m01_axis_tready == 1'b1))
        begin
        fft_config_trigger <= 1'b0;
        fft_data_trigger <= 1'b1;
        fft_config_state <= 2'b11;
        end 
    else if ((fft_config_state == 2'b11) && (m_axis_data_tlast == 1'b1))
        begin
        fft_config_trigger <= 1'b0;
        fft_data_trigger <= 1'b0;
        fft_config_state <= 2'b00;
        end      
end    


FFTCalculation_master_fft_stream_v1_0 #
(
    .C_M00_AXIS_TDATA_WIDTH(32),
    .C_M01_AXIS_TDATA_WIDTH(32),
    .BRAM0_MEMORY_ADDR_WIDTH(14)
) FFTCalculation_master_fft_stream_v1_i
(
    .m00_axis_aclk    (pl_clk   ),
    .m00_axis_aresetn ((pl_resetn) && (!alihgh_rst)),
    .m00_axis_tvalid  (m00_axis_tvalid ),
    .m00_axis_tdata   (m00_axis_tdata  ),
    .m00_axis_tstrb   (m00_axis_tstrb  ),
    .m00_axis_tlast   (m00_axis_tlast  ),
    .m00_axis_tready  (m00_axis_tready ),
    
    .m01_axis_aclk    (pl_clk   ),
    .m01_axis_aresetn ((pl_resetn) && (!alihgh_rst)),
    .m01_axis_tvalid  (m01_axis_tvalid ),
    .m01_axis_tdata   (m01_axis_tdata  ),
    .m01_axis_tstrb   (m01_axis_tstrb  ),
    .m01_axis_tlast   (m01_axis_tlast  ),
    .m01_axis_tready  (m01_axis_tready ),
        
    .fft_config_trigger (fft_config_trigger),
    .fft_config_command (fft_config_command),
      
    .fft_data_addrb (fft_data_addrb),
    .fft_data_doutb (fft_data_doutb),
    .fft_data_trigger(fft_data_trigger),
    .fft_data_output_count (fft_data_output_count)
);
   
xfft_0 xfft_i_0(
    .aclk (pl_clk),
    .aresetn ((pl_resetn) && (!alihgh_rst)),
    .s_axis_config_tdata (m00_axis_tdata),
    .s_axis_config_tvalid(m00_axis_tvalid),
    .s_axis_config_tready(m00_axis_tready),
    .s_axis_data_tdata  (m01_axis_tdata),
    .s_axis_data_tvalid (m01_axis_tvalid),
    .s_axis_data_tready (m01_axis_tready),
    .s_axis_data_tlast (m01_axis_tlast),
    .m_axis_data_tdata 			 (m_axis_data_tdata 			),	
    .m_axis_data_tvalid 		 (m_axis_data_tvalid 			),	
    .m_axis_data_tready 		 (1'b1     			            ),	
    .m_axis_data_tlast 			 (m_axis_data_tlast 			),	
    .event_frame_started 		 (event_frame_started 			),	
    .event_tlast_unexpected 	 (event_tlast_unexpected 		),	
    .event_tlast_missing 		 (event_tlast_missing 			),	
    .event_status_channel_halt 	 (event_status_channel_halt 	),	
    .event_data_in_channel_halt  (event_data_in_channel_halt 	),	
    .event_data_out_channel_halt (event_data_out_channel_halt	)
  );


/*
ila_0 ila_i(
    .clk    (pl_clk),
    .probe0 ({m_axis_data_tdata, m_axis_data_tvalid,m_axis_data_tlast}), //34
    .probe1 ({fft_config_trigger, fft_config_command, fft_config_state, fft_data_trigger, fft_data_output_count, alihgh_rst, alihgh_start, alihgh_start_reg, alihgh_start_posedge, alihgh_finish}), //55
    .probe2 ({In_En, Select, In_Addr, In_Data, fft_data_addrb, fft_data_doutb}), //161
    .probe3 ({m_axis_data_tvalid, m_axis_data_address, m_axis_data_tdata, Out_Addr, out_Rx1_L1_data}) //129
); 
*/
    
endmodule
