
`timescale 1 ns / 1 ps

	module Demaping_Kernel_Interface_v1_0 #
	(
		// Users to add parameters here

		// User parameters ends
		// Do not modify the parameters beyond this line


		// Parameters of Axi Slave Bus Interface S00_AXI
		parameter integer C_S00_AXI_DATA_WIDTH	= 32,
		parameter integer C_S00_AXI_ADDR_WIDTH	= 32,

		// Parameters of Axi Master Bus Interface M00_AXIS
		parameter integer C_M00_AXIS_TDATA_WIDTH	= 32,
		parameter integer C_M00_AXIS_TADDR_WIDTH	= 32,
		parameter integer C_M00_AXIS_START_COUNT	= 32,

		// Parameters of Axi Slave Bus Interface S00_AXIS
		parameter integer C_S00_AXIS_TDATA_WIDTH	= 32,
		parameter integer C_S00_AXIS_TADDR_WIDTH	= 32
	)
	(
		// Users to add ports here
        output [C_S00_AXIS_TDATA_WIDTH-1:0] alihgh_MIn_Data,
        output 		alihgh_MIn_En,
        output [C_M00_AXIS_TADDR_WIDTH-1:0] alihgh_MIn_Addr,
        
        output [C_S00_AXIS_TADDR_WIDTH-1:0] alihgh_MOut_Addr,
        input  [C_M00_AXIS_TDATA_WIDTH-1:0] alihgh_MOut_Data,
        
        output [C_S00_AXI_DATA_WIDTH-1:0] alihgh_Mem_Select,
        
        output alihgh_MIn_Start,
        output alihgh_MOut_Start,
        output [C_S00_AXI_DATA_WIDTH-1:0] alihgh_MIn_Size,
        output [C_S00_AXI_DATA_WIDTH-1:0] alihgh_MOut_Size,
        
        
        output [15:0] alihgh_start,
        input  [15:0] alihgh_done,
        input  [15:0] alihgh_idle,
        input  [15:0] alihgh_ready,
        output [31:0] alihgh_n,
        output [31:0] alihgh_scaling_factor,
        output [31:0] alihgh_mod_r,
        
        
        input  [15:0] alihgh_err_vld,
        input  [31:0] alihgh_Rx1_L1_err,

		// User ports ends
		// Do not modify the ports beyond this line


		// Ports of Axi Slave Bus Interface S00_AXI
		input wire  s00_axi_aclk,
		input wire  s00_axi_aresetn,
		input wire [C_S00_AXI_ADDR_WIDTH-1 : 0] s00_axi_awaddr,
		input wire [2 : 0] s00_axi_awprot,
		input wire  s00_axi_awvalid,
		output wire  s00_axi_awready,
		input wire [C_S00_AXI_DATA_WIDTH-1 : 0] s00_axi_wdata,
		input wire [(C_S00_AXI_DATA_WIDTH/8)-1 : 0] s00_axi_wstrb,
		input wire  s00_axi_wvalid,
		output wire  s00_axi_wready,
		output wire [1 : 0] s00_axi_bresp,
		output wire  s00_axi_bvalid,
		input wire  s00_axi_bready,
		input wire [C_S00_AXI_ADDR_WIDTH-1 : 0] s00_axi_araddr,
		input wire [2 : 0] s00_axi_arprot,
		input wire  s00_axi_arvalid,
		output wire  s00_axi_arready,
		output wire [C_S00_AXI_DATA_WIDTH-1 : 0] s00_axi_rdata,
		output wire [1 : 0] s00_axi_rresp,
		output wire  s00_axi_rvalid,
		input wire  s00_axi_rready,

		// Ports of Axi Master Bus Interface M00_AXIS
		input wire  m00_axis_aclk,
		input wire  m00_axis_aresetn,
		output wire  m00_axis_tvalid,
		output wire [C_M00_AXIS_TDATA_WIDTH-1 : 0] m00_axis_tdata,
		output wire [(C_M00_AXIS_TDATA_WIDTH/8)-1 : 0] m00_axis_tstrb,
		output wire  m00_axis_tlast,
		input wire  m00_axis_tready,

		// Ports of Axi Slave Bus Interface S00_AXIS
		input wire  s00_axis_aclk,
		input wire  s00_axis_aresetn,
		output wire  s00_axis_tready,
		input wire [C_S00_AXIS_TDATA_WIDTH-1 : 0] s00_axis_tdata,
		input wire [(C_S00_AXIS_TDATA_WIDTH/8)-1 : 0] s00_axis_tstrb,
		input wire  s00_axis_tlast,
		input wire  s00_axis_tvalid
	);
	
/*wire alihgh_MIn_Start;
wire alihgh_MOut_Start;
wire [C_S00_AXI_DATA_WIDTH-1 : 0] alihgh_MIn_Size;
wire [C_S00_AXI_DATA_WIDTH-1 : 0] alihgh_MOut_Size;
*/

wire alihgh_MIn_Done; 
wire alihgh_MOut_Done; 
wire alihgh_startStream;	
	
// Instantiation of Axi Bus Interface S00_AXI
	Demaping_Kernel_Interface_v1_0_S00_AXI # ( 
		.C_S_AXI_DATA_WIDTH(C_S00_AXI_DATA_WIDTH),
		.C_S_AXI_ADDR_WIDTH(C_S00_AXI_ADDR_WIDTH)
	) Demaping_Kernel_Interface_v1_0_S00_AXI_inst (
	
	    //<alihgh -Add
        .alihgh_MIn_Start  (alihgh_MIn_Start),
        .alihgh_MOut_Start (alihgh_MOut_Start),
        .alihgh_MIn_Size   (alihgh_MIn_Size  ),
        .alihgh_MOut_Size  (alihgh_MOut_Size ),
        .alihgh_Mem_Select (alihgh_Mem_Select),
        .alihgh_MIn_Done   (alihgh_MIn_Done),
        .alihgh_MOut_Done  (alihgh_MOut_Done),
        
        .alihgh_start        (alihgh_start       ),
        .alihgh_done         (alihgh_done        ),
        .alihgh_idle         (alihgh_idle        ),
        .alihgh_ready        (alihgh_ready       ),
        .alihgh_n            (alihgh_n           ),
        .alihgh_scaling_factor(alihgh_scaling_factor),
        .alihgh_mod_r        (alihgh_mod_r),
        .alihgh_err_vld    (alihgh_err_vld   ),
        .alihgh_Rx1_L1_err (alihgh_Rx1_L1_err),

        
	    //alihgh>
	
		.S_AXI_ACLK(s00_axi_aclk),
		.S_AXI_ARESETN(s00_axi_aresetn),
		.S_AXI_AWADDR(s00_axi_awaddr),
		.S_AXI_AWPROT(s00_axi_awprot),
		.S_AXI_AWVALID(s00_axi_awvalid),
		.S_AXI_AWREADY(s00_axi_awready),
		.S_AXI_WDATA(s00_axi_wdata),
		.S_AXI_WSTRB(s00_axi_wstrb),
		.S_AXI_WVALID(s00_axi_wvalid),
		.S_AXI_WREADY(s00_axi_wready),
		.S_AXI_BRESP(s00_axi_bresp),
		.S_AXI_BVALID(s00_axi_bvalid),
		.S_AXI_BREADY(s00_axi_bready),
		.S_AXI_ARADDR(s00_axi_araddr),
		.S_AXI_ARPROT(s00_axi_arprot),
		.S_AXI_ARVALID(s00_axi_arvalid),
		.S_AXI_ARREADY(s00_axi_arready),
		.S_AXI_RDATA(s00_axi_rdata),
		.S_AXI_RRESP(s00_axi_rresp),
		.S_AXI_RVALID(s00_axi_rvalid),
		.S_AXI_RREADY(s00_axi_rready)
	);

// Instantiation of Axi Bus Interface M00_AXIS
	Demaping_Kernel_Interface_v1_0_M00_AXIS # ( 
		.C_M_AXIS_TDATA_WIDTH(C_M00_AXIS_TDATA_WIDTH),
		.C_M_START_COUNT(C_M00_AXIS_START_COUNT)
	) Demaping_Kernel_Interface_v1_0_M00_AXIS_inst (	
        .alihgh_outputWords  (alihgh_MOut_Size),
        .alihgh_rdAddress    (alihgh_MOut_Addr),
        .alihgh_rdData       (alihgh_MOut_Data),
        .alihgh_rstAddr      (alihgh_MOut_Start),
        .alihgh_startStream  (alihgh_MOut_Start),
        .tx_done             (alihgh_MOut_Done),

		.M_AXIS_ACLK(m00_axis_aclk),
		.M_AXIS_ARESETN(m00_axis_aresetn),
		.M_AXIS_TVALID(m00_axis_tvalid),
		.M_AXIS_TDATA(m00_axis_tdata),
		.M_AXIS_TSTRB(m00_axis_tstrb),
		.M_AXIS_TLAST(m00_axis_tlast),
		.M_AXIS_TREADY(m00_axis_tready)
	);

// Instantiation of Axi Bus Interface S00_AXIS
	Demaping_Kernel_Interface_v1_0_S00_AXIS # ( 
		.C_S_AXIS_TDATA_WIDTH(C_S00_AXIS_TDATA_WIDTH)
	) Demaping_Kernel_Interface_v1_0_S00_AXIS_inst (
        .alihgh_rstAddr     (alihgh_MIn_Start),
        .alihgh_inputWords  (alihgh_MIn_Size),
        .writes_done        (alihgh_MIn_Done),
        .alihgh_wrData      (alihgh_MIn_Data),
        .alihgh_wrEnable    (alihgh_MIn_En),
        .alihgh_wrAddress   (alihgh_MIn_Addr),

		.S_AXIS_ACLK(s00_axis_aclk),
		.S_AXIS_ARESETN(s00_axis_aresetn),
		.S_AXIS_TREADY(s00_axis_tready),
		.S_AXIS_TDATA(s00_axis_tdata),
		.S_AXIS_TSTRB(s00_axis_tstrb),
		.S_AXIS_TLAST(s00_axis_tlast),
		.S_AXIS_TVALID(s00_axis_tvalid)
	);

	// Add user logic here

	// User logic ends

	endmodule
