module Kernel(
	    input pl_clk,
        input pl_resetn,
		input wire [32-1 : 0] s00_axi_awaddr,
		input wire [2 : 0] s00_axi_awprot,
		input wire  s00_axi_awvalid,
		output wire  s00_axi_awready,
		input wire [32-1 : 0] s00_axi_wdata,
		input wire [(32/8)-1 : 0] s00_axi_wstrb,
		input wire  s00_axi_wvalid,
		output wire  s00_axi_wready,
		output wire [1 : 0] s00_axi_bresp,
		output wire  s00_axi_bvalid,
		input wire  s00_axi_bready,
		input wire [32-1 : 0] s00_axi_araddr,
		input wire [2 : 0] s00_axi_arprot,
		input wire  s00_axi_arvalid,
		output wire  s00_axi_arready,
		output wire [32-1 : 0] s00_axi_rdata,
		output wire [1 : 0] s00_axi_rresp,
		output wire  s00_axi_rvalid,
		input wire  s00_axi_rready,
		
	    output wire  m00_axis_tvalid,
		output wire [32-1 : 0] m00_axis_tdata,
		output wire [(32/8)-1 : 0] m00_axis_tstrb,
		output wire  m00_axis_tlast,
		input wire  m00_axis_tready,
		
		output wire  s00_axis_tready,
		input wire [32-1 : 0] s00_axis_tdata,
		input wire [(32/8)-1 : 0] s00_axis_tstrb,
		input wire  s00_axis_tlast,
		input wire  s00_axis_tvalid

);

localparam integer C_S00_AXI_DATA_WIDTH		= 32;
localparam integer C_S00_AXI_ADDR_WIDTH		= 32;
localparam integer C_M00_AXIS_TDATA_WIDTH	= 32;
localparam integer C_M00_AXIS_TADDR_WIDTH	= 32;
localparam integer C_M00_AXIS_START_COUNT	= 32;
localparam integer C_S00_AXIS_TDATA_WIDTH	= 32;
localparam integer C_S00_AXIS_TADDR_WIDTH	= 32;

wire [31:0] alihgh_MIn_Data;
wire 		alihgh_MIn_En;
wire [31:0] alihgh_MIn_Addr;
wire [31:0] alihgh_MOut_Addr;
wire [31:0] alihgh_MOut_Data;
wire [31:0] alihgh_Mem_Select;

wire alihgh_MIn_Start;
wire alihgh_MOut_Start;
wire [31:0] alihgh_MIn_Size;
wire [31:0] alihgh_MOut_Size; 
 
wire [15:0] alihgh_start;
wire [15:0] alihgh_done;
wire [15:0] alihgh_idle;
wire [15:0] alihgh_ready;
wire [31:0] alihgh_n;
wire [31:0] alihgh_scaling_factor;
wire [31:0] alihgh_mod_r;
wire [15:0] alihgh_err_vld;
wire [31:0] alihgh_Rx1_L1_err;	


Demaping Demaping_i(
	.pl_clk		(pl_clk),
	.pl_rstn	(pl_resetn),	
	.In_Data 	  (alihgh_MIn_Data),
    .In_En   	  (alihgh_MIn_En),
    .In_Addr 	  (alihgh_MIn_Addr),
    .Out_Addr	  (alihgh_MOut_Addr),
    .Out_Data	  (alihgh_MOut_Data),
    .Select  	  (alihgh_Mem_Select),
    .start        (alihgh_start       ),
    .done         (alihgh_done        ),
    .idle         (alihgh_idle        ),
    .ready        (alihgh_ready       ),
    .n            (alihgh_n           ),
    .mod_r        (alihgh_mod_r),
    .scaling_factor(alihgh_scaling_factor),
    .err_vld    (alihgh_err_vld   ),
    .Rx1_L1_err (alihgh_Rx1_L1_err)
    );


Demaping_Kernel_Interface_v1_0 # (
	.C_S00_AXI_DATA_WIDTH(C_S00_AXI_DATA_WIDTH)  ,
	.C_S00_AXI_ADDR_WIDTH(C_S00_AXI_ADDR_WIDTH)   ,
	.C_M00_AXIS_TDATA_WIDTH(C_M00_AXIS_TDATA_WIDTH),
	.C_M00_AXIS_TADDR_WIDTH(C_M00_AXIS_TADDR_WIDTH),
	.C_M00_AXIS_START_COUNT(C_M00_AXIS_START_COUNT),
	.C_S00_AXIS_TDATA_WIDTH(C_S00_AXIS_TDATA_WIDTH),
	.C_S00_AXIS_TADDR_WIDTH(C_S00_AXIS_TADDR_WIDTH)
	) Demaping_Kernel_Interface_v1_i (
    // Users ports
    .alihgh_MIn_Data    (alihgh_MIn_Data),
    .alihgh_MIn_En      (alihgh_MIn_En),
    .alihgh_MIn_Addr    (alihgh_MIn_Addr),
    .alihgh_MOut_Addr   (alihgh_MOut_Addr),
    .alihgh_MOut_Data   (alihgh_MOut_Data),
    .alihgh_Mem_Select  (alihgh_Mem_Select),
    
    .alihgh_MIn_Start(alihgh_MIn_Start),
    .alihgh_MOut_Start(alihgh_MOut_Start),
    .alihgh_MIn_Size(alihgh_MIn_Size),
    .alihgh_MOut_Size(alihgh_MOut_Size),  
    
    .alihgh_start      (alihgh_start),
    .alihgh_done       (alihgh_done),
    .alihgh_idle       (alihgh_idle),
    .alihgh_ready      (alihgh_ready),
    .alihgh_n          (alihgh_n),
    .alihgh_scaling_factor (alihgh_scaling_factor),
    .alihgh_mod_r      (alihgh_mod_r),
    .alihgh_err_vld    (alihgh_err_vld),
    .alihgh_Rx1_L1_err (alihgh_Rx1_L1_err),

    
    // Ports of S00_AXI
    .s00_axi_aclk       (pl_clk),
    .s00_axi_aresetn    (pl_resetn),
	.s00_axi_awaddr     (s00_axi_awaddr ),
    .s00_axi_awprot     (s00_axi_awprot ),
    .s00_axi_awvalid    (s00_axi_awvalid),
    .s00_axi_awready    (s00_axi_awready),
    .s00_axi_wdata      (s00_axi_wdata  ),
    .s00_axi_wstrb      (s00_axi_wstrb  ),
    .s00_axi_wvalid     (s00_axi_wvalid ),
    .s00_axi_wready     (s00_axi_wready ),
    .s00_axi_bresp      (s00_axi_bresp  ),
    .s00_axi_bvalid     (s00_axi_bvalid ),
    .s00_axi_bready     (s00_axi_bready ),
    .s00_axi_araddr     (s00_axi_araddr ),
    .s00_axi_arprot     (s00_axi_arprot ),
    .s00_axi_arvalid    (s00_axi_arvalid),
    .s00_axi_arready    (s00_axi_arready),
    .s00_axi_rdata      (s00_axi_rdata  ),
    .s00_axi_rresp      (s00_axi_rresp  ),
    .s00_axi_rvalid     (s00_axi_rvalid ),
    .s00_axi_rready     (s00_axi_rready ),

    // Ports of M00_AXIS
    .m00_axis_aclk      (pl_clk),
    .m00_axis_aresetn   (pl_resetn),
    .m00_axis_tvalid    (m00_axis_tvalid),
    .m00_axis_tdata     (m00_axis_tdata ),
    .m00_axis_tstrb     (m00_axis_tstrb ),
    .m00_axis_tlast     (m00_axis_tlast ),
    .m00_axis_tready    (m00_axis_tready),

    // Ports S00_AXIS
    .s00_axis_aclk      (pl_clk),
    .s00_axis_aresetn   (pl_resetn),
    .s00_axis_tready    (s00_axis_tready),
    .s00_axis_tdata     (s00_axis_tdata ),
    .s00_axis_tstrb     (s00_axis_tstrb ),
    .s00_axis_tlast     (s00_axis_tlast ),
    .s00_axis_tvalid    (s00_axis_tvalid)
);

endmodule