/*
 * pmbus_i2c.h
 *
 *  Created on: Feb 7, 2021
 *      Author: alho343c
 */

#ifndef SRC_PMBUS_I2C_H_
#define SRC_PMBUS_I2C_H_



#include <stdio.h>
#include <xstatus.h>
#include "xil_printf.h"
#include "xparameters.h"
#include "xiicps.h"
#include "xgpiops.h"
/* PMBUS Commands */
#define CMD_PAGE            0x00
#define CMD_VOUT_MODE       0x20
#define CMD_READ_VOUT       0x8B
#define CMD_READ_IOUT       0x8C
#define CMD_READ_TEMP       0x8D
#define CMD_READ_POUT       0x96


//Modes in VOUT_MODE command
#define MODE_8_EXP 0x18
#define MODE_8_VALUE 3.906
#define MODE_9_EXP 0x17
#define MODE_9_VALUE 1.953
#define MODE_12_EXP 0x14
#define MODE_12_VALUE 0.024
//Modes in IOUT_MODE command
#define MODE_6_EXP 0x1A
#define MODE_6_VALUE 15.625
#define MODE_3_EXP 0x1D
#define MODE_3_VALUE 125
#define MODE_10_EXP 0x16
#define MODE_10_VALUE 0.976
//Modes in POUT_MODE command
#define MODE_5_EXP 0x1B
#define MODE_5_VALUE 31.25
#define MODE_2_EXP 0x1E
#define MODE_2_VALUE 250



#define I2C_DEVICE_ID		XPAR_XIICPS_0_DEVICE_ID


#define I2C_MUX_ADDRESS		    0x75
#define I2C_MUX_CHANNEL_MASK    0x10
#define I2C_MUX_NOT_RST_PIN		12

#define I2C_SLAVE_ADDR		0x43
#define I2C_SCLK_RATE		100000

struct pmbus_i2c {
	float voltage_resolution;
};

struct pmbus_i2c pow_monitor;
XIicPs i2c;


int ps_setup_i2c();
int pmbus_setup();
int i2c_mux_reset();
int i2c_mux_setup();
int pmbus_read(unsigned char address, unsigned char command, unsigned char byteCount, unsigned char *buffer);
int pmbus_write(unsigned char address, unsigned char command, unsigned char data);

double Measure_Sensors(double pre_total_pow);
double read_voltage(int Addr);
double read_current(int Addr);
int read_temp(int Addr);
double read_power(int Addr);
#endif /* SRC_PMBUS_I2C_H_ */
