#include "windowing.h"


void window(complex* in, int pow, int n, complex* out, int* res_power)
{
	int i;
	long int ptot = 0;
	int used_sc = n/TAP_FAC;    // n will always be >= 12 and possible to divide by 4

	// Calc used power
	for (i=0; i<used_sc; i++)
		ptot += in[i].re * in[i].re + in[i].im * in[i].im;

	ptot = ptot >> 16;
	*res_power = pow - ptot;

	if (*res_power < 0)
	*res_power = 1;

	// Copy the used taps-coeffs
	for (i=0; i<used_sc; i++)
		out[i] = in[i];

	// Reset the rest of the coefficients
	for (i=used_sc; i<n; i++)
		{
		out[i].re = 0;
		out[i].im = 0;
		}
}

complex vector_in1[MAX_SC];
complex vector_out[MAX_SC];


int windowingTest(
	unsigned int InData [MAX_SC],
	unsigned int outData [MAX_SC])
{

	int status;
    int ii=0;
    for(ii=0; ii<MAX_SC; ii++)
    {
    	vector_in1[ii].re = (InData[ii]&0xFFFF);
    	vector_in1[ii].im = ((InData[ii]>>16)&0xFFFF);
    }
    unsigned int tmpVal;
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);
    tmpVal = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x00);
    tmpVal = tmpVal | 0x0001;
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x00 , tmpVal); // MM2S Control Reset
    tmpVal = Xil_In32 ( XPAR_AXI_DMA_0_BASEADDR + 0x30 );
    tmpVal = tmpVal | 0x0001;
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x30 , tmpVal); // S2MM Control Reset
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);

    unsigned int inputDataSize, outputDataSize;
    u32 pLSB, pMSB;

    int nmbRB	 = 100;
	int power 	 = 10;
	int nmbSc 	 = nmbRB*12;


    XTime tStart1, tEnd1;
    int software_Out_Power;
    unsigned int tmp1;
    XTime_GetTime(&tStart1);
    window(vector_in1, power, nmbSc, vector_out, &software_Out_Power);
	XTime_GetTime(&tEnd1);
	//Test the output

	Xil_DCacheDisable();
    //Send data to the In-memory via DMA
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x08, 0); //Mem Select
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x0C, 1); //Restart Mem1 address
    inputDataSize = nmbSc;
    pLSB = (u32)(uint64_t)InData;
    pMSB = (u32)((uint64_t)InData>>32);
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x18 , pLSB); 	   // MM2S Source LSB Address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x1c , pMSB); // MM2S Source MSB Address
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x28 , inputDataSize*4);  	  // MM2S Transfer Length (Bytes)
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    while((status & 0x02) == 0)
    	status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);

    XTime tStart, tEnd;
    unsigned int tmp;
    int hardware_Out_Power;
    //Start the Kernel
    int times[100];
    int iii;
    int SC = 1200;
    for(iii=0; iii<1; iii++)
    {
    	//int SC = (iii+1)*12;
		Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 28, 1); //set layer
		Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 32, SC); //set SC
		Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 64, power); //set Power In

		XTime_GetTime(&tStart);
		Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 36, 1); //set Start
		while(!(Xil_In32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 60)&0x01));
		XTime_GetTime(&tEnd);
		status = Xil_In32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 60);
		times[iii] = tEnd - tStart;
    }
	//Read Data Out Back via DMA
    outputDataSize = nmbSc;
    pLSB = (u32)(uint64_t)outData;
    pMSB = (u32)((uint64_t)outData>>32);
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x48 , pLSB);	  // S2MM Source LSB Address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x4c , pMSB); // S2MM Source MSB Address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x58 , outputDataSize*4);  // S2MM Transfer Length (Bytes)
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x08, 32); //Mem Select
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x04, outputDataSize); //Mem Out Size
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x0C, 2); //Restart Mem1 address
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);
    while((status & 0x02) == 0)
    	status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);
    hardware_Out_Power=Xil_In32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 64);

    //float tmp = 1.0 * (tEnd - tStart) / (COUNTS_PER_SECOND/1000000);
	tmp = 10 * (tEnd - tStart);
	tmp1 = 10 * (tEnd1 - tStart1);
    xil_printf("Hardware (%d), Software (%d) ns.\n", tmp, tmp1);

	if(hardware_Out_Power != software_Out_Power)
		xil_printf("Error %d != %d\n", hardware_Out_Power, software_Out_Power);
	for(ii=0; ii<MAX_SC; ii++)
	{
		complex tmp;
		tmp.re = (outData[ii]&0xFFFF);
		tmp.im = ((outData[ii]>>16)&0xFFFF);
		if((tmp.re != vector_out[ii].re) || (tmp.im != vector_out[ii].im))
			xil_printf("Error %d, %d(%d), %d(%d)\n", ii, tmp.re, vector_out[ii].re, tmp.im, vector_out[ii].im);
	}
}
