#include "xil_printf.h"
#include <xstatus.h>
#include "xil_cache.h"
#include "xparameters.h"	// SDK generated parameters
#include "xsdps.h"
#include "sdCard.h"

int SD_Init()
{
	TCHAR *Path = "0:/";
	FRESULT Res;
	Res = f_mount(&fatfs, Path, 0);
	if (Res != FR_OK)
	{
		xil_printf(" ERROR : f_mount returned %d\r\n", Res);
		return XST_FAILURE;
	}
	return XST_SUCCESS;
}

int SD_Eject()
{
	TCHAR *Path = "0:/";
	FRESULT Res;
	Res = f_mount(&fatfs, Path, 1);
	if (Res != FR_OK)
	{
		xil_printf(" ERROR : f_mount returned %d\r\n", Res);
		return XST_FAILURE;
	}
	return XST_SUCCESS;
}



int ReadFile(char *FileName, char *DestinationAddress)
{
	FRESULT Res;
	UINT NumBytesRead;
	FIL fil;		// File object

	Res = f_open(&fil, FileName, FA_OPEN_ALWAYS  | FA_READ);
	if (Res)
	{
		xil_printf(" ERROR : f_open returned %d\r\n", Res);
		return XST_FAILURE;
	}

	// Pointer to beginning of file .
	Res = f_lseek(&fil, 0);
	if (Res)
	{
		xil_printf(" ERROR : f_lseek returned %d\r\n", Res);
		return XST_FAILURE;
	}

	// Read data from file.
	Res = f_read(&fil, (void*)DestinationAddress, f_size(&fil), &NumBytesRead);
	if (Res)
	{
		xil_printf(" ERROR : f_read returned %d\r\n", Res);
		return XST_FAILURE;
	}

	// Close file.
	Res = f_close(&fil);
	if (Res){
		xil_printf(" ERROR : f_close returned %d\r\n", Res);
		return XST_FAILURE;
	}

	Xil_DCacheFlush();
	return XST_SUCCESS;
}
