#include "windowing.h"
#include "matchFilter.h"
#include "antComb.h"
#include "combw.h"
#include "interleaving.h"
#include "demap.h"

#include "InputData.h"
#include "RsData.h"



#include <stdio.h>
#include <xstatus.h>
#include "platform.h"
#include "xil_printf.h"
#include "sdCard.h"
#include "xparameters.h"
#include "xilfpga.h"
#include "xfpga_config.h"
#include "xgpio.h"

char* windowingFileName = "WD.bin";
char* antCombFileName = "AC.bin";
char* matchFilterFileName = "MF.bin";
char* combWFileName = "CW.bin";
char* interleavingFileName = "IL.bin";
char* demapFileName = "DM.bin";
char* fftFileName = "FC.bin";


//#define DELAY_MAX     10000000
#define DELAY_MAX     1
#define CHANNEL_1   1
#define GPIO_OUTPUT 0

#define PARTIAL_BIT_STREAM_SIZE_WORDS	2300000
char PartialBitstream [PARTIAL_BIT_STREAM_SIZE_WORDS];
int iiii;
unsigned int InData [16*MAX_SC];
unsigned int RsData [16*MAX_SC];
unsigned int outData [8*16*MAX_SC];


int main()
{

    XTime prStart, prEnd;
    unsigned int prTime;

	int Status, partial_switch=6;
	volatile int Delay;
	XGpio Gpio_CTRL;

    init_platform();
    xil_printf("start application\r\n");

    // Initialize SD CARD
    Status = SD_Init();
    for (Delay = 0; Delay < DELAY_MAX; Delay++);
    if(Status != XST_SUCCESS)
    {
    	xil_printf("SD-Card initialization failed\n\r");
    	return XST_FAILURE;
    }

	// Initialize the GPIO drivers
	Status = XGpio_Initialize(&Gpio_CTRL, XPAR_GPIO_0_DEVICE_ID);
	if (Status != XST_SUCCESS)
	{
		xil_printf("Gpio Initialization Failed\r\n");
		return XST_FAILURE;
	}
	XGpio_SetDataDirection(&Gpio_CTRL, CHANNEL_1, GPIO_OUTPUT);
	XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 1);

//////////////////////////////////////////////
	while (1)
	{
		for (Delay = 0; Delay < DELAY_MAX; Delay++);
		partial_switch = (partial_switch + 1)%7;
		if(partial_switch == 0)
		{
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 3);
			for(iiii=0; iiii<0x0FFFF; iiii++);
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 2);

			Status = ReadFile(matchFilterFileName, PartialBitstream);
			if(Status != XST_SUCCESS)
				{
				xil_printf("SD-Card readFile failed\n\r");
				break;
				}

			XTime_GetTime(&prStart);
			Status = XFpga_PL_BitStream_Load((u64)PartialBitstream, PARTIAL_BIT_STREAM_SIZE_WORDS, XFPGA_PARTIAL_EN);
			XTime_GetTime(&prEnd);
			prTime = (prEnd-prStart)*100;
			xil_printf("Pr Time matchFilter = %d\n\r", prTime);
			if (Status == XFPGA_SUCCESS)
				xil_printf("matchFilter Kernel: partial reconfiguration is done successfully\n\r");
			else
				{
				xil_printf("matchFilter Kernel: Partial Reconfiguration is failed\n\r");
				break;
				}
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 1);
			for(iiii=0; iiii<0x0FFFF; iiii++);

			matchFilterTest(InData, RsData, outData);
		}
		else if(partial_switch == 1)
		{
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 3);
			for(iiii=0; iiii<0x0FFFF; iiii++);
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 2);

			Status = ReadFile(fftFileName, PartialBitstream);
			if(Status != XST_SUCCESS)
				{
				xil_printf("SD-Card readFile failed\n\r");
				break;
				}
			XTime_GetTime(&prStart);
			Status = XFpga_PL_BitStream_Load((u64)PartialBitstream, PARTIAL_BIT_STREAM_SIZE_WORDS, XFPGA_PARTIAL_EN);
			XTime_GetTime(&prEnd);
			prTime = (prEnd-prStart)*100;
			xil_printf("Pr Time fft = %d\n\r", prTime);
			if (Status == XFPGA_SUCCESS)
				xil_printf("FFT Kernel: partial reconfiguration is done successfully\n\r");
			else
				{
				xil_printf("FFT Kernel: Partial Reconfiguration is failed\n\r");
				break;
				}
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 1);
			for(iiii=0; iiii<0x0FFFF; iiii++);

			fftCalTest(InData, outData);
		}
		else if(partial_switch == 2)
		{
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 3);
			for(iiii=0; iiii<0x0FFFF; iiii++);
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 2);

			Status = ReadFile(windowingFileName, PartialBitstream);
			if(Status != XST_SUCCESS)
				{
				xil_printf("SD-Card readFile failed\n\r");
				break;
				}
			XTime_GetTime(&prStart);
			Status = XFpga_PL_BitStream_Load((u64)PartialBitstream, PARTIAL_BIT_STREAM_SIZE_WORDS, XFPGA_PARTIAL_EN);
			XTime_GetTime(&prEnd);
			prTime = (prEnd-prStart)*100;
			xil_printf("Pr Time Windowing = %d\n\r", prTime);
			if (Status == XFPGA_SUCCESS)
				xil_printf("Windowing Kernel: partial reconfiguration is done successfully\n\r");
			else
				{
				xil_printf("Windowing Kernel: Partial Reconfiguration is failed\n\r");
				break;
				}
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 1);
			for(iiii=0; iiii<0x0FFFF; iiii++);

			windowingTest(InData, outData);
		}
		else if(partial_switch == 3)
		{
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 3);
			for(iiii=0; iiii<0x0FFFF; iiii++);
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 2);

			Status = ReadFile(combWFileName, PartialBitstream);
			if(Status != XST_SUCCESS)
				{
				xil_printf("SD-Card readFile failed\n\r");
				break;
				}
			XTime_GetTime(&prStart);
			Status = XFpga_PL_BitStream_Load((u64)PartialBitstream, PARTIAL_BIT_STREAM_SIZE_WORDS, XFPGA_PARTIAL_EN);
			XTime_GetTime(&prEnd);
			prTime = (prEnd-prStart)*100;
			xil_printf("Pr Time combW = %d\n\r", prTime);
			if (Status == XFPGA_SUCCESS)
				xil_printf("combW Kernel: partial reconfiguration is done successfully\n\r");
			else
				{
				xil_printf("combW Kernel: Partial Reconfiguration is failed\n\r");
				break;
				}
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 1);
			for(iiii=0; iiii<0x0FFFF; iiii++);

			combWTest(InData, outData);
		}
		else if(partial_switch == 4)
		{
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 3);
			for(iiii=0; iiii<0x0FFFF; iiii++);
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 2);

			Status = ReadFile(antCombFileName, PartialBitstream);
			if(Status != XST_SUCCESS)
				{
				xil_printf("SD-Card readFile failed\n\r");
				break;
				}
			XTime_GetTime(&prStart);
			Status = XFpga_PL_BitStream_Load((u64)PartialBitstream, PARTIAL_BIT_STREAM_SIZE_WORDS, XFPGA_PARTIAL_EN);
			XTime_GetTime(&prEnd);
			prTime = (prEnd-prStart)*100;
			xil_printf("Pr Time antComb = %d\n\r", prTime);
			if (Status == XFPGA_SUCCESS)
				xil_printf("antComb Kernel: partial reconfiguration is done successfully\n\r");
			else
				{
				xil_printf("antComb Kernel: Partial Reconfiguration is failed\n\r");
				break;
				}
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 1);
			for(iiii=0; iiii<0x0FFFF; iiii++);

			antCombTest(InData, RsData, outData);
		}
		else if(partial_switch == 5)
		{
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 3);
			for(iiii=0; iiii<0x0FFFF; iiii++);
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 2);

			Status = ReadFile(interleavingFileName, PartialBitstream);
			if(Status != XST_SUCCESS)
				{
				xil_printf("SD-Card readFile failed\n\r");
				break;
				}
			XTime_GetTime(&prStart);
			Status = XFpga_PL_BitStream_Load((u64)PartialBitstream, PARTIAL_BIT_STREAM_SIZE_WORDS, XFPGA_PARTIAL_EN);
			XTime_GetTime(&prEnd);
			prTime = (prEnd-prStart)*100;
			xil_printf("Pr Time interleaving = %d\n\r", prTime);
			if (Status == XFPGA_SUCCESS)
				xil_printf("interleaving Kernel: partial reconfiguration is done successfully\n\r");
			else
				{
				xil_printf("interleaving Kernel: Partial Reconfiguration is failed\n\r");
				break;
				}
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 1);
			for(iiii=0; iiii<0x0FFFF; iiii++);

			interleavingTest(InData, outData);
		}
		else if(partial_switch == 6)
		{
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 3);
			for(iiii=0; iiii<0x0FFFF; iiii++);
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 2);

			Status = ReadFile(demapFileName, PartialBitstream);
			if(Status != XST_SUCCESS)
				{
				xil_printf("SD-Card readFile failed\n\r");
				break;
				}
			XTime_GetTime(&prStart);
			Status = XFpga_PL_BitStream_Load((u64)PartialBitstream, PARTIAL_BIT_STREAM_SIZE_WORDS, XFPGA_PARTIAL_EN);
			XTime_GetTime(&prEnd);
			prTime = (prEnd-prStart)*100;
			xil_printf("Pr Time demap = %d\n\r", prTime);
			if (Status == XFPGA_SUCCESS)
				xil_printf("demap kernel: partial reconfiguration is done successfully\n\r");
			else
				{
				xil_printf("demap kernel: Partial Reconfiguration is failed\n\r");
				break;
				}
			XGpio_DiscreteWrite(&Gpio_CTRL, CHANNEL_1, 1);
			for(iiii=0; iiii<0x0FFFF; iiii++);

			DemapTest(InData, outData);
		}


	}

    SD_Eject();
    cleanup_platform();
    return 0;
}
