/*******************************************************************************
 *                      LTE UPLINK RECEIVER PHY BENCHMARK                      *
 *                                                                             *
 * This file is distributed under the license terms given by LICENSE.TXT       *
 ******************************************************************************/

#ifndef _KERNEL_DEF_H
#define _KERNEL_DEF_H

#include "complex_def.h"

/* Radio Interface (RAT) parameters */

#ifndef MAX_BS
#define MAX_BS                            1           // Each host is going to support a maximum of users from 2BS
#endif /* MAX_BS */
#define MAX_SC                            12*100    // Assuming PRB allocation/UE to upto 120 in the worst case
#define MAX_RB                            100
#define SC_PER_RB	  	                  (MAX_SC/MAX_RB)
#define MAX_USERS                         10
#define MIMO_CONFIGURATION                4
#define RX_ANT                            MIMO_CONFIGURATION
#define MAX_LAYERS                        MIMO_CONFIGURATION
#define NMB_SLOT                          2
#define OFDM_IN_SLOT                      2 //7
#define SAMPLES                           3000
#define BETA                              18455
#define ALPHA                             2300


#define NO_TIMING_DUMP   // Do not create large arrays to store timing information

typedef enum {
	MOD_PSK = 1,
	MOD_QPSK = 2,
	MOD_16QAM = 4,
	MOD_64QAM = 6,
	MOD_256QAM = 8
} mod_type;

typedef complex scData_t[MAX_SC];
typedef scData_t rxData_t[RX_ANT];
typedef rxData_t layerData_t[MAX_LAYERS];

typedef complex weight_t[RX_ANT];
typedef weight_t weightSC_t[MAX_SC];

typedef complex complexMatrix_t[RX_ANT][MAX_LAYERS];
typedef complex channelEst_t[RX_ANT][MAX_LAYERS][MAX_RB];
typedef scData_t combWeights_t[MAX_LAYERS][RX_ANT];
typedef complex combWeightsPerLayer_t[MAX_SC][RX_ANT];
typedef int __fixed;

#endif
