#include "demap.h"


complex vector_in1[2*(OFDM_IN_SLOT-1)*MAX_SC*MAX_LAYERS];
int vector_out[2*2*(OFDM_IN_SLOT-1)*MAX_SC*MOD_64QAM*MAX_LAYERS];


void soft_demap(complex* in, int scaling_factor, int mod, int n, int* out, int* err) {
  int L;
  int i,k;
  *err=0;
  switch (mod) {
  case MOD_PSK:
    {
      int ind = 0;
      for (i=0; i<n; i++) {
		out[ind++] = in[i].re * scaling_factor;
      }
    }
    break;
  case MOD_QPSK:
    {
      int ind = 0;
      complex exp_pi4, temp;
      exp_pi4.re = 4096;
      exp_pi4.im = -4096;
      for (i=0; i<n; i++) {
		temp = cmul(in[i], exp_pi4);
		out[ind++] = (temp.re * scaling_factor)%255;
		out[ind++] = (temp.im * scaling_factor)%255;
      }
    }
    break;
  case MOD_16QAM:
    {
      int temp_real, temp_imag;
      int ind = 0;

      for (i=0; i<n; i++) {
		for (k=0; k<4; k++) {
	  		L = k*4096;
	  		temp_real = (int)(((L - 1) - ((in[i].re * scaling_factor)>>8) + (L - 1)) / 2.0);
	  		temp_imag = (int)(((L - 1) - ((in[i].im * scaling_factor)>>8) + (L - 1)) / 2.0);
	  		if (temp_real < 0)
	  		  temp_real = 0;
	  		else if (temp_real > (L - 1))
	  		  temp_real = (L - 1);
	  		if (temp_imag < 0)
	  		  temp_imag = 0;
	  		else if (temp_imag > (L - 1))
	  		  temp_imag = (L - 1);
	  		out[ind++] = temp_real%255;
	  		out[ind++] = temp_imag%255;
		}
      }
    }
    break;
  case MOD_64QAM:
    {
      int temp_real, temp_imag;
      int ind = 0;

      for (i=0; i<n; i++) {
		for (k=0; k<6; k++) {
	  		L = k*4096;
	  		temp_real = (int)(((L - 1) - ((in[i].re * scaling_factor)>>8) + (L - 1)) / 2.0);
	  		temp_imag = (int)(((L - 1) - ((in[i].im * scaling_factor)>>8) + (L - 1)) / 2.0);
	  		if (temp_real < 0)
	  		  temp_real = 0;
	  		else if (temp_real > (L - 1))
	  		  temp_real = (L - 1);
	  		if (temp_imag < 0)
	  		  temp_imag = 0;
	  		else if (temp_imag > (L - 1))
	  		  temp_imag = (L - 1);
	  		out[ind++] = temp_real%255;
	  		out[ind++] = temp_imag%255;
		}
      }
    }
    break;
  case MOD_256QAM:
    {
      int temp_real, temp_imag;
      int ind = 0;

      for (i=0; i<n; i++) {
		for (k=0; k<8; k++) {
	  		L = k*4096;
	  		temp_real = (int)(((L - 1) - ((in[i].re * scaling_factor)>>8) + (L - 1)) / 2.0);
	  		temp_imag = (int)(((L - 1) - ((in[i].im * scaling_factor)>>8) + (L - 1)) / 2.0);
	  		if (temp_real < 0)
	  		  temp_real = 0;
	  		else if (temp_real > (L - 1))
	  		  temp_real = (L - 1);
	  		if (temp_imag < 0)
	  		  temp_imag = 0;
	  		else if (temp_imag > (L - 1))
	  		  temp_imag = (L - 1);
	  		out[ind++] = temp_real%255;
	  		out[ind++] = temp_imag%255;
		}
      }
    }
    break;
  default:
	  *err=1;
  }
}

void DemapTest(unsigned int InData [2*(OFDM_IN_SLOT-1)*MAX_SC*MAX_LAYERS], unsigned int outData [2*2*(OFDM_IN_SLOT-1)*MAX_SC*MOD_256QAM*MAX_LAYERS])
{
    int status;
    unsigned int tmpVal;
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);
    tmpVal = Xil_In32 ( XPAR_AXI_DMA_0_BASEADDR + 0x0 );
    tmpVal = tmpVal | 0x0001;
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x00 , tmpVal); // MM2S Control Reset
    tmpVal = Xil_In32 ( XPAR_AXI_DMA_0_BASEADDR + 0x30 );
    tmpVal = tmpVal | 0x0001;
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x30 , tmpVal); // S2MM Control Reset
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);

    unsigned int inputDataSize, outputDataSize;
    u32 pLSB, pMSB;

    int nmbRB	 = 100;
	int scale 	 = 3;
	int mod		 = MOD_64QAM;
	int nmbSc 	 = nmbRB*6;

	int ii=0;
	for(ii=0; ii<(2*(OFDM_IN_SLOT-1)*MAX_SC*MAX_LAYERS); ii++)
	{
		vector_in1[ii].re = (InData[ii]&0xFFFF);
		vector_in1[ii].im = ((InData[ii]>>16)&0xFFFF);
	}
    XTime tStart1, tEnd1;
    int software_Out_Err;
    unsigned int tmp1;
    XTime_GetTime(&tStart1);
    soft_demap(vector_in1, scale, mod, 2*(OFDM_IN_SLOT-1)*nmbSc*MAX_LAYERS, vector_out, &software_Out_Err);
	XTime_GetTime(&tEnd1);

    Xil_DCacheDisable();
    //Send data to the In-memory via DMA
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x08, 0); //Mem Select
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x0C, 1); //Restart Mem1 address
    inputDataSize = 2*(OFDM_IN_SLOT-1)*MAX_SC*MAX_LAYERS;
    pLSB = (u32)(uint64_t)InData;
    pMSB = (u32)((uint64_t)InData>>32);
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x18 , pLSB); 	   // MM2S Source LSB Address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x1c , pMSB); // MM2S Source MSB Address
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x28 , inputDataSize*4);  	  // MM2S Transfer Length (Bytes)
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    while((status & 0x02) == 0)
    	status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);



    XTime tStart, tEnd;
    unsigned int tmp;
    int hardware_Out_Err;
    //Start the Kernel

    int times[100];
    int iii;
    int inSize;
    for(iii=0; iii<1; iii++)
    {

    	inSize = 2*(OFDM_IN_SLOT-1)*1200;//(iii+1)*12;

		Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 32, inSize); //set SC
		Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 28, mod); //set mode
		Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 24, scale); //set scale

		XTime_GetTime(&tStart);
		Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 36, 1); //set Start
		while(!(Xil_In32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 60)&0x01));
		XTime_GetTime(&tEnd);
		status = Xil_In32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 60);
		times[iii] = tEnd - tStart;

    }


	//Read Data Out Back via DMA
    outputDataSize = 2*2*(OFDM_IN_SLOT-1)*MAX_SC*MOD_64QAM*MAX_LAYERS;
    pLSB = (u32)(uint64_t)outData;
    pMSB = (u32)((uint64_t)outData>>32);
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x48 , pLSB);	  // S2MM Source LSB Address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x4c , pMSB); // S2MM Source MSB Address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x58 , outputDataSize*4);  // S2MM Transfer Length (Bytes)
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x08, 32); //Mem Select
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x04, outputDataSize); //Mem Out Size
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x0C, 2); //Restart Mem1 address
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);
    while((status & 0x02) == 0)
    	status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);
    hardware_Out_Err=Xil_In32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 64);




	//Test the output
    //float tmp = 1.0 * (tEnd - tStart) / (COUNTS_PER_SECOND/1000000);
	tmp = 10 * (tEnd - tStart);
	tmp1 = 10 * (tEnd1 - tStart1);
    xil_printf("Hardware (%.2f), Software (%.2f) ns.\n", tmp, tmp1);

	if(hardware_Out_Err != software_Out_Err)
		xil_printf("Error %d != %d\n", hardware_Out_Err, software_Out_Err);
	for(ii=0; ii<2*2*(OFDM_IN_SLOT-1)*MAX_SC*MOD_256QAM*MAX_LAYERS; ii++)
	{
		if((vector_out[ii]&0x000000FF) != (outData[ii]&0x000000FF))
			xil_printf("Error %d, %d, %d\n", ii, vector_out[ii]&0x000000FF, outData[ii]&0x000000FF);
	}


}




