/*******************************************************************************
 *                      LTE UPLINK RECEIVER PHY BENCHMARK                      *
 *                                                                             *
 * This file is distributed under the license terms given by LICENSE.TXT       *
 ******************************************************************************/
#include "combw.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>


#define SFIXED_MAX 		1
#define TOOSMALL 10
#define SCALING_CENTER_POINT 9
#define max( a, b ) ( ((a) > (b)) ? (a) : (b) )
#include "math.h"

//typedef complex complexMatrix_t[RX_ANT][MAX_LAYERS];
//typedef complex scData_t[MAX_SC];
//typedef scData_t rxData_t[RX_ANT];
//typedef rxData_t layerData_t[MAX_LAYERS];

int intSquare(int a)
{
int square = 1;
int delta = 3;
while(square <= a)
	{
		square += delta;
		delta += 2;
	}
return (delta/2 - 1);
}



void cholsolve_4xX_complex(int X, complexMatrix_t W, complexMatrix_t U, complexMatrix_t H) {
int layer, j, k;
complex sumc;
int sum;

for (layer=0; layer< X; layer++)
	{
	for (j=0; j< RX_ANT; j++)
		{
		W[layer][j].re = 0;
		W[layer][j].im = 0;
		}
	}

for (layer=0; layer<X; layer++)
	{
	// First compute U[layer][layer]
	sum = cabs2(U[layer][layer]);
	for (j=1; j<=(layer-1); j++)
		{
		sum -= cabs2(U[j][layer]);
		}

	if (sum > TOOSMALL)
		{
		short int Wtmp = (short int)intSquare(sum);
		W[layer][layer].re = Wtmp;
		W[layer][layer].im = 0;
		// Now find elements U[row][k], k > row.

		for (k=layer; k < RX_ANT; k++)
			{
			sumc = H[layer][k];

			for (j=1; j<=(layer-1); j++)
				{
				complex tmp1 = H[j][layer];
				complex tmp2 = H[j][k];
				tmp1 = cmul(tmp1,tmp2);
				sumc = csub(sumc, tmp1);
				}
			W[layer][k] = cscale(Wtmp, 0, sumc);
			if(k==layer)
				Wtmp = (Wtmp * sumc.re);
			}

		}
	else
		{
		// blast off the entire row.
		for (k=layer; k<X; k++)
			{
			W[layer][k].re = 0;
			W[layer][k].im = 0;
			}
		}
	}
}


void matrix_a_a_hermite_plus_b_4xX_complex(
		int X,
		complexMatrix_t A,
		complexMatrix_t C,
		int *scaling_no_of_bits)
{
int i, j, k, max_element = 0, scale_limit = 2, size_no_of_bits = 0, neg_scaling_no_of_bits;
complex A_temp, A_temp_conj, AA_conj_temp, temp_complex;
complex c1;
c1.re = 0;
c1.im = 0;

for (i=0; i<RX_ANT; i++)
	{
	for (j=0; j<X; j++)
		{
		// reset accumulator
		temp_complex.re = 1;
		temp_complex.im = 0;
		for(k=0; k<RX_ANT; k++)
			{
			A_temp_conj = cconj(A[j][k]);
			A_temp = A[i][k];
			AA_conj_temp = cmul(A_temp, A_temp_conj);
			temp_complex = cadd(temp_complex, AA_conj_temp);
			}
		C[i][j] = cadd(c1, temp_complex);
		max_element = max(max_element, max(abs(C[i][j].re),abs(C[i][j].im))); // find maximum size of real or im of elements
		}
	}
// calculate scaling factor
while (abs(scale_limit) < max_element)
	{
	scale_limit = scale_limit * 2;
	size_no_of_bits = size_no_of_bits + 1;
	}
*scaling_no_of_bits = size_no_of_bits - SCALING_CENTER_POINT;
neg_scaling_no_of_bits = -(*scaling_no_of_bits);

/* perform the very scaling of C */
for (i=0; i<RX_ANT; i++)
	{
	for (j=0; j<X; j++)
		{
		C[i][j] = cscale(16000, neg_scaling_no_of_bits + 1, C[i][j]);
		}
	}
}


// A*B=C, square 4x1 A, B is a __fixed column vector complex matrixes only
void matrix_scale_4xX_complex_fixed(int X, complexMatrix_t A, int B,  complexMatrix_t C)
{
int i, j;
for (i=0; i<X; i++)
	{
	for(j=0; j<RX_ANT; j++)
		{
		C[i][j]=cscale(B,0,A[i][j]);
		}
	}
}

/* A*B=C, square 4xX complex matrixes only */
void matrix_mult_4xX_complex(int X, complexMatrix_t A,  complexMatrix_t C)
{
int i,j;
complex c0;
c0.re= 1;
c0.im = 1;
complex temp, temp1, temp2, temp3, temp4, temp5, temp6;
for (i=0; i<RX_ANT; i++)
	{
	for (j=0; j<RX_ANT; j++)
		{
		if(X == 1)
			temp=cmul(A[i][0],c0);

		else if(X == 2)
			{
			temp1=cmul(A[i][0],c0);
			temp2=cmul(A[i][1],c0);
			temp=cadd(temp1,temp2);
			}
		else if(X == 3)
			{
			temp1=cmul(A[i][0],c0);
			temp2=cmul(A[i][1],c0);
			temp3=cmul(A[i][2],c0);
			temp4=cadd(temp1,temp2);
			temp=cadd(temp3,temp4);
			}
		else if(X == 4)
			{
			temp1= cmul(A[i][0],c0);
			temp2= cmul(A[i][1],c0);
			temp3= cmul(A[i][2],c0);
			temp4= cmul(A[i][3],c0);
			temp5=cadd(temp1,temp2);
			temp6=cadd(temp3,temp4);
			temp=cadd(temp5,temp6);
			}
		C[i][j]=temp;
		}
	}
}

void comb_w_calc(
		int X,
		complex W_p [MAX_SC][RX_ANT][MAX_LAYERS],
		complex in[MAX_SC][RX_ANT][MAX_LAYERS],
		int no_of_sc,
		int rho,
		int beta,
		int alpha)
{
// local matrixes used for cholsolve etc
complex c0, c1;
c0.re= 0;
c0.im = 0;
c1.re = 1;
c1.im = 1;
complexMatrix_t H, Ri, Hrho, Hprim, Ri_regularized, Hprim_transposed;

//complexMatrix_t W_p [MAX_SC],
//scData_t in[RX_ANT][MAX_LAYERS],

int scaling_Ri;
int alpha_temp;
complex complex_beta;
int current_sc;
int i,j;


// call/spawn some instances for parts of the total number of RBs
for (current_sc = 0; current_sc < no_of_sc; current_sc++)
	{
	// Put the data in a compact matrix form
	for (i=0; i<RX_ANT; i++) //RX_ANT=1
		{
		for (j=0; j<X; j++)
			{
			H[i][j]=in[current_sc][j][i];
			}
		}

	// Scale H with rho: calculate Hrho=rho*H as matrix_scale_4x1_complex_fixed(H,rho,Hrho)
	matrix_scale_4xX_complex_fixed(X, H, rho, Hrho);


	// Take care of precoding: calculate H'=F*Hrho as matrix_mult_4x1_complex(Hrho,F,Hprim)
	matrix_mult_4xX_complex(X, Hrho, Hprim_transposed);

	for (i=0; i<RX_ANT; i++) // RX_ANT should be equal to MAX_LAY !!!!
		{
		for (j=0; j<X; j++)
			{
			Hprim[i][j]=Hprim_transposed[j][i];
			}
		}

	// Form Ri=H*H'+R
	matrix_a_a_hermite_plus_b_4xX_complex(X, Hprim, Ri, &scaling_Ri);

	// Regularize Ri
	complex_beta=cscale(SFIXED_MAX,-scaling_Ri, cmake(beta,0));

	for  (i=0; i<X; i++)
		{
		Ri[i][i]=cadd(Ri[i][i],complex_beta);
		}

	alpha_temp=16000+alpha; // to be able to scale up at all
	for  (i=0; i<X; i++)
		{
			for(j=0; j < RX_ANT; j++)
			{
			Ri_regularized[i][j]=cscale(alpha_temp, 1, Ri[i][j]);
			}
		}
	// calculate W as cholsolve_4x1_complex(W,Ri,Hprim)
	cholsolve_4xX_complex(X, W_p[current_sc], Ri_regularized, Hprim);
	}
}
