/*
 * antComb.c
 *
 *  Created on: Sep 3, 2021
 *      Author: alho343c
 */
#include "antComb.h"

complex vector_in1[4][MAX_SC];
complex vector_in2[4][MAX_SC];
complex vector_out[MAX_SC];

void Sw_ant_comb(complex in[4][MAX_SC], complex w [4][MAX_SC], int n, complex* out) {
  int i;
  complex a0, a1, a2, a3, a01, a23;

  /* Calc the weigthed combination of the input data */
  for ( i = 0; i < n; i++ ) {
    a0 = cmul(in[0][i], w[0][i]);
    a1 = cmul(in[1][i], w[1][i]);
    a2 = cmul(in[2][i], w[2][i]);
    a3 = cmul(in[3][i], w[3][i]);
    a01 = cadd(a0, a1);
    a23 = cadd(a2, a3);
    out[i] = cadd(a01, a23);
  }
}

int antCombTest(unsigned int InData [4*MAX_SC], unsigned int RsData [4*MAX_SC], unsigned int outData [4*MAX_SC])
{

    int status;
    unsigned int tmpVal;
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);
    tmpVal = Xil_In32 ( XPAR_AXI_DMA_0_BASEADDR + 0x0 );
    tmpVal = tmpVal | 0x0001;
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x00 , tmpVal); // MM2S Control Reset
    tmpVal = Xil_In32 ( XPAR_AXI_DMA_0_BASEADDR + 0x30 );
    tmpVal = tmpVal | 0x0001;
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x30 , tmpVal); // S2MM Control Reset
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);



    int nmbRB	 = 100;
	int power 	 = 0;
	int nmbSc 	 = nmbRB*12;


	int ii=0,jj=0;
	for(jj=0;jj<4;jj++)
		for(ii=0; ii<MAX_SC; ii++)
		{
			vector_in1[jj][ii].re = (InData[jj*MAX_SC+ii]&0xFFFF);
			vector_in1[jj][ii].im = ((InData[jj*MAX_SC+ii]>>16)&0xFFFF);
			vector_in2[jj][ii].re = (RsData[jj*MAX_SC+ii]&0xFFFF);
			vector_in2[jj][ii].im = ((RsData[jj*MAX_SC+ii]>>16)&0xFFFF);
		}
    XTime tStart1, tEnd1;
    unsigned int tmp1;
    XTime_GetTime(&tStart1);
    Sw_ant_comb(vector_in1,vector_in2,nmbSc,vector_out);
	XTime_GetTime(&tEnd1);


    Xil_DCacheDisable();
    unsigned int inputDataSize, outputDataSize;
    u32 pLSB, pMSB;

    //Send data to the In-memory via DMA
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x08, 0); //Mem Select
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x0C, 1); //Restart Mem1 address
    inputDataSize = 4*1200;
    pLSB = (u32)(uint64_t)InData;
    pMSB = (u32)((uint64_t)InData>>32);
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x18 , pLSB); 	   // MM2S Source LSB Address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x1c , pMSB); // MM2S Source MSB Address
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x28 , inputDataSize*4);  	  // MM2S Transfer Length (Bytes)
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    while((status & 0x02) == 0)
    	status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);

    //Send data to the Rs-memory via DMA
    inputDataSize = 4*1200;
    pLSB = (u32)(uint64_t)RsData;
    pMSB = (u32)((uint64_t)RsData>>32);
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x08, 16); //Mem Select
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x0C, 1); //Restart Mem1 address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x18 , pLSB); 	  // MM2S Source LSB Address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x1c , pMSB); // MM2S Source MSB Address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x28 , inputDataSize*4);  	  // MM2S Transfer Length (Bytes)
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);
    while((status & 0x02) == 0)
    	status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x04);

    XTime tStart, tEnd;
    unsigned int tmp;
    //Start the Kernel
    int times[100];
    int iii;
    for(iii=0; iii<100; iii++)
    {
    	int SC = (iii+1)*12;
		Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 28, 1); //set lay
		Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 32, SC); //set SC
		XTime_GetTime(&tStart);
		Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 36, 1); //set Start
		while(!(Xil_In32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 60)&0x01));
		XTime_GetTime(&tEnd);
		times[iii] = tEnd - tStart;
    }
	//Read Data Out Back via DMA
    outputDataSize = 1200;
    pLSB = (u32)(uint64_t)outData;
    pMSB = (u32)((uint64_t)outData>>32);
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x48 , pLSB);	  // S2MM Source LSB Address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x4c , pMSB); // S2MM Source MSB Address
    Xil_Out32  (XPAR_AXI_DMA_0_BASEADDR + 0x58 , outputDataSize*4);  // S2MM Transfer Length (Bytes)
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x08, 32); //Mem Select
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x04, outputDataSize); //Mem Out Size
    Xil_Out32(XPAR_BUFFERS_CONTROL_AXI_BASEADDR + 0x0C, 2); //Restart Mem1 address
    status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);
    while((status & 0x02) == 0)
    	status = Xil_In32(XPAR_AXI_DMA_0_BASEADDR + 0x34);

/*
    tmp = 1.0 * (tEnd - tStart) / (COUNTS_PER_SECOND/1000000);
    tmp1 = 1.0 * (tEnd1 - tStart1) / (COUNTS_PER_SECOND/1000000);
    xil_printf("Hardware (%.2f), Software (%.2f) us.\n", tmp, tmp1);
*/
	tmp = 10 * (tEnd - tStart);
	tmp1 = 10 * (tEnd1 - tStart1);
    xil_printf("Hardware (%.2f), Software (%.2f) ns.\n", tmp, tmp1);

	//Test the output
	for(ii=0; ii<MAX_SC; ii++)
	{
		complex tmp;
		tmp.re = (outData[ii]&0xFFFF);
		tmp.im = ((outData[ii]>>16)&0xFFFF);
		if((tmp.re != vector_out[ii].re) || (tmp.im != vector_out[ii].im))
			xil_printf("Error %d, %d(%d), %d(%d)\n", ii, tmp.re, vector_out[ii].re, tmp.im, vector_out[ii].im);
	}


}
