#define MAX_SC	          1200
#define MAX_LAY			  4

#define IS_HLS
#ifdef IS_HLS
#define PRAGMA_SUB(x) _Pragma (#x)
#define DO_PRAGMA(x) PRAGMA_SUB(x)
#endif

typedef struct
{
  short int re;
  short int im;
} complex;

complex cmul(complex a, complex b)
{
complex t;

t.re = a.re * b.re - a.im * b.im;
t.im = a.im * b.re + a.re * b.im;

return t;
}

void mf(complex in[MAX_LAY][MAX_SC], complex rs[MAX_LAY][MAX_SC], int n, int lay, complex out[MAX_LAY][MAX_SC], int power[MAX_LAY])
{

#ifdef IS_HLS
#pragma HLS DATA_PACK variable=in
#pragma HLS DATA_PACK variable=rs
#pragma HLS DATA_PACK variable=out
#pragma HLS ARRAY_PARTITION variable=power complete dim=1
#pragma HLS RESOURCE variable=in core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=out core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=rs core=RAM_1P_BRAM
#endif
	

int i,j;
int ptot = 0;
for(j=0; j<lay; j++)
	{
	#ifdef IS_HLS
	#pragma HLS PIPELINE
	DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAY)
	#endif
	for (i=0; i<n; i++)
		{
		#ifdef IS_HLS
		#pragma HLS PIPELINE
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SC)
		#endif
		ptot += in[j][i].re * in[j][i].re + in[j][i].im * in[j][i].im;
		out[j][i] = cmul(in[j][i], rs[j][i]);
		}
	power[j] = ptot;
	ptot=0;
	}
}
