#define MAX_SC	    1200
#define MAX_LAY     4

#define IS_HLS
typedef struct {
  short int re;
  short int im;
} complex;


#ifdef IS_HLS
#define PRAGMA_SUB(x) _Pragma (#x)
#define DO_PRAGMA(x) PRAGMA_SUB(x)
#endif

void interleave(complex in[MAX_LAY][MAX_SC], complex out[MAX_LAY][MAX_SC], int n, int lay)
{
#ifdef IS_HLS
#pragma HLS DATA_PACK variable=in
#pragma HLS DATA_PACK variable=out
#pragma HLS RESOURCE variable=in core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=out core=RAM_1P_BRAM
#endif
	int s;
	int i;
	int c = 0;
	int r = 0;
	int cols = 12;
	int rows = 7;
	int steps = n/(rows*cols);
int j;
for (j=0;j<lay;j++)
{
#ifdef IS_HLS
#pragma HLS PIPELINE
DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAY)
#endif
	for (s = 0; s < steps; s++) 
	{
	#ifdef IS_HLS
	#pragma HLS PIPELINE
	DO_PRAGMA(HLS LOOP_TRIPCOUNT max=14)
	#endif	
		for (c = 0; c < cols; c++) 
		{
		#ifdef IS_HLS
		#pragma HLS PIPELINE
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=12)
		#endif	
			for (r = 0; r < rows; r++) 
			{
				#ifdef IS_HLS
				#pragma HLS PIPELINE
				DO_PRAGMA(HLS LOOP_TRIPCOUNT max=7)
				#endif		  
				out[j][s*rows*cols + r*cols + c] = in[j][s*rows*cols + c*rows + r];
			}
		}
	}

	for (i=(s-1)*rows*cols + (r-1)*cols + c; i<n; i++)
	{
	#ifdef IS_HLS
	#pragma HLS PIPELINE
	DO_PRAGMA(HLS LOOP_TRIPCOUNT max=83) //(7*12-1))
	#endif	
		out[j][i] = in[j][i];
	}
}
}
