#define TAP_FAC	4
#define MAX_SC	1200
#define MAX_LAY	4
#define IS_HLS

#ifdef IS_HLS
#define PRAGMA_SUB(x) _Pragma (#x)
#define DO_PRAGMA(x) PRAGMA_SUB(x)
#endif

typedef struct {
  short int re;
  short int im;
} complex;

void chest(complex in[MAX_LAY][MAX_SC], volatile unsigned int in_power [MAX_LAY], int n, int lay, complex out[MAX_LAY][MAX_SC], unsigned int out_power[MAX_LAY])
{

#ifdef IS_HLS
#pragma HLS DATA_PACK variable=out
#pragma HLS DATA_PACK variable=in
#pragma HLS ARRAY_PARTITION variable=in_power complete dim=1
#pragma HLS ARRAY_PARTITION variable=out_power complete dim=1
#pragma HLS RESOURCE variable=in core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=out core=RAM_1P_BRAM
#endif


int i, j, k;


int used_sc = n/TAP_FAC;    // n will always be >= 12 and possible to divide by 4

// Calc used power


for(k=0; k<lay; k++)
	{
		#ifdef IS_HLS
		#pragma HLS PIPELINE
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAY)
		#endif
		long int ptot = 0;
		for (i=0; i<used_sc; i++)
			{
			#ifdef IS_HLS
			#pragma HLS PIPELINE
			DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SC/TAP_FAC)
			#endif
			ptot += in[k][i].re * in[k][i].re + in[k][i].im * in[k][i].im;
			out[k][i] = in[k][i];
			}

		// Reset the rest of the coefficients
		for (j=used_sc; j<n; j++)
			{
			#ifdef IS_HLS
			#pragma HLS PIPELINE
			DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SC-(MAX_SC/TAP_FAC))
			#endif
			out[k][j].re = 0;
			out[k][j].im = 0;
			}
		unsigned int ptot2;
		ptot2 = (unsigned int)(ptot >> 16);
		if(in_power[k] < ptot2)
			out_power[k] = 1;
		else
			out_power[k] = in_power[k] - ptot2;
	}
}
