#define OFDM_IN_SLOT  7
#define RX_ANT	      4
#define MAX_LAY	  4
#define MAX_SC	      1200


#define IS_HLS
typedef struct {
  short int re;
  short int im;
} complex;


#ifdef IS_HLS
#define PRAGMA_SUB(x) _Pragma (#x)
#define DO_PRAGMA(x) PRAGMA_SUB(x)
#endif

complex cmul(complex a, complex b)
{
	complex t;
	t.re = a.re * b.re - a.im * b.im;
	t.im = a.im * b.re + a.re * b.im;
	return t;
}

complex cadd(complex a, complex b)
{
  complex t;
  t.re = a.re + b.re;
  t.im = a.im + b.im;
  return t;
}




void ant_comb(complex in[MAX_LAY][RX_ANT][MAX_SC], complex w[MAX_LAY][RX_ANT][MAX_SC], int n, int lay, complex out[MAX_LAY][MAX_SC])
{
#ifdef IS_HLS
#pragma HLS DATA_PACK variable=in
#pragma HLS DATA_PACK variable=w
#pragma HLS DATA_PACK variable=out
#pragma HLS RESOURCE variable=in core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=w core=RAM_1P_BRAM
#pragma HLS RESOURCE variable=out core=RAM_1P_BRAM
#endif
	int j;
	for(j=0; j<lay; j++)
	{
		#ifdef IS_HLS
		#pragma HLS PIPELINE
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_LAY)
		#endif
		int i;
		complex a0, a1, a2, a3, a01, a23;
		// Calc the weigthed combination of the input data
		for ( i = 0; i < n; i++ )
		{
		#ifdef IS_HLS
		#pragma HLS PIPELINE
		DO_PRAGMA(HLS LOOP_TRIPCOUNT max=MAX_SC)
		#endif
			a0 = cmul(in[j][0][i], w[j][0][i]);
			a1 = cmul(in[j][1][i], w[j][1][i]);
			a2 = cmul(in[j][2][i], w[j][2][i]);
			a3 = cmul(in[j][3][i], w[j][3][i]);
			a01 = cadd(a0, a1);
			a23 = cadd(a2, a3);
			out[j][i] = cadd(a01, a23);
		}
	}
}
